/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.chart.property.descriptor.seriescolor.dialog;

import com.jaspersoft.studio.components.chart.messages.Messages;
import com.jaspersoft.studio.components.chart.property.descriptor.seriescolor.dialog.SeriesColorDTO;
import com.jaspersoft.studio.property.descriptor.NullEnum;
import com.jaspersoft.studio.property.descriptor.color.ColorCellEditor;
import com.jaspersoft.studio.property.descriptor.color.ColorLabelProvider;
import com.jaspersoft.studio.swt.widgets.table.DeleteButton;
import com.jaspersoft.studio.swt.widgets.table.INewElement;
import com.jaspersoft.studio.swt.widgets.table.ListContentProvider;
import com.jaspersoft.studio.swt.widgets.table.ListOrderButtons;
import com.jaspersoft.studio.swt.widgets.table.NewButton;
import com.jaspersoft.studio.utils.AlfaRGB;
import com.jaspersoft.studio.utils.Colors;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.SortedSet;
import net.sf.jasperreports.engine.base.JRBaseChartPlot;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class SeriesColorPage
extends WizardPage {
    private List<SeriesColorDTO> value;
    private Table table;
    private TableViewer tableViewer;

    public Collection<JRBaseChartPlot.JRBaseSeriesColor> getValue() {
        ArrayList<JRBaseChartPlot.JRBaseSeriesColor> lst = new ArrayList<JRBaseChartPlot.JRBaseSeriesColor>();
        int i = 0;
        for (SeriesColorDTO p : this.value) {
            lst.add(new JRBaseChartPlot.JRBaseSeriesColor(i++, p.getValue()));
        }
        return lst;
    }

    public void dispose() {
        super.dispose();
    }

    public void setValue(SortedSet<JRBaseChartPlot.JRBaseSeriesColor> val) {
        this.value = new ArrayList<SeriesColorDTO>();
        if (val != null) {
            for (JRBaseChartPlot.JRBaseSeriesColor bs : val) {
                this.value.add(new SeriesColorDTO(bs.getColor()));
            }
        }
        if (this.table != null) {
            this.fillTable(this.table);
        }
    }

    protected SeriesColorPage(String pageName) {
        super(pageName);
        this.setTitle(Messages.common_series_colors);
        this.setDescription(Messages.SeriesColorPage_description);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        composite.setLayout((Layout)new GridLayout(2, false));
        this.setControl((Control)composite);
        this.buildTable(composite);
        Composite bGroup = new Composite(composite, 0);
        bGroup.setLayout((Layout)new GridLayout(1, false));
        bGroup.setLayoutData((Object)new GridData(1040));
        bGroup.setBackground(composite.getBackground());
        new NewButton().createNewButtons(bGroup, this.tableViewer, new INewElement(){

            public Object newElement(List<?> input, int pos) {
                SeriesColorDTO jrm = new SeriesColorDTO(new Color((int)(Math.random() * 255.0), (int)(Math.random() * 255.0), (int)(Math.random() * 255.0)));
                return jrm;
            }
        });
        new DeleteButton().createDeleteButton(bGroup, this.tableViewer);
        new ListOrderButtons().createOrderButtons(bGroup, this.tableViewer);
        this.fillTable(this.table);
    }

    private void buildTable(Composite composite) {
        this.table = new Table(composite, 67588);
        GridData gd = new GridData(1808);
        gd.heightHint = 200;
        gd.widthHint = 580;
        this.table.setLayoutData((Object)gd);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.tableViewer = new TableViewer(this.table);
        this.attachContentProvider(this.tableViewer);
        this.attachLabelProvider(this.tableViewer);
        this.attachCellEditors(this.tableViewer, (Composite)this.table);
        TableLayout tlayout = new TableLayout();
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        this.table.setLayout((Layout)tlayout);
        TableColumn[] column = new TableColumn[]{new TableColumn(this.table, 0)};
        column[0].setText("Color");
        int i = 0;
        int n = column.length;
        while (i < n) {
            column[i].pack();
            ++i;
        }
    }

    private void attachLabelProvider(TableViewer viewer) {
        viewer.setLabelProvider((IBaseLabelProvider)new TLabelProvider());
    }

    private void attachContentProvider(TableViewer viewer) {
        viewer.setContentProvider((IContentProvider)new ListContentProvider());
    }

    private void attachCellEditors(TableViewer viewer, Composite parent) {
        viewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return property.equals("COLOR");
            }

            public Object getValue(Object element, String property) {
                SeriesColorDTO mi = (SeriesColorDTO)element;
                if (property.equals("COLOR")) {
                    return Colors.getSWTRGB4AWTGBColor((Color)mi.getValue());
                }
                return null;
            }

            public void modify(Object element, String property, Object value) {
                TableItem ti = (TableItem)element;
                SeriesColorDTO mi = (SeriesColorDTO)ti.getData();
                if (property.equals("COLOR")) {
                    mi.setValue(Colors.getAWT4SWTRGBColor((AlfaRGB)((AlfaRGB)value)));
                }
                SeriesColorPage.this.tableViewer.update(element, new String[]{property});
                SeriesColorPage.this.tableViewer.refresh();
            }
        });
        viewer.setCellEditors(new CellEditor[]{new ColorCellEditor(parent)});
        viewer.setColumnProperties(new String[]{"COLOR"});
    }

    private void fillTable(Table table) {
        this.tableViewer.setInput(this.value);
        if (!this.value.isEmpty()) {
            table.select(0);
        }
    }

    private final class TLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ColorLabelProvider clb = new ColorLabelProvider(NullEnum.NOTNULL);

        private TLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            SeriesColorDTO dto = (SeriesColorDTO)element;
            switch (columnIndex) {
                case 0: {
                    return this.clb.getImage((Object)Colors.getSWTRGB4AWTGBColor((Color)dto.getValue()));
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            SeriesColorDTO dto = (SeriesColorDTO)element;
            switch (columnIndex) {
                case 0: {
                    return this.clb.getText((Object)Colors.getSWTRGB4AWTGBColor((Color)dto.getValue()));
                }
            }
            return "";
        }
    }
}

