/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.chart.property.widget;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.components.Activator;
import com.jaspersoft.studio.components.chart.property.descriptor.ChartCustomizerDefinition;
import com.jaspersoft.studio.components.chart.property.widget.CustomizerWidgetsDescriptor;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.widgets.framework.manager.IWidgetsDescriptorResolver;
import com.jaspersoft.studio.widgets.framework.manager.StandardJSONWidgetsDescriptorResolver;
import com.jaspersoft.studio.widgets.framework.manager.WidgetsDefinitionManager;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class CustomizerDefinitionManager {
    private static HashMap<JasperReportsConfiguration, List<CustomizerWidgetsDescriptor>> customizers = new HashMap();

    static {
        JaspersoftStudioPlugin.getInstance().getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("com.jaspersoft.studio.components.chart.customizers")) {
                    customizers.clear();
                }
            }
        });
    }

    public static List<CustomizerWidgetsDescriptor> getCustomizerDefinitions(JasperReportsConfiguration jConfig) {
        List<CustomizerWidgetsDescriptor> definitions = customizers.get(jConfig);
        if (definitions == null) {
            int n;
            int n2;
            Object[] objectArray;
            definitions = new ArrayList<CustomizerWidgetsDescriptor>();
            StandardJSONWidgetsDescriptorResolver resolver = new StandardJSONWidgetsDescriptorResolver(CustomizerWidgetsDescriptor.class);
            String folder = "/resources/customizers";
            try {
                File resourceFolder = new File(Activator.getDefault().getFileLocation(folder));
                objectArray = resourceFolder.listFiles();
                n2 = objectArray.length;
                n = 0;
                while (n < n2) {
                    Object definition = objectArray[n];
                    CustomizerWidgetsDescriptor loadedDecriptor = (CustomizerWidgetsDescriptor)WidgetsDefinitionManager.getWidgetsDefinition((JasperReportsConfiguration)jConfig, (String)((File)definition).getAbsolutePath(), (IWidgetsDescriptorResolver)resolver);
                    if (loadedDecriptor != null) {
                        definitions.add(loadedDecriptor);
                    }
                    ++n;
                }
            }
            catch (Exception ex) {
                Activator.getDefault().logError(ex);
            }
            String cList = jConfig.getProperty("com.jaspersoft.studio.components.chart.customizers");
            if (cList != null) {
                objectArray = cList.split("\n");
                n2 = objectArray.length;
                n = 0;
                while (n < n2) {
                    Object line = objectArray[n];
                    if (!((String)line).isEmpty()) {
                        try {
                            String customizerPath = new String(Base64.decodeBase64((String)line));
                            CustomizerWidgetsDescriptor loadedDecriptor = (CustomizerWidgetsDescriptor)WidgetsDefinitionManager.getWidgetsDefinition((JasperReportsConfiguration)jConfig, (String)customizerPath, (IWidgetsDescriptorResolver)resolver);
                            if (loadedDecriptor != null) {
                                definitions.add(loadedDecriptor);
                            }
                        }
                        catch (Exception e) {
                            JaspersoftStudioPlugin.getInstance().logError((Throwable)e);
                        }
                    }
                    ++n;
                }
            }
            customizers.put(jConfig, definitions);
        }
        return definitions;
    }

    public static ChartCustomizerDefinition getCustomizerDefinition(String className, String key, JasperReportsConfiguration jConfig) {
        List<CustomizerWidgetsDescriptor> definitions = CustomizerDefinitionManager.getCustomizerDefinitions(jConfig);
        for (CustomizerWidgetsDescriptor descriptor : definitions) {
            if (!descriptor.getCustomizerClass().equals(className)) continue;
            return new ChartCustomizerDefinition(descriptor, key);
        }
        return new ChartCustomizerDefinition(className, key, true);
    }
}

