/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.chart.wizard;

import com.jaspersoft.studio.components.chart.messages.Messages;
import com.jaspersoft.studio.components.chart.wizard.fragments.data.widget.DatasetSeriesWidget;
import com.jaspersoft.studio.components.chart.wizard.fragments.data.widget.ElementDatasetWidget;
import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.editor.expression.IExpressionContextSetter;
import com.jaspersoft.studio.property.dataset.DatasetRunSelectionListener;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.wizards.ContextHelpIDs;
import com.jaspersoft.studio.wizards.JSSWizardPage;
import net.sf.jasperreports.components.spiderchart.SpiderChartComponent;
import net.sf.jasperreports.components.spiderchart.StandardSpiderDataset;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.component.Component;
import net.sf.jasperreports.engine.design.JRDesignChart;
import net.sf.jasperreports.engine.design.JRDesignComponentElement;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignElementDataset;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ChartDataPage
extends JSSWizardPage
implements IExpressionContextSetter {
    private JRDesignElement jrChart;
    private ElementDatasetWidget ewDataset;
    private JRDesignElementDataset edataset;
    private DatasetSeriesWidget eDatasetSeries;
    private JasperReportsConfiguration jrContext;
    private ExpressionContext expContext;
    private Composite composite;

    protected ChartDataPage(JRDesignElement jrChart, JRDesignElementDataset edataset, JasperReportsConfiguration jrContext) {
        super("chartdataconfiguration");
        this.setTitle(Messages.ChartDataPage_title);
        this.setDescription(Messages.ChartDataPage_description);
        this.jrChart = jrChart;
        this.edataset = edataset;
        this.jrContext = jrContext;
    }

    protected String getContextName() {
        return ContextHelpIDs.WIZARD_CHART_DATA;
    }

    public void createControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)new GridLayout());
        this.setControl((Control)this.composite);
        this.eDatasetSeries = new DatasetSeriesWidget(this.composite, this.jrContext);
        this.eDatasetSeries.setExpressionContext(this.getExpressionContextFromDSRun());
        this.ewDataset = new ElementDatasetWidget(this.composite);
        this.ewDataset.setExpressionContext(this.expContext);
        this.ewDataset.addDatasetRunSelectionListener(new DatasetRunSelectionListener(){

            public void selectionChanged() {
                ChartDataPage.this.eDatasetSeries.setExpressionContext(ChartDataPage.this.getExpressionContextFromDSRun());
            }
        });
        this.composite.layout();
    }

    public void updateData() {
        this.eDatasetSeries.setDataset(this.jrContext.getJasperDesign(), this.jrChart, this.edataset);
        this.ewDataset.setDataset(this.edataset, this.jrContext.getJasperDesign());
        this.composite.layout(true, true);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            Component component;
            if (this.jrChart instanceof JRDesignChart) {
                this.edataset = (JRDesignElementDataset)((JRDesignChart)this.jrChart).getDataset();
                this.updateData();
            } else if (this.jrChart instanceof JRDesignComponentElement && (component = ((JRDesignComponentElement)this.jrChart).getComponent()) instanceof SpiderChartComponent) {
                this.edataset = (StandardSpiderDataset)((SpiderChartComponent)component).getDataset();
                this.updateData();
            }
        }
        super.setVisible(visible);
    }

    public void setExpressionContext(ExpressionContext expContext) {
        this.expContext = expContext;
        if (this.ewDataset != null) {
            this.ewDataset.setExpressionContext(expContext);
        }
    }

    private ExpressionContext getExpressionContextFromDSRun() {
        JRDesignDataset designDs = this.jrContext.getJasperDesign().getMainDesignDataset();
        if (this.edataset.getDatasetRun() != null) {
            designDs = ModelUtils.getDesignDatasetByName((JasperDesign)this.jrContext.getJasperDesign(), (String)Misc.nvl((String)this.edataset.getDatasetRun().getDatasetName()));
        }
        return new ExpressionContext(designDs, this.jrContext);
    }
}

