/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.chart.wizard;

import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.help.HelpSystem;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.image.MImage;
import com.jaspersoft.studio.model.text.MTextField;
import com.jaspersoft.studio.swt.widgets.WTParametersText;
import com.jaspersoft.studio.swt.widgets.WTextExpression;
import com.jaspersoft.studio.utils.ModelUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.type.HyperlinkTargetEnum;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class HyperLinkPanel {
    private ElementHider anchor;
    private ElementHider page;
    private ElementHider reference;
    private ElementHider tooltip;
    private ElementHider parameters;
    private WTextExpression anchorWidget;
    private WTextExpression referenceWidget;
    private WTParametersText parametersWidget;
    private WTextExpression whenWidget;
    private WTextExpression tooltipWidget;
    private WTextExpression pageWidget;
    private Combo targetCombo;
    private Combo typeCombo;
    private Composite mainComposite;
    private APropertyNode hyperlinkNode;
    private HashMap<String, ElementHider[]> hideList = null;
    private static String[] linkTargetItems = new String[]{HyperlinkTargetEnum.SELF.getName(), HyperlinkTargetEnum.BLANK.getName(), HyperlinkTargetEnum.TOP.getName(), HyperlinkTargetEnum.PARENT.getName()};
    private static String[] linkTypeItems;

    static {
        ArrayList<HyperlinkTypeEnum> filteredTypes = new ArrayList<HyperlinkTypeEnum>(2);
        filteredTypes.add(HyperlinkTypeEnum.CUSTOM);
        filteredTypes.add(HyperlinkTypeEnum.NULL);
        List alltypes = ModelUtils.getHyperlinkTypeNames4Widget(filteredTypes);
        linkTypeItems = alltypes.toArray(new String[alltypes.size()]);
    }

    public HyperLinkPanel(APropertyNode mHyperlink) {
        this.hyperlinkNode = mHyperlink;
    }

    private GridData gridDataGenerator() {
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.grabExcessHorizontalSpace = true;
        return gd;
    }

    public APropertyNode getElement() {
        return this.hyperlinkNode;
    }

    public void refresh() {
        APropertyNode element = this.getElement();
        if (element != null) {
            String typeValue;
            this.setExpressionComponentData(this.anchorWidget, element, element.getPropertyActualValue((Object)"hyperlinkAnchorExpression"));
            this.setExpressionComponentData(this.referenceWidget, element, element.getPropertyActualValue((Object)"hyperlinkReferenceExpression"));
            this.setExpressionComponentData(this.whenWidget, element, element.getPropertyActualValue((Object)"hyperlinkWhenExpression"));
            this.setExpressionComponentData(this.pageWidget, element, element.getPropertyActualValue((Object)"hyperlinkPageExpression"));
            this.setExpressionComponentData(this.tooltipWidget, element, element.getPropertyActualValue((Object)"hyperlinkTooltipExpression"));
            this.parametersWidget.updateData();
            Object propertyValue = element.getPropertyActualValue((Object)"linkTarget");
            this.targetCombo.setText(propertyValue != null ? propertyValue.toString() : linkTargetItems[0]);
            propertyValue = element.getPropertyActualValue((Object)"hyperlinkType");
            String string = typeValue = propertyValue != null ? propertyValue.toString() : linkTypeItems[0];
            if (!typeValue.equals(this.typeCombo.getText())) {
                this.typeCombo.setText(typeValue);
            }
        }
    }

    private void createMap() {
        if (this.hideList == null) {
            this.hideList = new HashMap();
            this.hideList.put(linkTypeItems[0], new ElementHider[]{this.tooltip});
            this.hideList.put(linkTypeItems[1], new ElementHider[]{this.tooltip, this.reference});
            this.hideList.put(linkTypeItems[2], new ElementHider[]{this.tooltip, this.anchor});
            this.hideList.put(linkTypeItems[3], new ElementHider[]{this.tooltip, this.page});
            this.hideList.put(linkTypeItems[4], new ElementHider[]{this.tooltip, this.reference, this.anchor});
            this.hideList.put(linkTypeItems[5], new ElementHider[]{this.tooltip, this.reference, this.page});
            this.hideList.put(linkTypeItems[6], new ElementHider[]{this.tooltip, this.parameters});
            this.hideList.put("Custom", new ElementHider[]{this.tooltip, this.parameters, this.reference, this.anchor, this.page});
        }
    }

    private void refreshVisibleComponents() {
        ElementHider[] actualHiders;
        ElementHider[] hiders;
        ElementHider[] elementHiderArray = hiders = new ElementHider[]{this.anchor, this.page, this.reference, this.tooltip, this.parameters};
        int n = hiders.length;
        int n2 = 0;
        while (n2 < n) {
            ElementHider hider = elementHiderArray[n2];
            hider.hideAll();
            ++n2;
        }
        String selectedValue = this.typeCombo.getText();
        if (!this.hideList.containsKey(selectedValue)) {
            selectedValue = "Custom";
        }
        ElementHider[] elementHiderArray2 = actualHiders = this.hideList.get(selectedValue);
        int n3 = actualHiders.length;
        int n4 = 0;
        while (n4 < n3) {
            ElementHider hider = elementHiderArray2[n4];
            hider.showAll();
            ++n4;
        }
        this.mainComposite.layout();
    }

    private void readValueFromCombo(Combo combo, String property) {
        APropertyNode element = this.getElement();
        if (element != null) {
            element.setPropertyValue((Object)property, (Object)combo.getText());
            int stringLength = combo.getText().length();
            combo.setSelection(new Point(stringLength, stringLength));
        }
    }

    private Label createLabel(Composite parent, String toolTip, String text) {
        Label newLabel = new Label(parent, 0);
        newLabel.setText(text);
        newLabel.setBackground(parent.getBackground());
        newLabel.setToolTipText(toolTip);
        return newLabel;
    }

    private void setHelp() {
        String prefix = "net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#";
        if (this.getElement() instanceof MImage) {
            HelpSystem.setHelp((Control)this.typeCombo, (String)(String.valueOf(prefix) + "image_hyperlinkType"));
            HelpSystem.setHelp((Control)this.targetCombo, (String)(String.valueOf(prefix) + "image_hyperlinkTarget"));
        } else if (this.getElement() instanceof MTextField) {
            HelpSystem.setHelp((Control)this.typeCombo, (String)(String.valueOf(prefix) + "textField_hyperlinkType"));
            HelpSystem.setHelp((Control)this.targetCombo, (String)(String.valueOf(prefix) + "textField_hyperlinkTarget"));
        } else {
            HelpSystem.setHelp((Control)this.typeCombo, (String)(String.valueOf(prefix) + "sectionHyperlink_hyperlinkType"));
            HelpSystem.setHelp((Control)this.targetCombo, (String)(String.valueOf(prefix) + "sectionHyperlink_hyperlinkTarget"));
        }
    }

    protected WTextExpression createExpressionComponent(Composite parent) {
        WTextExpression expr = new WTextExpression(parent, 0, 1);
        expr.setBackground(parent.getBackground());
        if (parent.getLayout() instanceof GridLayout) {
            GridData gd = new GridData(768);
            gd.widthHint = 100;
            expr.setLayoutData((Object)gd);
        }
        return expr;
    }

    private void setExpressionComponentData(WTextExpression component, APropertyNode pnode, Object b) {
        Object expContextAdapter;
        component.setExpression((JRDesignExpression)b);
        JRDesignElement designEl = null;
        if (pnode.getValue() instanceof JRDesignElement) {
            designEl = (JRDesignElement)pnode.getValue();
        }
        if ((expContextAdapter = pnode.getAdapter(ExpressionContext.class)) != null) {
            component.setExpressionContext((ExpressionContext)expContextAdapter);
        } else {
            component.setExpressionContext(ModelUtils.getElementExpressionContext((JRDesignElement)designEl, (ANode)pnode));
        }
    }

    private void setExpressionProperty(Object propertyId, WTextExpression expressionWidget) {
        JRDesignExpression exp = expressionWidget.getExpression();
        this.getElement().setPropertyValue(propertyId, exp != null ? exp.clone() : null);
    }

    public void setAllExpressionValues() {
        this.setExpressionProperty("hyperlinkAnchorExpression", this.anchorWidget);
        this.setExpressionProperty("hyperlinkPageExpression", this.pageWidget);
        this.setExpressionProperty("hyperlinkReferenceExpression", this.referenceWidget);
        this.setExpressionProperty("hyperlinkWhenExpression", this.whenWidget);
        this.setExpressionProperty("hyperlinkTooltipExpression", this.tooltipWidget);
    }

    public void createControls(Composite parent) {
        this.mainComposite = new Composite(parent, 0);
        this.mainComposite.setBackground(parent.getBackground());
        GridData mainCompData = new GridData(1808);
        mainCompData.widthHint = 600;
        mainCompData.minimumHeight = 250;
        this.mainComposite.setLayoutData((Object)mainCompData);
        this.mainComposite.setLayout((Layout)new GridLayout(3, false));
        this.createLabel(this.mainComposite, Messages.MHyperLink_link_target_description, Messages.MHyperLink_link_target);
        this.targetCombo = new Combo(this.mainComposite, 0);
        this.targetCombo.setLayoutData((Object)this.gridDataGenerator());
        this.targetCombo.setItems(linkTargetItems);
        this.createLabel(this.mainComposite, Messages.MHyperLink_link_type_description, Messages.MHyperLink_link_type);
        this.typeCombo = new Combo(this.mainComposite, 0);
        this.typeCombo.setLayoutData((Object)this.gridDataGenerator());
        this.typeCombo.setItems(linkTypeItems);
        Label anchorLabel = this.createLabel(this.mainComposite, Messages.MHyperLink_hyperlink_anchor_expression_description, Messages.MHyperLink_hyperlink_anchor_expression);
        this.anchorWidget = this.createExpressionComponent(this.mainComposite);
        this.anchorWidget.setLayoutData((Object)this.gridDataGenerator());
        this.anchor = new ElementHider(new Control[]{anchorLabel, this.anchorWidget});
        Label pageLabel = this.createLabel(this.mainComposite, Messages.MHyperLink_hyperlink_page_expression_description, Messages.MHyperLink_hyperlink_page_expression);
        this.pageWidget = this.createExpressionComponent(this.mainComposite);
        this.pageWidget.setLayoutData((Object)this.gridDataGenerator());
        this.page = new ElementHider(new Control[]{pageLabel, this.pageWidget});
        Label referenceLabel = this.createLabel(this.mainComposite, Messages.MHyperLink_hyperlink_reference_expression_description, Messages.MHyperLink_hyperlink_reference_expression);
        this.referenceWidget = this.createExpressionComponent(this.mainComposite);
        this.referenceWidget.setLayoutData((Object)this.gridDataGenerator());
        this.reference = new ElementHider(new Control[]{referenceLabel, this.referenceWidget});
        this.createLabel(this.mainComposite, Messages.MHyperLink_whenexpr_desc, Messages.MHyperLink_whenexpr);
        this.whenWidget = this.createExpressionComponent(this.mainComposite);
        this.whenWidget.setLayoutData((Object)this.gridDataGenerator());
        Label tooltipLabel = this.createLabel(this.mainComposite, Messages.MHyperLink_hyperlink_tooltip_expression_description, Messages.MHyperLink_hyperlink_tooltip_expression);
        this.tooltipWidget = this.createExpressionComponent(this.mainComposite);
        this.tooltipWidget.setLayoutData((Object)this.gridDataGenerator());
        this.tooltip = new ElementHider(new Control[]{tooltipLabel, this.tooltipWidget});
        Label parametersLabel = this.createLabel(this.mainComposite, Messages.MHyperLink_parameters_description, Messages.common_parameters);
        this.parametersWidget = new WTParametersText(this.mainComposite, (Object)"hyperlinkParameters", this.getElement());
        this.parametersWidget.setBackground(this.mainComposite.getBackground());
        this.parametersWidget.setLayoutData((Object)new GridData(768));
        this.parametersWidget.setSelectionAdapter(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HyperLinkPanel.this.parametersWidget.updateData();
            }
        });
        Control button = this.parametersWidget.getButton();
        this.parameters = new ElementHider(new Control[]{parametersLabel, this.parametersWidget, button});
        this.createMap();
        this.setHelp();
        this.targetCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HyperLinkPanel.this.readValueFromCombo(HyperLinkPanel.this.targetCombo, "linkTarget");
            }
        });
        this.targetCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                HyperLinkPanel.this.readValueFromCombo(HyperLinkPanel.this.targetCombo, "linkTarget");
            }
        });
        this.typeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HyperLinkPanel.this.refreshVisibleComponents();
                HyperLinkPanel.this.readValueFromCombo(HyperLinkPanel.this.typeCombo, "hyperlinkType");
            }
        });
        this.typeCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                HyperLinkPanel.this.refreshVisibleComponents();
                HyperLinkPanel.this.readValueFromCombo(HyperLinkPanel.this.typeCombo, "hyperlinkType");
            }
        });
        this.refresh();
    }

    private class ElementHider {
        private Control[] controls;

        public ElementHider(Control[] controls) {
            this.controls = controls;
        }

        public void setVisibility(boolean visible) {
            Control[] controlArray = this.controls;
            int n = this.controls.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                if (!control.isDisposed()) {
                    if (control.getLayoutData() == null) {
                        control.setLayoutData((Object)new GridData());
                    }
                    GridData layout = (GridData)control.getLayoutData();
                    layout.exclude = !visible;
                    control.setVisible(visible);
                }
                ++n2;
            }
        }

        public void showAll() {
            this.setVisibility(true);
        }

        public void hideAll() {
            this.setVisibility(false);
        }
    }
}

