/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.chart.wizard;

import com.jaspersoft.studio.components.chart.messages.Messages;
import com.jaspersoft.studio.components.chart.wizard.HyperLinkPanel;
import com.jaspersoft.studio.model.APropertyNode;
import java.text.MessageFormat;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;

public class HyperlinkPage
extends FormDialog {
    private HyperLinkPanel controlPanel;
    private boolean hasHyperlink = true;
    private String seriesName;

    public HyperlinkPage(Shell shell, APropertyNode hyperLinkNode, String seriesName, boolean hasHyperlink) {
        super(shell);
        this.controlPanel = new HyperLinkPanel(hyperLinkNode);
        this.seriesName = seriesName;
        this.hasHyperlink = hasHyperlink;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        if (this.hasHyperlink) {
            Button deleteButton = this.createButton(parent, 7, Messages.HyperlinkDialog_deleteHyperlinkAction, false);
            deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (UIUtils.showConfirmation((String)Messages.HyperlinkPage_deleteTitle, (String)HyperlinkPage.this.getDeleteMessage())) {
                        HyperlinkPage.this.setReturnCode(7);
                        HyperlinkPage.this.close();
                    }
                }
            });
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.HyperlinkDialog_hyperlinkDialogName);
    }

    protected void createFormContent(IManagedForm mform) {
        super.createFormContent(mform);
        mform.getForm().setText(this.getDialogTitle());
        mform.getForm().getBody().setLayout((Layout)new GridLayout(1, false));
        this.controlPanel.createControls(mform.getForm().getBody());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)mform.getForm().getBody(), "com.jaspersoft.studio.doc.createHyperlinkSection");
    }

    protected void okPressed() {
        this.controlPanel.setAllExpressionValues();
        super.okPressed();
    }

    public APropertyNode getElement() {
        return this.controlPanel.getElement();
    }

    protected String getDeleteMessage() {
        return MessageFormat.format(Messages.HyperlinkPage_deleteDescription, this.seriesName);
    }

    protected String getDialogTitle() {
        return MessageFormat.format(Messages.HyperlinkDialog_hyperlinkDialogTitle, this.seriesName);
    }
}

