/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.chart.wizard.fragments.data;

import com.jaspersoft.studio.components.chart.messages.Messages;
import com.jaspersoft.studio.components.chart.wizard.HyperlinkPage;
import com.jaspersoft.studio.components.chart.wizard.fragments.data.ADSComponent;
import com.jaspersoft.studio.components.chart.wizard.fragments.data.widget.DatasetSeriesWidget;
import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.jasper.JSSDrawVisitor;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.MHyperLink;
import com.jaspersoft.studio.property.dataset.ExpressionWidget;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import net.sf.jasperreports.charts.design.JRDesignHighLowDataset;
import net.sf.jasperreports.engine.JRHyperlink;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignElementDataset;
import net.sf.jasperreports.engine.design.JRDesignHyperlink;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class DSHighLow
extends ADSComponent {
    private JRDesignHighLowDataset dataset;
    private ExpressionWidget series;
    private ExpressionWidget volume;
    private ExpressionWidget date;
    private ExpressionWidget close;
    private ExpressionWidget open;
    private ExpressionWidget high;
    private ExpressionWidget low;
    private Button hyperlinkBtn;

    public DSHighLow(Composite composite, DatasetSeriesWidget dsWidget) {
        super(composite, dsWidget);
    }

    @Override
    public String getName() {
        return "High Low Dataset";
    }

    @Override
    public void setData(JSSDrawVisitor drawVisitor, JRDesignElement jrChart, JRDesignElementDataset eDataset, JasperReportsConfiguration jrContext) {
        Assert.isTrue((boolean)(eDataset instanceof JRDesignHighLowDataset));
        super.setData(drawVisitor, jrChart, eDataset, jrContext);
        this.dataset = (JRDesignHighLowDataset)eDataset;
        this.series.bindObject((Object)this.dataset, "SeriesExpression");
        this.volume.bindObject((Object)this.dataset, "VolumeExpression");
        this.date.bindObject((Object)this.dataset, "DateExpression");
        this.close.bindObject((Object)this.dataset, "CloseExpression");
        this.open.bindObject((Object)this.dataset, "OpenExpression");
        this.high.bindObject((Object)this.dataset, "HighExpression");
        this.low.bindObject((Object)this.dataset, "LowExpression");
    }

    @Override
    protected Control createChartTop(Composite composite) {
        Composite yCompo = new Composite(composite, 0);
        yCompo.setLayoutData((Object)new GridData(64));
        yCompo.setLayout((Layout)new GridLayout(10, false));
        return yCompo;
    }

    @Override
    protected Control createChartLeft(Composite parent) {
        Composite xCompo = new Composite(parent, 0);
        xCompo.setLayout((Layout)new GridLayout(3, false));
        xCompo.setLayoutData((Object)new GridData(64));
        this.high = new ExpressionWidget(xCompo, Messages.DSHighLow_highExpression);
        this.close = new ExpressionWidget(xCompo, Messages.DSHighLow_closeExpression);
        this.open = new ExpressionWidget(xCompo, Messages.DSHighLow_openExpression);
        this.low = new ExpressionWidget(xCompo, Messages.DSHighLow_lowExpression);
        return xCompo;
    }

    @Override
    protected Control createChartBottom(Composite parent) {
        Composite xCompo = new Composite(parent, 0);
        xCompo.setLayout((Layout)new GridLayout(3, false));
        xCompo.setLayoutData((Object)new GridData(64));
        this.series = new ExpressionWidget(xCompo, Messages.DSHighLow_seriesExpression);
        return xCompo;
    }

    @Override
    protected Control createChartRight(Composite parent) {
        Composite xCompo = new Composite(parent, 0);
        xCompo.setLayout((Layout)new GridLayout(3, false));
        xCompo.setLayoutData((Object)new GridData(64));
        this.volume = new ExpressionWidget(xCompo, Messages.DSHighLow_volumeExpression);
        this.date = new ExpressionWidget(xCompo, Messages.DSHighLow_dateExpression);
        this.hyperlinkBtn = new Button(xCompo, 0x800008);
        this.hyperlinkBtn.setLayoutData((Object)new GridData(4, 128, true, false, 3, 1));
        this.hyperlinkBtn.setText(Messages.DSHighLow_hypertextButton);
        this.hyperlinkBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MHyperLink hyperLinkElement = null;
                JRHyperlink hyperlink = DSHighLow.this.dataset.getItemHyperlink();
                hyperLinkElement = hyperlink != null ? DSHighLow.this.createHyperlinkModel((JRHyperlink)hyperlink.clone()) : DSHighLow.this.createHyperlinkModel((JRHyperlink)new JRDesignHyperlink());
                HyperlinkPage dlg = new HyperlinkPage(DSHighLow.this.hyperlinkBtn.getShell(), (APropertyNode)hyperLinkElement, null, DSHighLow.this.dataset.getItemHyperlink() != null){

                    @Override
                    protected String getDialogTitle() {
                        return Messages.DSHighLow_hypertextDialogTitle;
                    }

                    @Override
                    protected String getDeleteMessage() {
                        return Messages.DSHighLow_deleteHyperlinkConfirmation;
                    }
                };
                int operationResult = dlg.open();
                if (operationResult == 0) {
                    DSHighLow.this.dataset.setItemHyperlink((JRHyperlink)dlg.getElement().getValue());
                } else if (operationResult == 7) {
                    DSHighLow.this.dataset.setItemHyperlink(null);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        return xCompo;
    }

    @Override
    public void setExpressionContext(ExpressionContext expContext) {
        super.setExpressionContext(expContext);
        this.date.setExpressionContext(expContext);
        this.high.setExpressionContext(expContext);
        this.low.setExpressionContext(expContext);
        this.open.setExpressionContext(expContext);
        this.series.setExpressionContext(expContext);
        this.volume.setExpressionContext(expContext);
    }
}

