/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.chart.wizard.fragments.data;

import com.jaspersoft.studio.components.chart.messages.Messages;
import com.jaspersoft.studio.components.chart.wizard.HyperlinkPage;
import com.jaspersoft.studio.components.chart.wizard.OtherSectionPage;
import com.jaspersoft.studio.components.chart.wizard.fragments.data.ADSComponent;
import com.jaspersoft.studio.components.chart.wizard.fragments.data.dialog.SeriesDialog;
import com.jaspersoft.studio.components.chart.wizard.fragments.data.series.PieSerie;
import com.jaspersoft.studio.components.chart.wizard.fragments.data.widget.DatasetSeriesWidget;
import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.jasper.JSSDrawVisitor;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.MHyperLink;
import com.jaspersoft.studio.property.dataset.ExpressionWidget;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.List;
import net.sf.jasperreports.charts.JRPieSeries;
import net.sf.jasperreports.charts.design.JRDesignPieDataset;
import net.sf.jasperreports.charts.design.JRDesignPieSeries;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRHyperlink;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignElementDataset;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignHyperlink;
import org.apache.commons.validator.routines.FloatValidator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class DSPie
extends ADSComponent {
    private JRDesignPieDataset dataset;
    private ExpressionWidget valueWidget;
    private ExpressionWidget labelWidget;
    private ExpressionWidget key;
    private Combo seriesCombo;
    private Text minSlice;
    private Spinner maxSlice;
    private Button obtn;
    private Button hyperlinkBtn;

    public DSPie(Composite composite, DatasetSeriesWidget dsWidget) {
        super(composite, dsWidget);
    }

    @Override
    public String getName() {
        return "Pie Dataset";
    }

    @Override
    public void setData(JSSDrawVisitor drawVisitor, JRDesignElement jrChart, JRDesignElementDataset eDataset, JasperReportsConfiguration jrContext) {
        Assert.isTrue((boolean)(eDataset instanceof JRDesignPieDataset));
        super.setData(drawVisitor, jrChart, eDataset, jrContext);
        this.dataset = (JRDesignPieDataset)eDataset;
        this.setSeries(0);
        if (this.dataset.getMinPercentage() != null) {
            this.minSlice.setText(NumberFormat.getInstance().format(this.dataset.getMinPercentage()));
        } else {
            this.minSlice.setText("");
        }
        this.maxSlice.setSelection(this.dataset.getMaxCount() != null ? this.dataset.getMaxCount() : 0);
    }

    private void setSeries(int selection) {
        List seriesList = this.dataset.getSeriesList();
        if (!seriesList.isEmpty()) {
            String[] srnames = new String[seriesList.size()];
            int i = 0;
            while (i < seriesList.size()) {
                srnames[i] = String.format("Pie series (%d)", i);
                ++i;
            }
            this.seriesCombo.setItems(srnames);
            this.seriesCombo.select(selection);
            this.hyperlinkBtn.setEnabled(true);
            this.handleSelectSeries(selection);
        } else {
            this.seriesCombo.setItems(new String[0]);
            this.hyperlinkBtn.setEnabled(false);
            this.hyperlinkBtn.setText(Messages.DSCategory_hyperlinkButtonDisabled);
            this.handleSelectSeries(-1);
        }
    }

    private void handleSelectSeries(int selection) {
        JRPieSeries serie = null;
        if (selection >= 0 && selection < this.dataset.getSeriesList().size()) {
            serie = (JRPieSeries)this.dataset.getSeriesList().get(selection);
        }
        this.valueWidget.bindObject(serie, "ValueExpression");
        this.key.bindObject(serie, "KeyExpression");
        this.labelWidget.bindObject((Object)serie, "LabelExpression");
        this.hyperlinkBtn.setText(MessageFormat.format(Messages.DSCategory_defineHyperlinkButtton, this.seriesCombo.getText()));
        this.valueWidget.setEnabled(serie != null);
        this.key.setEnabled(serie != null);
        this.labelWidget.setEnabled(serie != null);
        this.hyperlinkBtn.setEnabled(serie != null);
    }

    @Override
    protected Control createChartTop(Composite composite) {
        Composite yCompo = new Composite(composite, 0);
        yCompo.setLayoutData((Object)new GridData(64));
        yCompo.setLayout((Layout)new GridLayout(10, false));
        Label lbl = new Label(yCompo, 0);
        lbl.setText(Messages.DSCategory_seriesLabel);
        lbl.setToolTipText(Messages.DSPie_seriesTooltip);
        this.seriesCombo = new Combo(yCompo, 2056);
        this.seriesCombo.setToolTipText(Messages.DSPie_seriesTooltip);
        GridData gd = new GridData(768);
        gd.widthHint = 300;
        this.seriesCombo.setLayoutData((Object)gd);
        this.seriesCombo.setItems(new String[]{"series 1"});
        this.seriesCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DSPie.this.handleSelectSeries(DSPie.this.seriesCombo.getSelectionIndex());
                DSPie.this.obtn.setSelection(false);
                DSPie.this.valueWidget.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        final Button btn = new Button(yCompo, 0x800008);
        btn.setText("...");
        btn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PieSerie serie = new PieSerie();
                SeriesDialog<JRPieSeries> dlg = new SeriesDialog<JRPieSeries>(btn.getShell(), serie);
                dlg.setExpressionContext(DSPie.this.expContext);
                List oldList = DSPie.this.dataset.getSeriesList();
                int oldsel = DSPie.this.seriesCombo.getSelectionIndex();
                JRPieSeries selected = null;
                if (oldsel >= 0) {
                    selected = (JRPieSeries)oldList.get(oldsel);
                }
                serie.setList(oldList);
                if (dlg.open() == 0) {
                    List<JRPieSeries> newlist = serie.getList();
                    JRPieSeries[] jRPieSeriesArray = DSPie.this.dataset.getSeries();
                    int n = jRPieSeriesArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        JRPieSeries item = jRPieSeriesArray[n2];
                        DSPie.this.dataset.removePieSeries(item);
                        ++n2;
                    }
                    for (JRPieSeries item : serie.getList()) {
                        DSPie.this.dataset.addPieSeries(item);
                    }
                    int sel = selected != null && newlist.indexOf(selected) >= 0 ? newlist.indexOf(selected) : 0;
                    DSPie.this.setSeries(sel);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.hyperlinkBtn = new Button(yCompo, 0x800008);
        this.hyperlinkBtn.setSelection(false);
        this.hyperlinkBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int selection = DSPie.this.seriesCombo.getSelectionIndex();
                JRDesignPieSeries serie = null;
                if (selection >= 0 && selection < DSPie.this.dataset.getSeriesList().size()) {
                    serie = (JRDesignPieSeries)DSPie.this.dataset.getSeriesList().get(selection);
                }
                if (serie != null) {
                    MHyperLink hyperLinkElement = null;
                    JRHyperlink hyperlink = serie.getSectionHyperlink();
                    hyperLinkElement = hyperlink != null ? DSPie.this.createHyperlinkModel((JRHyperlink)hyperlink.clone()) : DSPie.this.createHyperlinkModel((JRHyperlink)new JRDesignHyperlink());
                    HyperlinkPage dlg = new HyperlinkPage(DSPie.this.hyperlinkBtn.getShell(), (APropertyNode)hyperLinkElement, DSPie.this.seriesCombo.getText(), serie.getSectionHyperlink() != null);
                    int operationResult = dlg.open();
                    if (operationResult == 0) {
                        serie.setSectionHyperlink((JRHyperlink)dlg.getElement().getValue());
                    } else if (operationResult == 7) {
                        serie.setSectionHyperlink(null);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        return yCompo;
    }

    @Override
    protected Control createChartLeft(Composite parent) {
        Composite yCompo = new Composite(parent, 0);
        yCompo.setLayoutData((Object)new GridData(768));
        yCompo.setLayout((Layout)new GridLayout(3, false));
        this.valueWidget = new ExpressionWidget(yCompo, Messages.DSCategory_valueLabel);
        this.valueWidget.setToolTipText(Messages.DSPie_valueTooltip);
        this.labelWidget = new ExpressionWidget(yCompo, Messages.DSCategory_labelLabel);
        this.labelWidget.setToolTipText(Messages.DSPie_labelTooltip);
        return yCompo;
    }

    @Override
    protected Control createChartBottom(Composite parent) {
        Composite yCompo = new Composite(parent, 0);
        yCompo.setLayoutData((Object)new GridData(64));
        yCompo.setLayout((Layout)new GridLayout(10, false));
        this.key = new ExpressionWidget(yCompo, "Key");
        this.key.setToolTipText(Messages.DSPie_keyTooltip);
        return yCompo;
    }

    @Override
    protected Control createChartRight(Composite parent) {
        Composite yCompo = new Composite(parent, 0);
        yCompo.setLayoutData((Object)new GridData(768));
        yCompo.setLayout((Layout)new GridLayout(2, false));
        new Label(yCompo, 0).setText(Messages.DSPie_minSlicePercentage);
        this.minSlice = new Text(yCompo, 2048);
        this.minSlice.addListener(25, new Listener(){

            public void handleEvent(Event e) {
                try {
                    String number = e.text;
                    String oldText = ((Text)e.widget).getText();
                    number = e.start == 0 ? String.valueOf(e.text) + oldText : String.valueOf(oldText.substring(0, e.start)) + e.text;
                    if (oldText.length() - 1 > e.start + 1) {
                        number = String.valueOf(number) + oldText.substring(e.start + 1);
                    }
                    if (number.equals("-")) {
                        number = "-0";
                    }
                    if (number.equals(".")) {
                        number = "0.";
                    }
                    e.doit = FloatValidator.getInstance().isValid(number);
                }
                catch (NumberFormatException numberFormatException) {
                    e.doit = false;
                }
            }
        });
        this.minSlice.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    DSPie.this.dataset.setMinPercentage(new Float(DSPie.this.minSlice.getText()));
                }
                catch (NumberFormatException numberFormatException) {}
            }
        });
        new Label(yCompo, 0).setText(Messages.DSPie_maxSlices);
        this.maxSlice = new Spinner(yCompo, 2048);
        this.maxSlice.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Integer intValue = DSPie.this.maxSlice.getSelection();
                if (intValue == 0) {
                    intValue = null;
                }
                DSPie.this.dataset.setMaxCount(intValue);
            }
        });
        this.obtn = new Button(yCompo, 8);
        this.obtn.setText(Messages.DSPie_otherSectionButton);
        this.obtn.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        this.obtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MHyperLink hyperLinkElement = null;
                JRHyperlink hyperlink = DSPie.this.dataset.getOtherSectionHyperlink();
                hyperLinkElement = hyperlink != null ? new MHyperLink((JRHyperlink)hyperlink.clone()) : new MHyperLink(null);
                JRDesignExpression otherKeyExp = DSPie.this.getCopyExpression(DSPie.this.dataset.getOtherKeyExpression());
                JRDesignExpression otherLabelExp = DSPie.this.getCopyExpression(DSPie.this.dataset.getOtherLabelExpression());
                OtherSectionPage dlg = new OtherSectionPage(DSPie.this.hyperlinkBtn.getShell(), (APropertyNode)hyperLinkElement, otherKeyExp, otherLabelExp);
                int operationResult = dlg.open();
                if (operationResult == 0) {
                    DSPie.this.dataset.setOtherSectionHyperlink(dlg.getHyperlink());
                    DSPie.this.dataset.setOtherKeyExpression(dlg.getKeyExpression());
                    DSPie.this.dataset.setOtherLabelExpression(dlg.getLabelExpression());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        return yCompo;
    }

    private JRDesignExpression getCopyExpression(JRExpression baseExp) {
        if (baseExp == null || !(baseExp instanceof JRDesignExpression)) {
            return new JRDesignExpression();
        }
        return (JRDesignExpression)baseExp.clone();
    }

    @Override
    public void setExpressionContext(ExpressionContext expContext) {
        super.setExpressionContext(expContext);
        this.key.setExpressionContext(expContext);
        this.labelWidget.setExpressionContext(expContext);
        this.valueWidget.setExpressionContext(expContext);
    }
}

