/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.chart.wizard.fragments.data.dialog;

import com.jaspersoft.studio.components.chart.ContextHelpIDs;
import com.jaspersoft.studio.components.chart.messages.Messages;
import com.jaspersoft.studio.components.chart.property.descriptor.CustomizerPropertyExpressionsDTO;
import com.jaspersoft.studio.property.descriptor.classname.ClassTypeCellEditor;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.wizards.JSSHelpWizardPage;
import java.util.ArrayList;
import net.sf.jasperreports.engine.JRChartCustomizer;
import net.sf.jasperreports.engine.util.JRClassLoader;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EditClassPage
extends JSSHelpWizardPage {
    private ModifyListener textModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            String text;
            EditClassPage.this.advancedClass = text = ((Text)e.widget).getText();
            EditClassPage.this.getContainer().updateButtons();
        }
    };
    private String advancedClass = "";
    private int currentChartCustmizers = 0;
    private Text textArea;
    private JasperReportsConfiguration jConfig;

    public EditClassPage(CustomizerPropertyExpressionsDTO dto, JasperReportsConfiguration jConfig) {
        super("editClassPage");
        this.currentChartCustmizers = dto.getCustomizersNumber();
        this.jConfig = jConfig;
        this.setMessage(Messages.EditCustomizerPage_pageMessage);
    }

    public void createControl(Composite parent) {
        Composite mainParent = new Composite(parent, 0);
        mainParent.setLayout((Layout)new GridLayout(3, false));
        this.setTitle(Messages.EditCustomizerPage_pageTitle);
        new Label(mainParent, 0).setText(Messages.EditCustomizerPage_customizerClassLabel);
        this.textArea = new Text(mainParent, 2048);
        this.textArea.addModifyListener(this.textModifyListener);
        this.textArea.setLayoutData((Object)new GridData(768));
        this.textArea.setText(this.advancedClass);
        Button browseButton = new Button(mainParent, 8);
        browseButton.setText("...");
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArrayList<Class<JRChartCustomizer>> acceptedClasses = new ArrayList<Class<JRChartCustomizer>>();
                acceptedClasses.add(JRChartCustomizer.class);
                String classname = ClassTypeCellEditor.getJavaClassDialog((Shell)EditClassPage.this.getShell(), acceptedClasses);
                if (classname != null) {
                    EditClassPage.this.textArea.setText(classname);
                }
            }
        });
        this.setControl((Control)mainParent);
    }

    public String getRawClass() {
        return this.advancedClass;
    }

    public void setRawClass(String advancedClass) {
        this.advancedClass = advancedClass;
    }

    protected boolean validate() {
        String text = this.textArea.getText();
        if (text.trim().isEmpty()) {
            this.setErrorMessage(Messages.EditCustomizerPage_errorClassEmpty);
            return false;
        }
        try {
            if (this.jConfig != null) {
                this.jConfig.getClassLoader().loadClass(text);
            } else {
                JRClassLoader.loadClassForName((String)text);
            }
            if (this.currentChartCustmizers > 0) {
                this.setMessage(Messages.EditClassPage_dialogMessageServer);
            } else {
                this.setMessage(Messages.EditClassPage_dialogMessage);
            }
        }
        catch (Exception exception) {
            this.setMessage(Messages.EditCustomizerPage_warningClassNotFound, 2);
        }
        this.setErrorMessage(null);
        return true;
    }

    public boolean isPageComplete() {
        return this.validate();
    }

    protected String getContextName() {
        return ContextHelpIDs.WIZARD_SET_CUSTOMIZER_CLASS;
    }
}

