/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.chartspider.model.command;

import com.jaspersoft.studio.components.chart.wizard.ChartWizard;
import com.jaspersoft.studio.components.chartspider.model.MSpiderChart;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.IGroupElement;
import com.jaspersoft.studio.model.MElementGroup;
import com.jaspersoft.studio.model.band.MBand;
import com.jaspersoft.studio.model.frame.MFrame;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import net.sf.jasperreports.components.spiderchart.SpiderChartComponent;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.design.JRDesignComponentElement;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignElementDataset;
import net.sf.jasperreports.engine.design.JRDesignElementGroup;
import net.sf.jasperreports.engine.design.JRDesignFrame;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;

public class EditSpiderChartCommand
extends Command {
    private JRElementGroup jrGroup;
    private JRDesignComponentElement oldChart;
    private JRDesignComponentElement newChart;
    protected JasperReportsConfiguration jConfig;
    private MSpiderChart originalNode;

    public EditSpiderChartCommand(MFrame parent, MSpiderChart mchart) {
        this((ANode)parent, mchart, -1);
    }

    public EditSpiderChartCommand(MBand parent, MSpiderChart mchart) {
        this((ANode)parent, mchart, -1);
    }

    public EditSpiderChartCommand(MElementGroup parent, MSpiderChart mchart) {
        this((ANode)parent, mchart, -1);
    }

    private EditSpiderChartCommand(ANode parent, MSpiderChart mchart, int index) {
        this.originalNode = mchart;
        this.jConfig = parent.getJasperConfiguration();
        this.oldChart = (JRDesignComponentElement)mchart.getValue();
        this.jrGroup = parent instanceof IGroupElement ? ((IGroupElement)parent).getJRElementGroup() : (JRElementGroup)parent.getValue();
    }

    public void execute() {
        if (this.newChart == null) {
            JRDesignComponentElement clone = (JRDesignComponentElement)this.oldChart.clone();
            SpiderChartComponent scc = (SpiderChartComponent)clone.getComponent();
            ChartWizard wizard = new ChartWizard(new MSpiderChart(null, clone, -1), (JRDesignElementDataset)scc.getDataset());
            wizard.setConfig(this.jConfig, false);
            wizard.setExpressionContext(ModelUtils.getElementExpressionContext((JRDesignElement)this.oldChart, (ANode)this.originalNode));
            WizardDialog dialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
            dialog.create();
            if (dialog.open() == 0) {
                this.newChart = (JRDesignComponentElement)wizard.getChart().getValue();
            } else {
                return;
            }
        }
        this.switchCharts(this.oldChart, this.newChart);
    }

    public void undo() {
        if (this.newChart != null) {
            this.switchCharts(this.newChart, this.oldChart);
        }
    }

    private void switchCharts(JRDesignComponentElement chart1, JRDesignComponentElement chart2) {
        int index = this.jrGroup.getChildren().indexOf(chart1);
        if (this.jrGroup instanceof JRDesignElementGroup) {
            ((JRDesignElementGroup)this.jrGroup).removeElement((JRDesignElement)chart1);
            ((JRDesignElementGroup)this.jrGroup).addElement(index, (JRDesignElement)chart2);
        } else if (this.jrGroup instanceof JRDesignFrame) {
            ((JRDesignFrame)this.jrGroup).removeElement((JRElement)chart1);
            ((JRDesignFrame)this.jrGroup).addElement(index, (JRElement)chart2);
        }
    }
}

