/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.crosstab.editor;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.components.crosstab.action.CrosstabCutAction;
import com.jaspersoft.studio.components.crosstab.action.CustomCrosstabDeleteAction;
import com.jaspersoft.studio.components.crosstab.action.EditCrosstabStyleAction;
import com.jaspersoft.studio.components.crosstab.action.RemoveCrosstabStylesAction;
import com.jaspersoft.studio.components.crosstab.messages.Messages;
import com.jaspersoft.studio.components.crosstab.model.MCrosstab;
import com.jaspersoft.studio.components.crosstab.model.cell.action.CreateColumnCrosstabHeaderAction;
import com.jaspersoft.studio.components.crosstab.model.columngroup.action.CreateColumnGroupAction;
import com.jaspersoft.studio.components.crosstab.model.header.action.CreateCrosstabHeaderAction;
import com.jaspersoft.studio.components.crosstab.model.measure.action.CreateMeasureAction;
import com.jaspersoft.studio.components.crosstab.model.nodata.action.CreateCrosstabWhenNoDataAction;
import com.jaspersoft.studio.components.crosstab.model.parameter.action.CreateCrosstabParameterAction;
import com.jaspersoft.studio.components.crosstab.model.rowgroup.action.CreateRowGroupAction;
import com.jaspersoft.studio.components.crosstab.model.title.action.CreateCrosstabTitleAction;
import com.jaspersoft.studio.editor.gef.parts.JSSGraphicalViewerKeyHandler;
import com.jaspersoft.studio.editor.gef.parts.JasperDesignEditPartFactory;
import com.jaspersoft.studio.editor.gef.parts.MainDesignerRootEditPart;
import com.jaspersoft.studio.editor.gef.rulers.ReportRuler;
import com.jaspersoft.studio.editor.gef.rulers.ReportRulerProvider;
import com.jaspersoft.studio.editor.java2d.ISelectionOverrider;
import com.jaspersoft.studio.editor.java2d.JSSScrollingGraphicalViewer;
import com.jaspersoft.studio.editor.name.NamedSubeditor;
import com.jaspersoft.studio.editor.report.MarqueeSelectionOverrider;
import com.jaspersoft.studio.editor.report.ParentSelectionOverrider;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.IContainer;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.util.ModelVisitor;
import com.jaspersoft.studio.property.dataset.dialog.ContextualDatasetAction;
import com.jaspersoft.studio.property.dataset.dialog.DatasetAction;
import com.jaspersoft.studio.utils.AContributorAction;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.base.JRBaseElement;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IWorkbenchPart;

public class CrosstabEditor
extends NamedSubeditor {
    public CrosstabEditor(JasperReportsConfiguration jrContext) {
        super(jrContext);
        this.setPartName(this.getDefaultEditorName());
        this.setPartImage(JaspersoftStudioPlugin.getInstance().getImage(MCrosstab.getIconDescriptor().getIcon16()));
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        this.getGraphicalViewer().getControl().setBackground(ColorConstants.button);
        GraphicalViewer graphicalViewer = this.getGraphicalViewer();
        MainDesignerRootEditPart rootEditPart = new MainDesignerRootEditPart();
        graphicalViewer.setRootEditPart((RootEditPart)rootEditPart);
        graphicalViewer.setEditPartFactory((EditPartFactory)new JasperDesignEditPartFactory());
        ReportRulerProvider provider = new ReportRulerProvider(new ReportRuler(true, 2));
        graphicalViewer.setProperty("horizontal ruler", (Object)provider);
        provider = new ReportRulerProvider(new ReportRuler(false, 2));
        graphicalViewer.setProperty("vertical ruler", (Object)provider);
        Boolean isRulerVisible = this.jrContext.getPropertyBoolean("pageRulerGrid_SHOWRULER");
        graphicalViewer.setProperty("ruler$visibility", (Object)isRulerVisible);
        this.createAdditionalActions();
        graphicalViewer.setKeyHandler((KeyHandler)new JSSGraphicalViewerKeyHandler(graphicalViewer));
        if (graphicalViewer instanceof JSSScrollingGraphicalViewer) {
            JSSScrollingGraphicalViewer jssViewer = (JSSScrollingGraphicalViewer)graphicalViewer;
            jssViewer.addSelectionOverrider((ISelectionOverrider)new ParentSelectionOverrider(IContainer.class, false));
            jssViewer.addSelectionOverrider((ISelectionOverrider)new MarqueeSelectionOverrider());
        }
    }

    protected List<String> getIgnorePalleteElements() {
        ArrayList<String> lst = new ArrayList<String>();
        lst.add(MCrosstab.class.getCanonicalName());
        lst.add("com.jaspersoft.studio.components.chart.model.MChart");
        return lst;
    }

    protected void createDeleteAction(ActionRegistry registry) {
        List selectionActions = this.getSelectionActions();
        CustomCrosstabDeleteAction deleteAction = new CustomCrosstabDeleteAction((IWorkbenchPart)this);
        registry.registerAction((IAction)deleteAction);
        selectionActions.add(deleteAction.getId());
    }

    protected void createCutAction(ActionRegistry registry) {
        List selectionActions = this.getSelectionActions();
        CrosstabCutAction action = new CrosstabCutAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        selectionActions.add(action.getId());
    }

    protected void createEditorActions(ActionRegistry registry) {
        this.createDatasetAndStyleActions(registry);
        Object action = new CreateMeasureAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        List selectionActions = this.getSelectionActions();
        selectionActions.add("create_measure");
        action = new EditCrosstabStyleAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        selectionActions.add("com.jaspersoft.studio.components.crosstab.action.EditStyle");
        action = new RemoveCrosstabStylesAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        selectionActions.add("com.jaspersoft.studio.components.table.action.RemoveCrosstabStyles");
        action = new CreateColumnGroupAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        selectionActions.add("create_crosstab_columngroup");
        action = new CreateColumnCrosstabHeaderAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        selectionActions.add("create_columncrosstabheader");
        action = new CreateRowGroupAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        selectionActions.add("create_rowgroup");
        action = new CreateCrosstabHeaderAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        selectionActions.add("create_crosstabheader");
        action = new CreateCrosstabWhenNoDataAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        selectionActions.add("create_crosstabwhennodata");
        action = new CreateCrosstabTitleAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        selectionActions.add("create_crosstab_title");
        action = new CreateCrosstabParameterAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        selectionActions.add("create_crosstabparameter");
        action = new DatasetAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        selectionActions.add(action.getId());
        action = new ContextualDatasetAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        selectionActions.add(action.getId());
    }

    public void contributeItemsToEditorTopToolbar(IToolBarManager toolbarManager) {
        ActionContributionItem item = new ActionContributionItem(this.getActionRegistry().getAction((Object)"datasetAction"));
        this.act4TextIcon.add(item);
        toolbarManager.add((IContributionItem)item);
        List contributedActions = JaspersoftStudioPlugin.getExtensionManager().getActions();
        for (AContributorAction a : contributedActions) {
            a.setJrConfig((JasperReportsConfiguration)this.getGraphicalViewer().getProperty("JRCONTEXT"));
            item = new ActionContributionItem((IAction)a);
            this.act4TextIcon.add(item);
            toolbarManager.add((IContributionItem)item);
        }
        toolbarManager.add((IContributionItem)new Separator());
        super.contributeItemsToEditorTopToolbar(toolbarManager);
    }

    public String getDefaultEditorName() {
        return Messages.CrosstabEditor_crosstab;
    }

    public ANode getEditedNode() {
        INode model = this.getModel();
        if (model != null) {
            ModelVisitor<MCrosstab> mv = new ModelVisitor<MCrosstab>(model){

                public boolean visit(INode n) {
                    if (n instanceof MCrosstab) {
                        this.setObject((Object)((MCrosstab)n));
                        this.stop();
                    }
                    return true;
                }
            };
            return (ANode)mv.getObject();
        }
        return null;
    }

    public String getEditorName() {
        ANode node = this.getEditedNode();
        if (node != null && node.getValue() instanceof JRBaseElement) {
            JRBaseElement el = (JRBaseElement)node.getValue();
            return el.getPropertiesMap().getProperty("com.jaspersoft.studio.element.name");
        }
        return null;
    }
}

