/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.crosstab.figure;

import com.jaspersoft.studio.components.crosstab.figure.CrosstrabRestrictedTransferType;
import com.jaspersoft.studio.components.crosstab.messages.Messages;
import com.jaspersoft.studio.components.crosstab.model.MCrosstab;
import com.jaspersoft.studio.components.crosstab.model.crosstab.command.UpdateCrosstabStyleCommand;
import com.jaspersoft.studio.components.crosstab.model.dialog.CrosstabStyle;
import com.jaspersoft.studio.components.crosstab.part.CrosstabEditPart;
import com.jaspersoft.studio.editor.JrxmlEditor;
import com.jaspersoft.studio.editor.style.TemplateStyle;
import com.jaspersoft.studio.utils.IOUtils;
import com.jaspersoft.studio.utils.SelectionHelper;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.dnd.AbstractTransferDropTargetListener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class CrosstabStyleTransferDropListener
extends AbstractTransferDropTargetListener {
    public CrosstabStyleTransferDropListener(EditPartViewer viewer) {
        super(viewer);
        this.setTransfer((Transfer)CrosstrabRestrictedTransferType.getInstance());
    }

    protected void updateTargetEditPart() {
        this.setTargetEditPart(this.calculateTargetEditPart());
    }

    public void dragLeave(DropTargetEvent event) {
        this.setCurrentEvent(event);
    }

    protected void handleDrop() {
        if (this.getTargetEditPart() instanceof CrosstabEditPart) {
            MCrosstab crosstabModel = (MCrosstab)((Object)this.getTargetEditPart().getModel());
            TemplateStyle style = (TemplateStyle)IOUtils.readFromByteArray((byte[])((byte[])this.getCurrentEvent().data));
            if (style != null && style instanceof CrosstabStyle) {
                Shell shell;
                MessageDialog question;
                int response;
                CrosstabStyle selectedStyle = (CrosstabStyle)style;
                if (crosstabModel != null && ((response = (question = new MessageDialog(shell = PlatformUI.getWorkbench().getDisplay().getActiveShell(), Messages.EditCrosstabStyleAction_questionTitle, null, Messages.EditCrosstabStyleAction_questionText, 3, new String[]{Messages.EditCrosstabStyleAction_questionUpdate, Messages.EditCrosstabStyleAction_questionNewStyles, Messages.EditCrosstabStyleAction_questionCancel}, 0)).open()) == 0 || response == 1)) {
                    UpdateCrosstabStyleCommand updateCommand = new UpdateCrosstabStyleCommand(crosstabModel, selectedStyle, response == 0);
                    CommandStack cs = this.getCommandStack();
                    if (cs != null) {
                        cs.execute((Command)updateCommand);
                    } else {
                        updateCommand.execute();
                    }
                }
            }
        }
    }

    protected CommandStack getCommandStack() {
        IEditorPart activeJRXMLEditor = SelectionHelper.getActiveJRXMLEditor();
        if (activeJRXMLEditor != null && activeJRXMLEditor instanceof JrxmlEditor) {
            JrxmlEditor editor = (JrxmlEditor)activeJRXMLEditor;
            return (CommandStack)editor.getAdapter(CommandStack.class);
        }
        return null;
    }

    protected EditPart calculateTargetEditPart() {
        EditPart ep = this.getViewer().findObjectAt(this.getDropLocation());
        if (ep instanceof CrosstabEditPart) {
            return ep;
        }
        return null;
    }

    protected void updateTargetRequest() {
    }
}

