/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.crosstab.model.cell.command;

import com.jaspersoft.studio.components.crosstab.model.cell.MCell;
import com.jaspersoft.studio.editor.layout.ILayout;
import com.jaspersoft.studio.editor.layout.LayoutCommand;
import com.jaspersoft.studio.editor.layout.LayoutManager;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.utils.SelectionHelper;
import net.sf.jasperreports.crosstabs.JRCrosstabCell;
import net.sf.jasperreports.crosstabs.JRCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCellContents;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.engine.JRBoxContainer;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;

public class CreateElementCommand
extends Command {
    protected MGraphicElement srcNode;
    protected JRDesignElement jrElement;
    private JasperDesign jDesign;
    private JRDesignCellContents jrCell;
    private JRDesignCrosstab crosstab;
    private MCell destNode;
    private Rectangle location;
    private int index = -1;
    private JRPropertiesHolder[] pholder;
    private LayoutCommand lCmd;
    private boolean firstTime = true;

    public CreateElementCommand(MCell destNode, MGraphicElement srcNode, Rectangle position, int index) {
        if (srcNode != null) {
            this.jrElement = srcNode.getValue();
        }
        this.jrCell = destNode.getValue();
        this.index = index;
        this.location = position;
        this.srcNode = srcNode;
        this.destNode = destNode;
        this.jDesign = destNode.getJasperDesign();
        this.pholder = destNode.getPropertyHolder();
        this.crosstab = destNode.getCrosstab().getValue();
    }

    protected void createObject() {
        if (this.jrElement == null) {
            this.jrElement = this.srcNode.createJRElement(this.srcNode.getJasperDesign());
        }
        this.setElementBounds();
    }

    protected void setElementBounds() {
        if (this.location == null) {
            this.location = new Rectangle(0, 0, this.srcNode.getDefaultWidth(), this.srcNode.getDefaultHeight());
        }
        if (this.location.width < 0) {
            this.location.width = this.srcNode.getDefaultWidth();
        }
        if (this.location.height < 0) {
            this.location.height = this.srcNode.getDefaultHeight();
        }
        this.jrElement.setX(this.location.x);
        this.jrElement.setY(this.location.y);
        this.jrElement.setWidth(this.location.width);
        this.jrElement.setHeight(this.location.height);
    }

    public void execute() {
        this.createObject();
        if (this.jrElement != null) {
            this.removeElements(this.jrElement);
            if (this.index >= 0 && this.index <= this.jrCell.getChildren().size()) {
                this.jrCell.addElement(this.index, this.jrElement);
            } else {
                this.jrCell.addElement(this.jrElement);
            }
        }
        if (this.firstTime) {
            SelectionHelper.setSelection((JRChild)this.jrElement, (boolean)false);
            this.firstTime = false;
        }
        Dimension d = new Dimension(this.jrCell.getWidth(), this.jrCell.getHeight());
        d = LayoutManager.getPaddedSize((JRBoxContainer)this.jrCell, (Dimension)d);
        if (this.lCmd == null) {
            ILayout layout = LayoutManager.getLayout((JRPropertiesHolder[])this.pholder, (JasperDesign)this.jDesign, null);
            this.lCmd = new LayoutCommand(this.jDesign, (JRElementGroup)this.jrCell, layout, d);
        }
        this.lCmd.execute();
        LayoutManager.layoutContainer((ANode)this.destNode);
    }

    public boolean canUndo() {
        return this.jrCell != null && this.jrElement != null;
    }

    public void undo() {
        this.lCmd.undo();
        this.jrCell.removeElement(this.jrElement);
        LayoutManager.layoutContainer((ANode)this.destNode);
    }

    private void removeElements(JRDesignElement element) {
        com.jaspersoft.studio.model.command.CreateElementCommand.removeElement((JasperDesign)this.jDesign, (JRDesignElement)this.jrElement);
        for (JRCrosstabCell c : this.crosstab.getCellsList()) {
            com.jaspersoft.studio.model.command.CreateElementCommand.removeElement((JRDesignElement)element, (JRElement[])c.getContents().getElements());
        }
        for (JRCrosstabRowGroup rg : this.crosstab.getRowGroupsList()) {
            com.jaspersoft.studio.model.command.CreateElementCommand.removeElement((JRDesignElement)element, (JRElement[])rg.getHeader().getElements());
            if (rg.getTotalHeader() == null) continue;
            com.jaspersoft.studio.model.command.CreateElementCommand.removeElement((JRDesignElement)element, (JRElement[])rg.getTotalHeader().getElements());
        }
        for (JRCrosstabColumnGroup rc : this.crosstab.getColumnGroupsList()) {
            com.jaspersoft.studio.model.command.CreateElementCommand.removeElement((JRDesignElement)element, (JRElement[])rc.getHeader().getElements());
            if (rc.getTotalHeader() == null) continue;
            com.jaspersoft.studio.model.command.CreateElementCommand.removeElement((JRDesignElement)element, (JRElement[])rc.getTotalHeader().getElements());
        }
    }
}

