/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.crosstab.model.columngroup;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.components.crosstab.CrosstabNodeIconDescriptor;
import com.jaspersoft.studio.components.crosstab.messages.Messages;
import com.jaspersoft.studio.components.crosstab.model.MCrosstab;
import com.jaspersoft.studio.components.crosstab.model.MCrosstabGroup;
import com.jaspersoft.studio.components.crosstab.model.cell.MGroupCell;
import com.jaspersoft.studio.components.crosstab.model.columngroup.MColumnCrosstabHeaderCell;
import com.jaspersoft.studio.components.crosstab.model.columngroup.MColumnGroups;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.ICopyable;
import com.jaspersoft.studio.model.IDragable;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.util.IIconDescriptor;
import com.jaspersoft.studio.property.descriptor.NullEnum;
import com.jaspersoft.studio.property.descriptors.NamedEnumPropertyDescriptor;
import com.jaspersoft.studio.property.descriptors.PixelPropertyDescriptor;
import com.jaspersoft.studio.utils.ModelUtils;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.crosstabs.JRCellContents;
import net.sf.jasperreports.crosstabs.JRCrosstabCell;
import net.sf.jasperreports.crosstabs.JRCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabGroup;
import net.sf.jasperreports.crosstabs.design.JRCrosstabOrigin;
import net.sf.jasperreports.crosstabs.design.JRDesignCellContents;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.type.CrosstabColumnPositionEnum;
import net.sf.jasperreports.engine.util.Pair;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class MColumnGroup
extends MCrosstabGroup
implements ICopyable,
IDragable {
    public static final long serialVersionUID = 10200L;
    private static IIconDescriptor iconDescriptor;
    private static IPropertyDescriptor[] descriptors;
    private static NamedEnumPropertyDescriptor<CrosstabColumnPositionEnum> columnPositionD;

    public static IIconDescriptor getIconDescriptor() {
        if (iconDescriptor == null) {
            iconDescriptor = new CrosstabNodeIconDescriptor("columngroup");
        }
        return iconDescriptor;
    }

    public MColumnGroup() {
    }

    public MColumnGroup(ANode parent, JRCrosstabColumnGroup jfRield, int newIndex) {
        super(parent, (JRCrosstabGroup)jfRield, newIndex);
    }

    public JRDesignCrosstabColumnGroup getValue() {
        return (JRDesignCrosstabColumnGroup)super.getValue();
    }

    public ImageDescriptor getImagePath() {
        return MColumnGroup.getIconDescriptor().getIcon16();
    }

    public String getToolTip() {
        return MColumnGroup.getIconDescriptor().getToolTip();
    }

    @Override
    public IPropertyDescriptor[] getDescriptors() {
        return descriptors;
    }

    @Override
    public void setDescriptors(IPropertyDescriptor[] descriptors1) {
        descriptors = descriptors1;
    }

    @Override
    public void createPropertyDescriptors(List<IPropertyDescriptor> desc) {
        super.createPropertyDescriptors(desc);
        columnPositionD = new NamedEnumPropertyDescriptor((Object)"position", Messages.MColumnGroup_column_position, (Enum)CrosstabColumnPositionEnum.CENTER, NullEnum.NOTNULL);
        columnPositionD.setDescription(Messages.MColumnGroup_column_position_description);
        desc.add((IPropertyDescriptor)columnPositionD);
        PixelPropertyDescriptor heightD = new PixelPropertyDescriptor((Object)"height", Messages.common_height);
        heightD.setDescription(Messages.MColumnGroup_height_description);
        desc.add((IPropertyDescriptor)heightD);
    }

    @Override
    public Object getPropertyValue(Object id) {
        JRDesignCrosstabColumnGroup jrField = this.getValue();
        if (id.equals("position")) {
            return columnPositionD.getIntValue((Enum)jrField.getPositionValue());
        }
        if (id.equals("height")) {
            return jrField.getHeight();
        }
        return super.getPropertyValue(id);
    }

    @Override
    protected void updateGroups(String oldName, String newName) {
        MCrosstab crosstab = this.getMCrosstab();
        ArrayList<Object> cellsToRefresh = new ArrayList<Object>();
        for (INode child : crosstab.getChildren()) {
            Object cell;
            String colGroup;
            if (!(child instanceof MGroupCell) || (colGroup = ((MGroupCell)((Object)(cell = (MGroupCell)child))).getCell().getColumnTotalGroup()) == null || !colGroup.equals(oldName)) continue;
            ((MGroupCell)((Object)cell)).getCell().setColumnTotalGroup(newName);
            cellsToRefresh.add(cell);
        }
        List contents = ModelUtils.getAllCells((JRDesignCrosstab)crosstab.getValue());
        for (JRDesignCellContents content : contents) {
            Object origin;
            if (content == null || !ModelUtils.safeEquals((Object)(origin = content.getOrigin()).getColumnGroupName(), (Object)oldName)) continue;
            JRCrosstabOrigin jRCrosstabOrigin = new JRCrosstabOrigin(crosstab.getValue(), origin.getType(), origin.getRowGroupName(), newName);
            content.setOrigin(jRCrosstabOrigin);
        }
        Map cellsMap = crosstab.getValue().getCellsMap();
        for (Pair key : new ArrayList(cellsMap.keySet())) {
            if (!ModelUtils.safeEquals((Object)oldName, (Object)key.second())) continue;
            JRCrosstabCell jRCrosstabCell = (JRCrosstabCell)cellsMap.remove(key);
            cellsMap.put(new Pair((Object)((String)key.first()), (Object)newName), jRCrosstabCell);
        }
        JRDesignCrosstab jrCrosstab = crosstab.getValue();
        Map groupMap = jrCrosstab.getColumnGroupIndicesMap();
        if (groupMap.containsKey(oldName)) {
            Integer n = (Integer)groupMap.remove(oldName);
            groupMap.put(newName, n);
        }
        for (MGroupCell mGroupCell : cellsToRefresh) {
            JSSCompoundCommand.forceRefreshVisuals((ANode)mGroupCell);
        }
    }

    @Override
    public void setPropertyValue(Object id, Object value) {
        JRDesignCrosstabColumnGroup jrField = this.getValue();
        if (id.equals("position")) {
            jrField.setPosition((CrosstabColumnPositionEnum)columnPositionD.getEnumValue(value));
        } else if (id.equals("height")) {
            jrField.setHeight(((Integer)value).intValue());
            MCrosstab cross = this.getMCrosstab();
            cross.getCrosstabManager().refresh();
            this.getPropertyChangeSupport().firePropertyChange(new PropertyChangeEvent((Object)this, "height", null, value));
        } else {
            super.setPropertyValue(id, value);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("totalPosition")) {
            MCrosstab crosstabModel = this.getMCrosstab();
            if (crosstabModel != null) {
                JRDesignCrosstab jrCrosstab = crosstabModel.getValue();
                jrCrosstab.getEventSupport().firePropertyChange("updateCrosstabModel", null, (Object)this.getValue());
            }
        } else if (evt.getPropertyName().equals("crosstabHeader")) {
            int i = 0;
            while (i < this.getChildren().size()) {
                INode n = (INode)this.getChildren().get(i);
                if (n instanceof MColumnCrosstabHeaderCell) {
                    this.getChildren().remove(n);
                    new MColumnCrosstabHeaderCell((ANode)this, (JRCellContents)evt.getNewValue(), i);
                    this.getMCrosstab().getCrosstabManager().refresh();
                    break;
                }
                ++i;
            }
        }
        super.propertyChange(evt);
    }

    public ICopyable.RESULT isCopyable2(Object parent) {
        if (parent instanceof MColumnGroups) {
            return ICopyable.RESULT.COPYABLE;
        }
        return ICopyable.RESULT.CHECK_PARENT;
    }

    public boolean isCuttable(ISelection currentSelection) {
        return true;
    }
}

