/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.crosstab.model.crosstab.command;

import com.jaspersoft.studio.components.crosstab.model.MCrosstab;
import com.jaspersoft.studio.components.crosstab.model.dialog.ApplyCrosstabStyleAction;
import com.jaspersoft.studio.components.crosstab.model.dialog.CrosstabStyle;
import java.util.ArrayList;
import java.util.Arrays;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.gef.commands.Command;

public class UpdateCrosstabStyleCommand
extends Command {
    private MCrosstab crosstab;
    private JRDesignStyle[] oldStyles;
    private CrosstabStyle newStyleTemplate;
    private boolean updateOldStyles;

    public UpdateCrosstabStyleCommand(MCrosstab crosstab, CrosstabStyle newStyle, boolean updateOldStyles) {
        this.crosstab = crosstab;
        this.newStyleTemplate = newStyle;
        this.oldStyles = null;
        this.updateOldStyles = updateOldStyles;
    }

    public void execute() {
        ApplyCrosstabStyleAction applyAction = new ApplyCrosstabStyleAction(this.newStyleTemplate, this.crosstab.getValue());
        JasperDesign jd = this.crosstab.getJasperDesign();
        JRDesignStyle[] tableStyles = applyAction.getStylesFromCrosstab(this.crosstab.getValue().getPropertiesMap(), jd);
        this.oldStyles = new JRDesignStyle[tableStyles.length];
        int i = 0;
        while (i < tableStyles.length) {
            JRDesignStyle currentStyle = tableStyles[i];
            if (currentStyle != null) {
                this.oldStyles[i] = (JRDesignStyle)currentStyle.clone();
            }
            ++i;
        }
        applyAction.updateStyle(jd, this.newStyleTemplate, this.updateOldStyles, false);
        this.crosstab.setChangedProperty(true);
    }

    public void undo() {
        ArrayList<JRDesignStyle> styles = new ArrayList<JRDesignStyle>(Arrays.asList(this.oldStyles));
        ApplyCrosstabStyleAction applyAction = new ApplyCrosstabStyleAction(styles, this.crosstab.getValue());
        applyAction.updateStyle(this.crosstab.getJasperDesign(), styles, this.updateOldStyles, true);
        this.oldStyles = null;
        this.crosstab.setChangedProperty(true);
    }

    public boolean canUndo() {
        return this.crosstab != null && this.oldStyles != null;
    }
}

