/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.crosstab.model.measure.action;

import com.jaspersoft.studio.components.crosstab.messages.Messages;
import com.jaspersoft.studio.components.crosstab.model.MCrosstab;
import com.jaspersoft.studio.components.crosstab.model.cell.wizard.CrosstabMeasureWizard;
import com.jaspersoft.studio.components.crosstab.model.measure.MMeasures;
import com.jaspersoft.studio.components.crosstab.model.measure.command.CreateMeasureCommand;
import com.jaspersoft.studio.editor.action.ACachedSelectionAction;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.MRoot;
import java.util.List;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabMeasure;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class CreateMeasureAction
extends ACachedSelectionAction {
    public static final String ID = "create_measure";

    public CreateMeasureAction(IWorkbenchPart part) {
        super(part);
    }

    protected void init() {
        super.init();
        this.setText(Messages.CreateMeasureAction_create_measure);
        this.setToolTipText(Messages.CreateMeasureAction_create_measure_tool_tip);
        this.setId(ID);
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_NEW_WIZARD"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_NEW_WIZARD_DISABLED"));
    }

    public boolean isEnabled() {
        List elements = this.editor.getSelectionCache().getSelectionModelForType(MCrosstab.class);
        if (elements.size() == 1) {
            return true;
        }
        elements = this.editor.getSelectionCache().getSelectionModelForType(MMeasures.class);
        return elements.size() == 1;
    }

    public MCrosstab getCrosstab(INode startNode) {
        INode node = startNode;
        while (node != null && node.getParent() != null && !(node instanceof MCrosstab) && !(node instanceof MRoot)) {
            node = node.getParent();
        }
        if (node instanceof MCrosstab) {
            return (MCrosstab)node;
        }
        return null;
    }

    public void run() {
        EditPart part;
        MCrosstab crosstab = null;
        Object selected = this.getSelectedObjects().get(0);
        if (selected instanceof EditPart && (part = (EditPart)selected).getModel() instanceof INode) {
            crosstab = this.getCrosstab((INode)part.getModel());
        }
        if (crosstab != null) {
            CrosstabMeasureWizard crosstabMeasureWizard = new CrosstabMeasureWizard(crosstab);
            WizardDialog dialog = new WizardDialog(UIUtils.getShellForWizardDialog(), (IWizard)crosstabMeasureWizard);
            if (dialog.open() == 0) {
                JRDesignCrosstabMeasure measure = CreateMeasureCommand.createMesure(crosstab.getValue(), crosstabMeasureWizard.getGroupName());
                measure.setValueClassName(crosstabMeasureWizard.getGroupValueClass());
                measure.setValueExpression((JRExpression)new JRDesignExpression(crosstabMeasureWizard.getGroupExpression()));
                measure.setCalculation(crosstabMeasureWizard.getCalculation());
                CreateMeasureCommand measureCmd = new CreateMeasureCommand(crosstab, measure, -1);
                this.execute(measureCmd);
            }
        }
    }
}

