/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.crosstab.model.rowgroup.command;

import com.jaspersoft.studio.components.crosstab.messages.Messages;
import com.jaspersoft.studio.components.crosstab.model.CrosstabUtil;
import com.jaspersoft.studio.components.crosstab.model.MCrosstab;
import com.jaspersoft.studio.components.crosstab.model.cell.MCell;
import com.jaspersoft.studio.components.crosstab.model.rowgroup.MRowGroup;
import com.jaspersoft.studio.components.crosstab.model.rowgroup.MRowGroups;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.utils.ModelUtils;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.crosstabs.JRCrosstabCell;
import net.sf.jasperreports.crosstabs.JRCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabCell;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.type.CrosstabTotalPositionEnum;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Display;

public class CreateRowCommand
extends Command {
    private JRDesignCrosstabRowGroup jrGroup;
    private JRDesignCrosstab jrCrosstab;
    private int index;
    private JasperDesign jasperDesign;

    public CreateRowCommand(MRowGroups destNode, MRowGroup srcNode, int index) {
        this((ANode)destNode, srcNode, index);
    }

    public CreateRowCommand(MCrosstab destNode, MRowGroup srcNode, int index) {
        this((ANode)destNode, srcNode, index);
    }

    public CreateRowCommand(MRowGroup destNode, MRowGroup srcNode, int index) {
        this(destNode.getMCrosstab(), srcNode, index);
    }

    public CreateRowCommand(MCell destNode, MRowGroup srcNode, int index) {
        this(destNode.getMCrosstab(), srcNode, index);
    }

    private CreateRowCommand(ANode destNode, MRowGroup srcNode, int index) {
        this.jrCrosstab = (JRDesignCrosstab)destNode.getValue();
        this.index = index;
        if (srcNode != null && srcNode.getValue() != null) {
            this.jrGroup = (JRDesignCrosstabRowGroup)srcNode.getValue();
        }
        this.jasperDesign = destNode.getJasperDesign();
    }

    public CreateRowCommand(ANode destNode, JRDesignCrosstabRowGroup jrGroup, int index) {
        this.jrCrosstab = (JRDesignCrosstab)destNode.getValue();
        this.index = index;
        this.jrGroup = jrGroup;
        this.jasperDesign = destNode.getJasperDesign();
    }

    public void execute() {
        block4: {
            if (this.jrGroup == null) {
                this.jrGroup = CrosstabUtil.createRowGroup(this.jasperDesign, this.jrCrosstab, Messages.CreateRowGroupCommand_row_group, CrosstabTotalPositionEnum.END);
            }
            if (this.jrGroup != null) {
                try {
                    CrosstabUtil.addRowGroup(this.jrCrosstab, this.jrGroup, this.index);
                }
                catch (JRException e) {
                    e.printStackTrace();
                    if (!e.getMessage().startsWith("A group or measure having the same name already exists in the crosstab.")) break block4;
                    String defaultName = ModelUtils.getDefaultName((Map)this.jrCrosstab.getRowGroupIndicesMap(), (String)"CopyOFRowGroup_");
                    InputDialog dlg = new InputDialog(Display.getDefault().getActiveShell(), Messages.CreateRowGroupCommand_row_group_name, Messages.CreateRowGroupCommand_row_group_dialog_text, defaultName, null);
                    if (dlg.open() != 0) break block4;
                    this.jrGroup.setName(dlg.getValue());
                    this.execute();
                }
            }
        }
        this.jrCrosstab.getEventSupport().firePropertyChange("updateCrosstabModel", null, (Object)this.jrGroup);
        this.jrCrosstab.getEventSupport().firePropertyChange("com.jaspersoft.studio.components.autoresize.proportional", null, (Object)this.jrGroup);
    }

    public boolean canUndo() {
        return true;
    }

    public void undo() {
        String name = this.jrGroup.getName();
        List cells = this.jrCrosstab.getCellsList();
        this.jrCrosstab.removeRowGroup((JRCrosstabRowGroup)this.jrGroup);
        int i = 0;
        while (i < cells.size()) {
            String totalGroup;
            JRDesignCrosstabCell cell = (JRDesignCrosstabCell)cells.get(i);
            if (cell != null && (totalGroup = cell.getColumnTotalGroup()) != null && totalGroup.equals(name)) {
                this.jrCrosstab.removeCell((JRCrosstabCell)cell);
                --i;
            }
            ++i;
        }
        this.jrCrosstab.getEventSupport().firePropertyChange("updateCrosstabModel", null, (Object)this.jrGroup);
        this.jrCrosstab.getEventSupport().firePropertyChange("com.jaspersoft.studio.components.autoresize.proportional", null, (Object)this.jrGroup);
    }
}

