/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.crosstab.model.rowgroup.command;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.components.crosstab.model.CrosstabUtil;
import com.jaspersoft.studio.components.crosstab.model.MCrosstab;
import com.jaspersoft.studio.components.crosstab.model.cell.command.PostSetSizeCell;
import com.jaspersoft.studio.components.crosstab.model.rowgroup.MRowGroup;
import com.jaspersoft.studio.components.crosstab.model.rowgroup.MRowGroups;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.crosstabs.JRCrosstabCell;
import net.sf.jasperreports.crosstabs.JRCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabCell;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabRowGroup;
import net.sf.jasperreports.engine.JRException;
import org.eclipse.gef.commands.Command;

public class DeleteRowGroupCommand
extends Command {
    private JRDesignCrosstab jrCrosstab;
    private JRDesignCrosstabRowGroup jrRowGroup;
    private MCrosstab crosstabNode;
    private Map<String, JRCrosstabCell> removedCells = null;
    private int elementPosition = 0;

    public DeleteRowGroupCommand(MRowGroups destNode, MRowGroup srcNode) {
        this.jrCrosstab = (JRDesignCrosstab)destNode.getValue();
        this.crosstabNode = (MCrosstab)destNode.getParent();
        this.jrRowGroup = (JRDesignCrosstabRowGroup)srcNode.getValue();
    }

    public DeleteRowGroupCommand(MCrosstab destNode, MRowGroup srcNode) {
        this.jrCrosstab = destNode.getValue();
        this.crosstabNode = destNode;
        this.jrRowGroup = (JRDesignCrosstabRowGroup)srcNode.getValue();
    }

    public DeleteRowGroupCommand(MCrosstab crosstab, JRDesignCrosstabRowGroup group) {
        this.jrCrosstab = crosstab.getValue();
        this.crosstabNode = crosstab;
        this.jrRowGroup = group;
    }

    public void execute() {
        this.elementPosition = this.jrCrosstab.getRowGroupsList().indexOf(this.jrRowGroup);
        this.removeRowGroup(this.jrCrosstab, this.jrRowGroup);
        JSSCompoundCommand c = new JSSCompoundCommand("Resize Crosstab Cell", (ANode)this.crosstabNode);
        PostSetSizeCell.createLayoutCommand((INode)this.crosstabNode, c);
        c.execute();
    }

    protected void removeRowGroup(JRDesignCrosstab jrCross, JRDesignCrosstabRowGroup jrRowGr) {
        this.removedCells = new HashMap<String, JRCrosstabCell>();
        String name = jrRowGr.getName();
        ArrayList cells = new ArrayList(jrCross.getCellsList());
        int i = 0;
        while (i < cells.size()) {
            String totalGroup;
            JRDesignCrosstabCell cell = (JRDesignCrosstabCell)cells.get(i);
            if (cell != null && (totalGroup = cell.getRowTotalGroup()) != null && totalGroup.equals(name)) {
                this.removedCells.put(cell.getColumnTotalGroup(), (JRCrosstabCell)cell);
                jrCross.removeCell((JRCrosstabCell)cell);
            }
            ++i;
        }
        jrCross.removeRowGroup((JRCrosstabRowGroup)jrRowGr);
        this.jrCrosstab.getEventSupport().firePropertyChange("updateCrosstabModel", null, (Object)this.jrRowGroup);
    }

    public boolean canUndo() {
        return this.jrCrosstab != null && this.jrRowGroup != null;
    }

    public void undo() {
        try {
            CrosstabUtil.addRowGroup(this.jrCrosstab, this.jrRowGroup, this.elementPosition, this.removedCells);
            JSSCompoundCommand c = new JSSCompoundCommand("Resize Crosstab Cell", (ANode)this.crosstabNode);
            PostSetSizeCell.createLayoutCommand((INode)this.crosstabNode, c);
            c.execute();
            this.jrCrosstab.getEventSupport().firePropertyChange("updateCrosstabModel", null, (Object)this.jrRowGroup);
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    public Map<String, JRCrosstabCell> getRemovedCells() {
        return this.removedCells;
    }
}

