/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.crosstab.part;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.callout.CalloutEditPart;
import com.jaspersoft.studio.callout.command.CalloutSetConstraintCommand;
import com.jaspersoft.studio.callout.pin.PinEditPart;
import com.jaspersoft.studio.callout.pin.command.PinSetConstraintCommand;
import com.jaspersoft.studio.components.crosstab.CrosstabComponentFactory;
import com.jaspersoft.studio.components.crosstab.figure.CellFigure;
import com.jaspersoft.studio.components.crosstab.model.MCrosstab;
import com.jaspersoft.studio.components.crosstab.model.cell.MCell;
import com.jaspersoft.studio.components.crosstab.model.cell.command.CreateElementCommand;
import com.jaspersoft.studio.components.crosstab.model.cell.command.OrphanElementCommand;
import com.jaspersoft.studio.components.crosstab.part.ACrosstabCellEditPart;
import com.jaspersoft.studio.components.crosstab.part.editpolicy.CrosstabCellResizableEditPolicy;
import com.jaspersoft.studio.editor.gef.commands.SetPageConstraintCommand;
import com.jaspersoft.studio.editor.gef.figures.ReportPageFigure;
import com.jaspersoft.studio.editor.gef.parts.FigureEditPart;
import com.jaspersoft.studio.editor.gef.parts.editPolicy.PageLayoutEditPolicy;
import com.jaspersoft.studio.editor.outline.editpolicy.CloseSubeditorDeletePolicy;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.model.MPage;
import java.util.List;
import net.sf.jasperreports.engine.design.JRDesignElement;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.handles.HandleBounds;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.jface.viewers.ISelection;

public class CrosstabCellEditPart
extends ACrosstabCellEditPart {
    public MCell getModel() {
        return (MCell)super.getModel();
    }

    public void performRequest(Request req) {
        Command c;
        if ("open".equals(req.getType()) && (c = CrosstabComponentFactory.INST().getStretchToContent((ANode)this.getModel())) != null) {
            this.getViewer().getEditDomain().getCommandStack().execute(c);
        }
        super.performRequest(req);
    }

    @Override
    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new CloseSubeditorDeletePolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new PageLayoutEditPolicy(){
            private RectangleFigure targetFeedback;

            protected void eraseLayoutTargetFeedback(Request request) {
                super.eraseLayoutTargetFeedback(request);
                if (this.targetFeedback != null) {
                    this.removeFeedback((IFigure)this.targetFeedback);
                    this.targetFeedback = null;
                }
            }

            protected IFigure getLayoutTargetFeedback(Request request) {
                if (request instanceof ChangeBoundsRequest) {
                    ChangeBoundsRequest cbr = (ChangeBoundsRequest)request;
                    List lst = cbr.getEditParts();
                    for (EditPart ep : lst) {
                        if (((ANode)ep.getModel()).getParent() == CrosstabCellEditPart.this.getModel()) {
                            return null;
                        }
                        if (!(ep instanceof CrosstabCellEditPart)) continue;
                        return null;
                    }
                } else if (request instanceof CreateRequest && !(CrosstabCellEditPart.this.getModel() instanceof MCell)) {
                    return null;
                }
                if (this.targetFeedback == null) {
                    this.targetFeedback = new RectangleFigure();
                    this.targetFeedback.setFill(false);
                    IFigure hostFigure = this.getHostFigure();
                    Rectangle bounds = hostFigure.getBounds();
                    if (hostFigure instanceof HandleBounds) {
                        bounds = ((HandleBounds)hostFigure).getHandleBounds();
                    }
                    PrecisionRectangle rect = new PrecisionRectangle(bounds);
                    this.getHostFigure().translateToAbsolute((Translatable)rect);
                    this.getFeedbackLayer().translateToRelative((Translatable)rect);
                    this.targetFeedback.setBounds(rect.shrink(2, 2));
                    this.targetFeedback.setBorder((Border)new LineBorder(ColorConstants.lightBlue, 3));
                    this.addFeedback((IFigure)this.targetFeedback);
                }
                return this.targetFeedback;
            }

            protected void showLayoutTargetFeedback(Request request) {
                super.showLayoutTargetFeedback(request);
                this.getLayoutTargetFeedback(request);
            }

            protected Command getCreateCommand(ANode parent, Object obj, Rectangle constraint, int index, Request request) {
                if (parent instanceof MPage) {
                    parent = CrosstabCellEditPart.this.getModel();
                }
                Rectangle b = CrosstabCellEditPart.this.getModel().getBounds();
                int x = constraint.x - b.x - ReportPageFigure.PAGE_BORDER.left;
                int y = constraint.y - b.y - ReportPageFigure.PAGE_BORDER.top;
                constraint = new Rectangle(x, y, constraint.width, constraint.height);
                return super.getCreateCommand(parent, obj, constraint, index, request);
            }

            protected Command getAddCommand(Request generic) {
                ChangeBoundsRequest request = (ChangeBoundsRequest)generic;
                List editParts = request.getEditParts();
                MCell mband = CrosstabCellEditPart.this.getModel();
                JSSCompoundCommand command = new JSSCompoundCommand((ANode)mband);
                command.enableSelectionRestore(true);
                command.setDebugLabel("Add in Table Crosstab Cell");
                ISelection currentSelection = null;
                int i = 0;
                while (i < editParts.size()) {
                    GraphicalEditPart child = (GraphicalEditPart)editParts.get(i);
                    if (currentSelection == null) {
                        currentSelection = child.getViewer().getSelection();
                    }
                    command.add(this.createAddCommand(request, (EditPart)child, this.translateToModelConstraint(this.getConstraintFor(request, child))));
                    ++i;
                }
                return command;
            }

            protected Command createAddCommand(EditPart child, Object constraint) {
                Rectangle rect = (Rectangle)constraint;
                if (child.getModel() instanceof MGraphicElement) {
                    MGraphicElement cmodel = (MGraphicElement)child.getModel();
                    MCell cparent = (MCell)cmodel.getParent();
                    if (cparent == CrosstabCellEditPart.this.getModel()) {
                        SetPageConstraintCommand cmd = new SetPageConstraintCommand();
                        MGraphicElement model = (MGraphicElement)child.getModel();
                        Rectangle r = model.getBounds();
                        JRDesignElement jde = model.getValue();
                        int x = r.x + rect.x - jde.getX() + 1;
                        int y = r.y + rect.y - jde.getY() + 1;
                        rect.setLocation(x, y);
                        cmd.setContext((ANode)CrosstabCellEditPart.this.getModel(), (ANode)child.getModel(), rect);
                        return cmd;
                    }
                    if (cparent != null) {
                        CompoundCommand c = new CompoundCommand();
                        c.add((Command)new OrphanElementCommand(cparent, cmodel));
                        c.add((Command)new CreateElementCommand(CrosstabCellEditPart.this.getModel(), cmodel, rect, -1));
                        return c;
                    }
                } else {
                    if (child instanceof CalloutEditPart) {
                        return new CalloutSetConstraintCommand(((CalloutEditPart)child).getModel(), this.adaptConstraint(constraint));
                    }
                    if (child instanceof PinEditPart) {
                        return new PinSetConstraintCommand(((PinEditPart)child).getModel(), this.adaptConstraint(constraint));
                    }
                }
                return null;
            }
        });
        this.installEditPolicy("Selection Feedback", (EditPolicy)new CrosstabCellResizableEditPolicy(){

            protected void showSelection() {
                if (CrosstabCellEditPart.this.getFigure().getBounds().height > 0) {
                    super.showSelection();
                    CrosstabCellEditPart.this.updateRulers();
                }
            }
        });
    }

    @Override
    protected void setupFigure(IFigure rect) {
        this.updateContainerSize();
        MCell model = this.getModel();
        rect.setToolTip((IFigure)new Label(model.getToolTip()));
        if (model.getValue() != null) {
            Rectangle bounds = model.getBounds();
            if (bounds == null) {
                bounds = new Rectangle(0, 0, 0, 0);
            }
            int x = bounds.x + ReportPageFigure.PAGE_BORDER.left;
            int y = bounds.y + ReportPageFigure.PAGE_BORDER.top;
            rect.setLocation(new Point(x, y));
            if (model instanceof MCell) {
                CellFigure f = (CellFigure)rect;
                f.setJRElement(model.getValue(), this.getDrawVisitor());
            } else {
                rect.setSize(bounds.width, bounds.height);
            }
            this.updateRulers();
        }
        if (this.getSelected() == 1) {
            this.updateRulers();
        } else {
            List selected = this.getViewer().getSelectedEditParts();
            if (selected.isEmpty()) {
                this.updateRulers();
            } else {
                for (Object obj : selected) {
                    FigureEditPart figEditPart;
                    if (!(obj instanceof FigureEditPart) || (figEditPart = (FigureEditPart)obj).getModel().getParent() != this.getModel()) continue;
                    figEditPart.updateRulers();
                }
            }
        }
    }

    @Override
    protected MCrosstab getCrosstab() {
        return this.getModel().getCrosstab();
    }
}

