/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.list.model.command.wizard;

import com.jaspersoft.studio.components.list.messages.Messages;
import com.jaspersoft.studio.components.list.model.MList;
import com.jaspersoft.studio.model.text.MTextField;
import com.jaspersoft.studio.property.dataset.wizard.WizardConnectionPage;
import com.jaspersoft.studio.property.dataset.wizard.WizardDatasetPage;
import com.jaspersoft.studio.wizards.JSSWizard;
import com.jaspersoft.studio.wizards.fields.StaticWizardFieldsPage;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.components.list.DesignListContents;
import net.sf.jasperreports.components.list.StandardListComponent;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.design.JRDesignComponentElement;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignDatasetRun;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.jface.wizard.IWizardPage;

public class ListWizard
extends JSSWizard {
    private WizardDatasetPage step1;
    private WizardConnectionPage step2;
    private StaticWizardFieldsPage step3;
    private int suggestedWidth = -1;
    private int suggestedHeight = -1;

    public ListWizard() {
        this.setWindowTitle(Messages.common_list);
        this.setNeedsProgressMonitor(true);
    }

    public ListWizard(int suggestedWidth, int suggestedHeight) {
        this();
        this.suggestedHeight = suggestedHeight;
        this.suggestedWidth = suggestedWidth;
    }

    public void addPages() {
        this.step1 = new WizardDatasetPage(false, Messages.ListWizard_0);
        this.addPage((IWizardPage)this.step1);
        this.step2 = new WizardConnectionPage();
        this.addPage((IWizardPage)this.step2);
        this.step3 = new StaticWizardFieldsPage();
        this.addPage((IWizardPage)this.step3);
        this.step3.setTitle(Messages.ListWizard_1);
        this.step3.setDescription(Messages.ListWizard_2);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.step2) {
            JRDesignDataset listDataset = this.step1.getSelectedDataset();
            if (listDataset != null && listDataset.getFieldsList().size() > 0) {
                this.getSettings().put("discovered_fields", new ArrayList(listDataset.getFieldsList()));
                this.getSettings().put("discovered_parameters", new ArrayList(listDataset.getParametersList()));
            } else {
                page = this.step3;
            }
        }
        return super.getNextPage(page);
    }

    public MList getList() {
        int elementWidth;
        MList list = new MList();
        JRDesignComponentElement jrElement = list.createJRElement(this.getConfig().getJasperDesign(), true);
        if (this.suggestedWidth > 0) {
            jrElement.setWidth(this.suggestedWidth);
        }
        if (this.suggestedHeight > 0) {
            jrElement.setHeight(this.suggestedHeight);
        }
        StandardListComponent jrList = (StandardListComponent)jrElement.getComponent();
        JRDesignDatasetRun datasetRun = (JRDesignDatasetRun)this.step2.getJRDesignDatasetRun().clone();
        jrList.setDatasetRun((JRDatasetRun)datasetRun);
        JRDesignDataset listDataset = this.step1.getSelectedDataset();
        if (listDataset != null) {
            datasetRun.setDatasetName(listDataset.getName());
        }
        list.setValue(jrElement);
        list.setJasperConfiguration(this.getConfig());
        List lst = this.step3.getSelectedFields();
        JasperDesign jd = this.getConfig().getJasperDesign();
        int x = 0;
        MTextField mtext = new MTextField();
        int n = elementWidth = lst.size() > 0 ? Math.round(jrElement.getWidth() / lst.size()) : jrElement.getWidth();
        if (lst != null) {
            for (Object f : lst) {
                JRDesignTextField element = mtext.createJRElement(jd, true);
                element.setX(x);
                element.setWidth(elementWidth);
                element.setHeight(jrElement.getHeight());
                String field = ((JRField)f).getName();
                element.setExpression((JRExpression)new JRDesignExpression("$F{" + field + "}"));
                ((DesignListContents)jrList.getContents()).addElement((JRDesignElement)element);
                x += element.getWidth();
            }
        }
        return list;
    }

    public boolean canFinish() {
        if (this.getContainer().getCurrentPage() == this.step1) {
            return false;
        }
        return super.canFinish();
    }
}

