/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.map.figure;

import com.jaspersoft.studio.jasper.AComponentDesignConverter;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import net.sf.jasperreports.components.map.MapComponent;
import net.sf.jasperreports.components.map.type.MapImageTypeEnum;
import net.sf.jasperreports.components.map.type.MapScaleEnum;
import net.sf.jasperreports.components.map.type.MapTypeEnum;
import net.sf.jasperreports.eclipse.util.KeyValue;
import net.sf.jasperreports.eclipse.util.StringUtils;
import net.sf.jasperreports.engine.JRComponentElement;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRElementDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.component.Component;
import net.sf.jasperreports.engine.convert.ReportConverter;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.OnErrorTypeEnum;
import net.sf.jasperreports.renderers.Renderable;
import net.sf.jasperreports.renderers.util.RendererUtil;

public class MapDesignConverter
extends AComponentDesignConverter {
    public static final Number DEFAULT_LONGITUDE = Float.valueOf(12.337967f);
    public static final Number DEFAULT_LATITUDE = Float.valueOf(45.433968f);

    public String getComponentName() {
        return "map";
    }

    public MapDesignConverter() {
        super("net/sf/jasperreports/engine/images/component-16.png");
    }

    protected OnErrorTypeEnum getOnErrorType(Component cmp) {
        return ((MapComponent)cmp).getOnErrorType();
    }

    protected String getEKey(JRComponentElement element) {
        MapComponent map = (MapComponent)element.getComponent();
        String ekey = "" + element.getWidth() + element.getHeight();
        if (map.getLongitudeExpression() != null) {
            ekey = String.valueOf(ekey) + map.getLongitudeExpression().getText();
        }
        if (map.getLatitudeExpression() != null) {
            ekey = String.valueOf(ekey) + map.getLatitudeExpression().getText();
        }
        if (map.getLanguageExpression() != null) {
            ekey = String.valueOf(ekey) + map.getLanguageExpression().getText();
        }
        if (map.getZoomExpression() != null) {
            ekey = String.valueOf(ekey) + map.getZoomExpression().getText();
        }
        if (map.getMapType() != null) {
            ekey = String.valueOf(ekey) + map.getMapType().getName();
        }
        if (map.getMapScale() != null) {
            ekey = String.valueOf(ekey) + map.getMapScale().getName();
        }
        return ekey;
    }

    protected Renderable doRenderable(ReportConverter reportConverter, JRComponentElement element, Component cmp, String ekey, JasperReportsConfiguration jrContext, KeyValue<String, Long> kv) throws JRException {
        String dname;
        MapComponent map = (MapComponent)cmp;
        System.out.println("loading map");
        JasperDesign jd = jrContext.getJasperDesign();
        JRDataset jrd = jd.getMainDataset();
        JRElementDataset dataset = null;
        if (ModelUtils.getSingleMarkerData((MapComponent)map) != null) {
            dataset = ModelUtils.getSingleMarkerData((MapComponent)map).getDataset();
        }
        if (dataset != null && dataset.getDatasetRun() != null && (dname = dataset.getDatasetRun().getDatasetName()) != null) {
            jrd = (JRDataset)jd.getDatasetMap().get(dname);
        }
        Number latitude = (Number)MapDesignConverter.evaluate((JRExpression)map.getLatitudeExpression(), (JRDataset)jrd, (JasperReportsConfiguration)jrContext, (Object)DEFAULT_LATITUDE);
        Number longitude = (Number)MapDesignConverter.evaluate((JRExpression)map.getLongitudeExpression(), (JRDataset)jrd, (JasperReportsConfiguration)jrContext, (Object)DEFAULT_LONGITUDE);
        Integer zoom = (Integer)MapDesignConverter.evaluate((JRExpression)map.getZoomExpression(), (JRDataset)jrd, (JasperReportsConfiguration)jrContext, (Object)MapComponent.DEFAULT_ZOOM);
        String mapType = map.getMapType() != null ? map.getMapType().getName() : MapTypeEnum.ROADMAP.getName();
        String mapScale = map.getMapScale() != null ? map.getMapScale().getName() : MapScaleEnum.ONE.getName();
        String mapFormat = MapImageTypeEnum.PNG.getName();
        String language = (String)MapDesignConverter.evaluate((JRExpression)map.getLanguageExpression(), (JRDataset)jrd, (JasperReportsConfiguration)jrContext, (Object)"");
        String markers = "";
        String apiKey = jrContext.getJasperDesign().getProperty("net.sf.jasperreports.components.map.key");
        String imageLocation = "https://maps.google.com/maps/api/staticmap?center=" + latitude.floatValue() % 90.0f + "," + longitude.floatValue() % 180.0f + "&size=" + element.getWidth() + "x" + element.getHeight() + "&zoom=" + zoom + (mapType == null ? "" : "&maptype=" + mapType) + (mapFormat == null ? "" : "&format=" + mapFormat) + (mapScale == null ? "" : "&scale=" + mapScale) + markers + "&sensor=false" + (language == null ? "" : "&language=" + language) + (!StringUtils.isNullOrEmpty((String)apiKey) ? "&key=" + apiKey : "");
        kv.key = ekey;
        return RendererUtil.getInstance((JasperReportsContext)jrContext).getNonLazyRenderable(imageLocation, OnErrorTypeEnum.ERROR);
    }
}

