/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.map.model.itemdata;

import com.jaspersoft.studio.components.Activator;
import com.jaspersoft.studio.components.map.messages.Messages;
import com.jaspersoft.studio.components.map.model.itemdata.ElementDataHelper;
import com.jaspersoft.studio.components.map.model.itemdata.ElementsListWidgetConfiguration;
import com.jaspersoft.studio.components.map.model.itemdata.ElementsTreeStatus;
import com.jaspersoft.studio.components.map.model.itemdata.MapDataDatasetsLabelProvider;
import com.jaspersoft.studio.components.map.model.itemdata.dialog.ElementDatasetDialog;
import com.jaspersoft.studio.components.map.model.itemdata.dialog.ElementItemDialog;
import com.jaspersoft.studio.components.map.model.itemdata.dialog.MapElementDialog;
import com.jaspersoft.studio.components.map.model.itemdata.dto.MapDataDatasetDTO;
import com.jaspersoft.studio.components.map.model.itemdata.dto.MapDataElementDTO;
import com.jaspersoft.studio.components.map.model.itemdata.dto.MapDataElementItemDTO;
import com.jaspersoft.studio.components.map.model.itemdata.dto.MapDataElementsConfiguration;
import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.property.section.AbstractSection;
import com.jaspersoft.studio.property.section.widgets.ASPropertyWidget;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.util.List;
import net.sf.jasperreports.components.items.Item;
import net.sf.jasperreports.components.items.ItemProperty;
import net.sf.jasperreports.components.items.StandardItem;
import net.sf.jasperreports.components.items.StandardItemProperty;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JRCloneable;
import net.sf.jasperreports.engine.JRElementDataset;
import net.sf.jasperreports.engine.util.JRCloneUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public abstract class SPMapDataElementsList
extends ASPropertyWidget<IPropertyDescriptor> {
    private MapDataElementsConfiguration mapElementsConfig;
    private JasperReportsConfiguration jConfig;
    private ExpressionContext defaultExpressionContext;
    private Button btnAddNewElement;
    private Button btnMoveUpItem;
    private Button btnMoveDownItem;
    private TreeViewer elementsTV;
    private Composite datasetsCmp;
    private Composite elementsCmp;
    private TabFolder tabfolder;
    private TableViewer datasetsTV;
    private Button btnAddNewDataset;
    private Button btnModifyDataset;
    private Button btnRemoveDataset;
    private ElementsTreeStatus treeStatus;
    private ElementsListWidgetConfiguration widgetConfig;

    public SPMapDataElementsList(Composite parent, AbstractSection section, IPropertyDescriptor pDescriptor) {
        super(parent, section, pDescriptor);
    }

    protected void createComponent(Composite parent) {
        this.widgetConfig = this.getWidgetConfiguration();
        this.tabfolder = new TabFolder(parent, 0);
        GridData tabfolderGD = new GridData(4, 4, true, false);
        tabfolderGD.heightHint = 150;
        this.tabfolder.setLayoutData((Object)tabfolderGD);
        this.createElementsTab(this.tabfolder);
        this.createDatasetsTab(this.tabfolder);
    }

    protected abstract ElementsListWidgetConfiguration getWidgetConfiguration();

    private void createElementsTab(TabFolder parentFolder) {
        TabItem elementsTab = new TabItem(parentFolder, 0);
        this.elementsCmp = new Composite((Composite)parentFolder, 0);
        this.elementsCmp.setLayout((Layout)new GridLayout(2, false));
        elementsTab.setControl((Control)this.elementsCmp);
        elementsTab.setText(this.widgetConfig.getElementsTabTitle());
        this.elementsTV = new TreeViewer(this.elementsCmp, 2820);
        this.elementsTV.getTree().setLayoutData((Object)new GridData(4, 4, true, true, 1, 3));
        this.elementsTV.setLabelProvider(this.getElementsViewerLabelProvider());
        this.elementsTV.setContentProvider(this.getElementsViewerContentProvider());
        this.elementsTV.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SPMapDataElementsList.this.enableDefaultTreeButtons();
            }
        });
        this.elementsTV.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object selObj = SPMapDataElementsList.this.getElementsTVSelectedObj();
                if (selObj instanceof MapDataElementDTO) {
                    SPMapDataElementsList.this.modifySelectedElement((MapDataElementDTO)selObj);
                } else if (selObj instanceof MapDataElementItemDTO) {
                    SPMapDataElementsList.this.modifySelectedElementItem((MapDataElementItemDTO)selObj);
                }
            }
        });
        this.btnAddNewElement = new Button(this.elementsCmp, 0);
        this.btnAddNewElement.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.btnAddNewElement.setImage(this.widgetConfig.getAddNewElementIcon());
        this.btnAddNewElement.setToolTipText(NLS.bind((String)Messages.SPMapDataElementsList_AddNewElement, (Object)this.widgetConfig.getElementTxt()));
        this.btnAddNewElement.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SPMapDataElementsList.this.addNewElementBtnPressed();
            }
        });
        this.btnMoveUpItem = new Button(this.elementsCmp, 0);
        this.btnMoveUpItem.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.btnMoveUpItem.setImage(Activator.getDefault().getImage("/icons/pathitem-moveup-16.png"));
        this.btnMoveUpItem.setToolTipText(Messages.SPMapDataElementsList_MoveUp);
        this.btnMoveUpItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SPMapDataElementsList.this.moveUpItemBtnPressed();
            }
        });
        this.btnMoveDownItem = new Button(this.elementsCmp, 0);
        this.btnMoveDownItem.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.btnMoveDownItem.setImage(Activator.getDefault().getImage("/icons/pathitem-movedown-16.png"));
        this.btnMoveDownItem.setToolTipText(Messages.SPMapDataElementsList_MoveDown);
        this.btnMoveDownItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SPMapDataElementsList.this.moveDownItemBtnPressed();
            }
        });
        this.enableDefaultTreeButtons();
        this.addTreeMenuManager();
    }

    protected abstract IBaseLabelProvider getElementsViewerLabelProvider();

    protected abstract IContentProvider getElementsViewerContentProvider();

    private void addTreeMenuManager() {
        MenuManager menuMgr = new MenuManager();
        Menu menu = menuMgr.createContextMenu(this.elementsTV.getControl());
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                if (SPMapDataElementsList.this.elementsTV.getSelection().isEmpty()) {
                    return;
                }
                if (SPMapDataElementsList.this.elementsTV.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection selection = (IStructuredSelection)SPMapDataElementsList.this.elementsTV.getSelection();
                    Object selObj = selection.getFirstElement();
                    if (selObj instanceof MapDataElementItemDTO) {
                        manager.add((IAction)new EditItemAction());
                        manager.add((IAction)new DeleteItemAction());
                    } else if (selObj instanceof MapDataElementDTO) {
                        manager.add((IAction)new AddItemAction());
                        manager.add((IAction)new EditElementAction());
                        manager.add((IAction)new DeleteElementAction());
                    } else {
                        return;
                    }
                }
            }
        });
        menuMgr.setRemoveAllWhenShown(true);
        this.elementsTV.getControl().setMenu(menu);
    }

    private void modifySelectedElement(MapDataElementDTO selectedElement) {
        ItemProperty clonedElementName = (ItemProperty)JRCloneUtils.nullSafeClone((JRCloneable)selectedElement.getName());
        if (clonedElementName == null) {
            clonedElementName = new StandardItemProperty("name", "", null);
        }
        MapElementDialog dialog = new MapElementDialog(UIUtils.getShell(), clonedElementName, this.widgetConfig);
        dialog.setExpressionContext(this.getDefaultExpressionContext());
        if (dialog.open() == 0) {
            selectedElement.setName(dialog.getElementName());
            this.firePropertyChanged(ElementsTreeStatus.LAST_OPERATION.EDIT);
        }
    }

    private void modifySelectedElementItem(MapDataElementItemDTO selObj) {
        MapDataElementItemDTO itemDTOClone = (MapDataElementItemDTO)selObj.clone();
        ElementItemDialog dialog = new ElementItemDialog(UIUtils.getShell(), itemDTOClone, this.widgetConfig, this.mapElementsConfig.getElementDatasetsMap(), this.jConfig);
        dialog.setMandatoryPropertyNames(this.getMandatoryProperties());
        if (dialog.open() == 0) {
            ElementDataHelper.updateElementDataItem(this.mapElementsConfig, itemDTOClone.getParentName(), selObj, dialog.getItemDTO());
            this.firePropertyChanged(ElementsTreeStatus.LAST_OPERATION.EDIT);
        }
    }

    protected abstract List<String> getMandatoryProperties();

    private void enableDefaultTreeButtons() {
        this.btnAddNewElement.setEnabled(true);
        Object selElement = ((IStructuredSelection)this.elementsTV.getSelection()).getFirstElement();
        boolean enableMoveBtns = !this.elementsTV.getSelection().isEmpty() && selElement instanceof MapDataElementItemDTO;
        this.btnMoveDownItem.setEnabled(enableMoveBtns);
        this.btnMoveUpItem.setEnabled(enableMoveBtns);
    }

    protected void addNewElementBtnPressed() {
        StandardItemProperty pname = new StandardItemProperty();
        pname.setName("name");
        MapElementDialog dialog = new MapElementDialog(UIUtils.getShell(), (ItemProperty)pname, this.widgetConfig);
        dialog.setExpressionContext(this.getDefaultExpressionContext());
        if (dialog.open() == 0) {
            MapDataElementDTO newElement = new MapDataElementDTO();
            ItemProperty elementName = dialog.getElementName();
            newElement.setName(elementName);
            MapDataElementItemDTO dummyElementItem = new MapDataElementItemDTO(elementName);
            dummyElementItem.setDatasetName(null);
            StandardItem dummyItem = new StandardItem();
            dummyItem.addItemProperty(elementName);
            for (String p : this.getMandatoryProperties()) {
                dummyItem.addItemProperty((ItemProperty)new StandardItemProperty(p, "CHANGE_ME", null));
            }
            dummyElementItem.setItem((Item)dummyItem);
            newElement.getDataItems().add(dummyElementItem);
            this.mapElementsConfig.getElements().add(newElement);
            this.firePropertyChanged(ElementsTreeStatus.LAST_OPERATION.ADD);
        }
    }

    protected void moveDownItemBtnPressed() {
        MapDataElementItemDTO item = (MapDataElementItemDTO)((IStructuredSelection)this.elementsTV.getSelection()).getFirstElement();
        ItemProperty parentName = item.getParentName();
        ElementDataHelper.moveDownDataItem(this.mapElementsConfig, parentName, item);
        this.firePropertyChanged(ElementsTreeStatus.LAST_OPERATION.MOVEDOWN);
    }

    protected void moveUpItemBtnPressed() {
        MapDataElementItemDTO item = (MapDataElementItemDTO)((IStructuredSelection)this.elementsTV.getSelection()).getFirstElement();
        ItemProperty parentName = item.getParentName();
        ElementDataHelper.moveUpDataItem(this.mapElementsConfig, parentName, item);
        this.firePropertyChanged(ElementsTreeStatus.LAST_OPERATION.MOVEUP);
    }

    private void createDatasetsTab(TabFolder parentFolder) {
        TabItem datasetsTab = new TabItem(parentFolder, 0);
        this.datasetsCmp = new Composite((Composite)parentFolder, 0);
        this.datasetsCmp.setLayout((Layout)new GridLayout(2, false));
        datasetsTab.setControl((Control)this.datasetsCmp);
        datasetsTab.setText(Messages.SPMapDataElementsList_DatasetTabTitle);
        this.datasetsTV = new TableViewer(this.datasetsCmp, 2564);
        this.datasetsTV.getTable().setLayoutData((Object)new GridData(4, 4, true, true, 1, 3));
        this.datasetsTV.setLabelProvider((IBaseLabelProvider)new MapDataDatasetsLabelProvider());
        this.datasetsTV.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.datasetsTV.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SPMapDataElementsList.this.enableDefaultDatasetsButtons();
            }
        });
        this.datasetsTV.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SPMapDataElementsList.this.editDatasetBtnPressed();
            }
        });
        this.btnAddNewDataset = new Button(this.datasetsCmp, 0);
        this.btnAddNewDataset.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.btnAddNewDataset.setImage(Activator.getDefault().getImage("/icons/add_element.gif"));
        this.btnAddNewDataset.setToolTipText(Messages.SPMapDataElementsList_AddNewDatasetBtnTooltip);
        this.btnAddNewDataset.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SPMapDataElementsList.this.addNewDatasetBtnPressed();
            }
        });
        this.btnModifyDataset = new Button(this.datasetsCmp, 0);
        this.btnModifyDataset.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.btnModifyDataset.setImage(Activator.getDefault().getImage("/icons/edit_element.gif"));
        this.btnModifyDataset.setToolTipText(Messages.SPMapDataElementsList_ModifyDatasetBtnTooltip);
        this.btnModifyDataset.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SPMapDataElementsList.this.editDatasetBtnPressed();
            }
        });
        this.btnRemoveDataset = new Button(this.datasetsCmp, 0);
        this.btnRemoveDataset.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.btnRemoveDataset.setImage(Activator.getDefault().getImage("/icons/delete_element.gif"));
        this.btnRemoveDataset.setToolTipText(Messages.SPMapDataElementsList_DeleteDatasetBtnTooltip);
        this.btnRemoveDataset.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SPMapDataElementsList.this.removeDatasetBtnPressed();
            }
        });
        this.enableDefaultDatasetsButtons();
    }

    private void enableDefaultDatasetsButtons() {
        this.btnAddNewDataset.setEnabled(true);
        this.btnModifyDataset.setEnabled(!this.datasetsTV.getSelection().isEmpty());
        this.btnRemoveDataset.setEnabled(!this.datasetsTV.getSelection().isEmpty());
    }

    private void addNewDatasetBtnPressed() {
        ElementDatasetDialog elementDatasetDialog = new ElementDatasetDialog(UIUtils.getShell(), Messages.SPMapDataElementsList_AddDatasetDialogTitle, NLS.bind((String)Messages.SPMapDataElementsList_AddDatasetDialogInfoMsg, (Object)this.widgetConfig.getElementTxt()), null, this.jConfig);
        elementDatasetDialog.setDefaultExpressionContext(this.getDefaultExpressionContext());
        if (elementDatasetDialog.open() == 0) {
            JRElementDataset newDataset = elementDatasetDialog.getDataset();
            MapDataDatasetDTO dto = new MapDataDatasetDTO();
            dto.setDataset(newDataset);
            this.mapElementsConfig.getDatasets().add(dto);
            this.refreshDatasetsTableViewer();
        }
    }

    private void editDatasetBtnPressed() {
        Object firstElement = ((IStructuredSelection)this.datasetsTV.getSelection()).getFirstElement();
        if (firstElement instanceof MapDataDatasetDTO) {
            Object dsClone = ((MapDataDatasetDTO)firstElement).getDataset().clone();
            ElementDatasetDialog elementDatasetDialog = new ElementDatasetDialog(UIUtils.getShell(), Messages.SPMapDataElementsList_EditDatasetDialogTitle, NLS.bind((String)Messages.SPMapDataElementsList_EditDatasetDialogInfoMsg, (Object)this.widgetConfig.getElementTxt()), (JRElementDataset)dsClone, this.jConfig);
            elementDatasetDialog.setDefaultExpressionContext(this.getDefaultExpressionContext());
            if (elementDatasetDialog.open() == 0) {
                JRElementDataset modifiedDataset = elementDatasetDialog.getDataset();
                ((MapDataDatasetDTO)firstElement).setDataset(modifiedDataset);
                this.refreshDatasetsTableViewer();
            }
        }
    }

    private void removeDatasetBtnPressed() {
        boolean confirm;
        Object firstElement = ((IStructuredSelection)this.datasetsTV.getSelection()).getFirstElement();
        if (firstElement instanceof MapDataDatasetDTO && (confirm = MessageDialog.openQuestion((Shell)UIUtils.getShell(), (String)Messages.SPMapDataElementsList_RemoveDatasetQuestionTitle, (String)NLS.bind((String)Messages.SPMapDataElementsList_RemoveDatasetQuestionMsg, (Object)this.widgetConfig.getElementTxt())))) {
            this.mapElementsConfig.getDatasets().remove((MapDataDatasetDTO)firstElement);
            this.refreshDatasetsTableViewer();
        }
    }

    private void refreshDatasetsTableViewer() {
        ElementDataHelper.fixDatasetNames(this.mapElementsConfig);
        this.firePropertyChanged(null);
    }

    private void firePropertyChanged(ElementsTreeStatus.LAST_OPERATION lastOperation) {
        this.treeStatus = lastOperation != null ? ElementsTreeStatus.getElementsTreeStatus(this.elementsTV, lastOperation) : null;
        this.section.changeProperty((Object)this.widgetConfig.getWidgetPropertyID(), (Object)this.mapElementsConfig);
    }

    public void setData(APropertyNode pnode, Object value) {
        this.mapElementsConfig = (MapDataElementsConfiguration)value;
        this.elementsTV.setInput(this.mapElementsConfig.getElements());
        this.datasetsTV.setInput(this.mapElementsConfig.getDatasets());
        this.jConfig = pnode.getJasperConfiguration();
        this.defaultExpressionContext = ModelUtils.getElementExpressionContext(null, (ANode)pnode);
        if (this.treeStatus != null) {
            Object[] expandedElements = this.treeStatus.findExpandedElements(this.mapElementsConfig.getElements());
            this.elementsTV.setExpandedElements(expandedElements);
            ISelection selection = ElementsTreeStatus.getSuggestedSelection(this.elementsTV, this.treeStatus);
            this.elementsTV.setSelection(selection);
        }
    }

    public Control getControl() {
        return this.tabfolder;
    }

    private ExpressionContext getDefaultExpressionContext() {
        return this.defaultExpressionContext;
    }

    private StandardItem createStandardItem() {
        StandardItem item = new StandardItem();
        for (String pname : this.getMandatoryProperties()) {
            item.addItemProperty((ItemProperty)new StandardItemProperty(pname, "CHANGE_ME", null));
        }
        return item;
    }

    private Object getElementsTVSelectedObj() {
        IStructuredSelection selection = (IStructuredSelection)this.elementsTV.getSelection();
        return selection.getFirstElement();
    }

    private class AddItemAction
    extends Action {
        private AddItemAction() {
            this.setText(Messages.SPMapDataElementsList_AddNewItem);
            this.setToolTipText(NLS.bind((String)Messages.SPMapDataElementsList_AddNewItemTooltip, (Object)SPMapDataElementsList.this.widgetConfig.getElementTxt()));
            this.setImageDescriptor(Activator.getDefault().getImageDescriptor("/icons/add_element.gif"));
        }

        public void run() {
            Object selObj = ((IStructuredSelection)SPMapDataElementsList.this.elementsTV.getSelection()).getFirstElement();
            if (selObj instanceof MapDataElementDTO) {
                ItemProperty elementName = ((MapDataElementDTO)selObj).getName();
                MapDataElementItemDTO newItemDTO = new MapDataElementItemDTO(elementName);
                StandardItem newItem = SPMapDataElementsList.this.createStandardItem();
                newItem.addItemProperty((ItemProperty)elementName.clone());
                newItemDTO.setItem((Item)newItem);
                ElementItemDialog dialog = new ElementItemDialog(UIUtils.getShell(), newItemDTO, SPMapDataElementsList.this.widgetConfig, SPMapDataElementsList.this.mapElementsConfig.getElementDatasetsMap(), SPMapDataElementsList.this.jConfig);
                dialog.setMandatoryPropertyNames(SPMapDataElementsList.this.getMandatoryProperties());
                dialog.setDefaultExpressionContext(SPMapDataElementsList.this.getDefaultExpressionContext());
                if (dialog.open() == 0) {
                    ((MapDataElementDTO)selObj).getDataItems().add(dialog.getItemDTO());
                    SPMapDataElementsList.this.firePropertyChanged(ElementsTreeStatus.LAST_OPERATION.ADD);
                }
            }
        }
    }

    private class DeleteElementAction
    extends Action {
        private DeleteElementAction() {
            this.setText(NLS.bind((String)Messages.SPMapDataElementsList_DeleteElement, (Object)SPMapDataElementsList.this.widgetConfig.getElementTxt()));
            this.setToolTipText(NLS.bind((String)Messages.SPMapDataElementsList_DeleteElementTooltip, (Object)SPMapDataElementsList.this.widgetConfig.getElementTxt()));
            this.setImageDescriptor(Activator.getDefault().getImageDescriptor("/icons/delete_element.gif"));
        }

        public void run() {
            IStructuredSelection selection;
            Object selObj;
            boolean deleteElement = MessageDialog.openQuestion((Shell)UIUtils.getShell(), (String)NLS.bind((String)Messages.SPMapDataElementsList_DeleteElement, (Object)SPMapDataElementsList.this.widgetConfig.getElementTxt()), (String)NLS.bind((String)Messages.SPMapDataElementsList_ConfirmElementDelete, (Object)SPMapDataElementsList.this.widgetConfig.getElementTxt()));
            if (deleteElement && (selObj = (selection = (IStructuredSelection)SPMapDataElementsList.this.elementsTV.getSelection()).getFirstElement()) instanceof MapDataElementDTO) {
                SPMapDataElementsList.this.mapElementsConfig.getElements().remove(selObj);
                SPMapDataElementsList.this.firePropertyChanged(ElementsTreeStatus.LAST_OPERATION.REMOVE);
            }
        }
    }

    private class DeleteItemAction
    extends Action {
        private DeleteItemAction() {
            this.setText(Messages.SPMapDataElementsList_DeleteItem);
            this.setToolTipText(NLS.bind((String)Messages.SPMapDataElementsList_DeleteItemTooltip, (Object)SPMapDataElementsList.this.widgetConfig.getElementTxt()));
            this.setImageDescriptor(Activator.getDefault().getImageDescriptor("/icons/delete_element.gif"));
        }

        public void run() {
            boolean delete = MessageDialog.openQuestion((Shell)UIUtils.getShell(), (String)NLS.bind((String)Messages.SPMapDataElementsList_RemoveQuestionTitle, (Object)SPMapDataElementsList.this.widgetConfig.getElementTxt()), (String)NLS.bind((String)Messages.SPMapDataElementsList_RemoveQuestionMsg, (Object)SPMapDataElementsList.this.widgetConfig.getElementTxt()));
            if (delete) {
                MapDataElementItemDTO item = (MapDataElementItemDTO)((IStructuredSelection)SPMapDataElementsList.this.elementsTV.getSelection()).getFirstElement();
                ItemProperty parentName = item.getParentName();
                ElementDataHelper.removeElementDataItem(SPMapDataElementsList.this.mapElementsConfig, parentName, item);
                SPMapDataElementsList.this.firePropertyChanged(ElementsTreeStatus.LAST_OPERATION.REMOVE);
            }
        }
    }

    private class EditElementAction
    extends Action {
        private EditElementAction() {
            this.setText(NLS.bind((String)Messages.SPMapDataElementsList_EditElement, (Object)SPMapDataElementsList.this.widgetConfig.getElementTxt()));
            this.setToolTipText(NLS.bind((String)Messages.SPMapDataElementsList_EditElementTooltip, (Object)SPMapDataElementsList.this.widgetConfig.getElementTxt()));
            this.setImageDescriptor(Activator.getDefault().getImageDescriptor("/icons/edit_element.gif"));
        }

        public void run() {
            Object selObj = SPMapDataElementsList.this.getElementsTVSelectedObj();
            if (selObj instanceof MapDataElementDTO) {
                SPMapDataElementsList.this.modifySelectedElement((MapDataElementDTO)selObj);
            }
        }
    }

    private class EditItemAction
    extends Action {
        private EditItemAction() {
            this.setText(Messages.SPMapDataElementsList_EditItem);
            this.setToolTipText(NLS.bind((String)Messages.SPMapDataElementsList_EditItemTooltip, (Object)SPMapDataElementsList.this.widgetConfig.getElementTxt()));
            this.setImageDescriptor(Activator.getDefault().getImageDescriptor("/icons/edit_element.gif"));
        }

        public void run() {
            Object selObj = SPMapDataElementsList.this.getElementsTVSelectedObj();
            if (selObj instanceof MapDataElementItemDTO) {
                SPMapDataElementsList.this.modifySelectedElementItem((MapDataElementItemDTO)selObj);
            }
        }
    }
}

