/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.map.model.itemdata.dto;

import com.jaspersoft.studio.components.map.model.itemdata.dto.MapDataDatasetDTO;
import com.jaspersoft.studio.components.map.model.itemdata.dto.MapDataElementDTO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRCloneable;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.util.JRCloneUtils;

public class MapDataElementsConfiguration
implements JRCloneable {
    private List<MapDataDatasetDTO> datasets;
    private List<MapDataElementDTO> elements;
    private String elementLabel;

    public MapDataElementsConfiguration(String elementLabel) {
        this.elementLabel = elementLabel;
    }

    public List<MapDataDatasetDTO> getDatasets() {
        if (this.datasets == null) {
            this.datasets = new ArrayList<MapDataDatasetDTO>();
        }
        return this.datasets;
    }

    public void setDatasets(List<MapDataDatasetDTO> datasets) {
        this.datasets = datasets;
    }

    public List<MapDataElementDTO> getElements() {
        if (this.elements == null) {
            this.elements = new ArrayList<MapDataElementDTO>();
        }
        return this.elements;
    }

    public void setElements(List<MapDataElementDTO> elements) {
        this.elements = elements;
    }

    public List<String> getAllDatasetNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (MapDataDatasetDTO d : this.datasets) {
            names.add(d.getName());
        }
        return names;
    }

    public Map<String, String> getElementDatasetsMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (MapDataDatasetDTO d : this.datasets) {
            JRDatasetRun dsRun = d.getDataset().getDatasetRun();
            String designDSname = "";
            if (dsRun != null) {
                designDSname = dsRun.getDatasetName();
            }
            map.put(d.getName(), designDSname);
        }
        return map;
    }

    public Object clone() {
        MapDataElementsConfiguration clone = new MapDataElementsConfiguration(this.getElementLabel());
        clone.setDatasets(JRCloneUtils.cloneList(this.getDatasets()));
        clone.setElements(JRCloneUtils.cloneList(this.getElements()));
        return clone;
    }

    public String getElementLabel() {
        return this.elementLabel;
    }
}

