/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.map.property;

import com.jaspersoft.studio.components.map.property.ItemElementPropertyEditor;
import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.editor.expression.IExpressionContextSetter;
import com.jaspersoft.studio.property.itemproperty.desc.ItemPropertyBaseLabelProvider;
import com.jaspersoft.studio.widgets.framework.IPropertyEditor;
import com.jaspersoft.studio.widgets.framework.WItemProperty;
import com.jaspersoft.studio.widgets.framework.events.ItemPropertyModifiedEvent;
import com.jaspersoft.studio.widgets.framework.events.ItemPropertyModifiedListener;
import com.jaspersoft.studio.widgets.framework.ui.ItemPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.providers.BaseLabelProvider;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.sf.jasperreports.components.items.Item;
import net.sf.jasperreports.components.items.ItemProperty;
import net.sf.jasperreports.components.items.StandardItem;
import net.sf.jasperreports.components.items.StandardItemProperty;
import net.sf.jasperreports.eclipse.ui.ATitledDialog;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public abstract class ItemElementDialog
extends ATitledDialog
implements IExpressionContextSetter {
    private Item item;
    private IPropertyEditor propEditor;
    private List<ItemPropertyDescription<?>> descriptions;
    private Map<String, WItemProperty> map = new HashMap<String, WItemProperty>();
    private boolean refresh = false;
    private ExpressionContext expContext;
    protected Composite containerCmp;

    public ItemElementDialog(Shell parentShell, Item itemElement) {
        super(parentShell);
        this.item = itemElement == null ? new StandardItem() : (Item)itemElement.clone();
        this.propEditor = this.createElementEditor();
        this.descriptions = this.initItemPropertiesDescriptions();
        this.setDefaultSize(UIUtils.getScaledWidth((int)500), UIUtils.getScaledHeight((int)400));
    }

    protected abstract List<ItemPropertyDescription<?>> initItemPropertiesDescriptions();

    protected Control createDialogArea(Composite parent) {
        this.containerCmp = (Composite)super.createDialogArea(parent);
        ((GridLayout)this.containerCmp.getLayout()).numColumns = 2;
        this.createItemPropertiesWidgets();
        UIUtils.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ItemElementDialog.this.fillData();
            }
        });
        return this.containerCmp;
    }

    protected abstract void createItemPropertiesWidgets();

    private void fillData() {
        this.refresh = true;
        try {
            for (String key : this.map.keySet()) {
                WItemProperty expr = this.map.get(key);
                expr.setExpressionContext(this.expContext);
                boolean createNew = true;
                for (ItemProperty ip : this.item.getProperties()) {
                    if (ip == null || !ip.getName().equals(key)) continue;
                    expr.setValue(ip.getValue(), ip.getValueExpression());
                    createNew = false;
                    break;
                }
                if (!createNew) continue;
                StandardItemProperty p = new StandardItemProperty();
                p.setName(key);
                expr.setValue(p.getValue(), p.getValueExpression());
            }
        }
        finally {
            this.refresh = false;
        }
        this.setError(null);
        this.tcmp.getParent().update();
        this.tcmp.getParent().layout(true);
    }

    protected void createItemProperty(Composite cmp, String key) {
        ItemPropertyDescription<?> ipd = this.getItemPropertyDescription(key);
        if (ipd == null) {
            return;
        }
        Label lbl = new Label(cmp, 0);
        lbl.setText(ipd.getLabel());
        lbl.setToolTipText(ipd.getToolTip());
        final WItemProperty expr = new WItemProperty(cmp, 0, ipd, this.getElementEditor());
        expr.setLabelProvider((BaseLabelProvider)new ItemPropertyBaseLabelProvider());
        GridData gd = new GridData(768);
        expr.setLayoutData((Object)gd);
        expr.addModifyListener(new ItemPropertyModifiedListener(){

            public void itemModified(ItemPropertyModifiedEvent event) {
                if (expr.isRefresh()) {
                    return;
                }
                if (ItemElementDialog.this.refresh) {
                    return;
                }
            }
        });
        this.map.put(key, expr);
    }

    public ItemPropertyDescription<?> getItemPropertyDescription(String id) {
        for (ItemPropertyDescription<?> ip : this.descriptions) {
            if (!ip.getName().equals(id)) continue;
            return ip;
        }
        return null;
    }

    private IPropertyEditor createElementEditor() {
        return new ItemElementPropertyEditor(this.item);
    }

    public IPropertyEditor getElementEditor() {
        if (this.propEditor == null) {
            this.propEditor = this.createElementEditor();
        }
        return this.propEditor;
    }

    public void setExpressionContext(ExpressionContext expContext) {
        this.expContext = expContext;
    }

    public Item getModifiedItem() {
        Predicate<ItemProperty> isEmpty = item -> item.getValue() == null && item.getValueExpression() == null;
        this.item.getProperties().removeIf(isEmpty);
        return this.item.getProperties().isEmpty() ? null : this.item;
    }
}

