/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.map.property;

import com.jaspersoft.studio.components.map.messages.Messages;
import com.jaspersoft.studio.components.map.model.MMap;
import com.jaspersoft.studio.properties.view.TabbedPropertySheetPage;
import com.jaspersoft.studio.property.section.AbstractSection;
import com.jaspersoft.studio.property.section.widgets.SPEvaluationTime;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.widgets.map.core.LatLng;
import com.jaspersoft.studio.widgets.map.core.MapType;
import com.jaspersoft.studio.widgets.map.support.GMapUtils;
import com.jaspersoft.studio.widgets.map.support.MapCredentials;
import com.jaspersoft.studio.widgets.map.ui.GMapCenterDialog;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.BasicMapInfoData;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class MapSection
extends AbstractSection {
    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        parent.setLayout((Layout)new GridLayout(2, false));
        this.createWidget4Property(parent, "latitudeExpression");
        this.createWidget4Property(parent, "longitudeExpression");
        this.createWidget4Property(parent, "addressExpression");
        this.createWidget4Property(parent, "zoomExpression");
        this.createWidget4Property(parent, "mapType");
        this.createWidget4Property(parent, "languageExpression");
        this.createWidget4Property(parent, "mapScale");
        IPropertyDescriptor pd = this.getPropertyDesriptor("evaluationTime");
        IPropertyDescriptor gpd = this.getPropertyDesriptor("evaluationGroup");
        this.getWidgetFactory().createCLabel(parent, pd.getDisplayName());
        this.widgets.put(pd.getId(), new SPEvaluationTime(parent, (AbstractSection)this, pd, gpd));
        this.createWidget4Property(parent, "imageType");
        this.createWidget4Property(parent, "onErrorType");
        this.createWidget4Property(parent, "resetMap");
        this.createWidget4Property(parent, "legend");
        this.createEditButton(parent);
    }

    protected void createEditButton(Composite parent) {
        Button mapPickSuggestion = new Button(parent, 0x800008);
        mapPickSuggestion.setText(Messages.MapSection_buttonText);
        mapPickSuggestion.setToolTipText(Messages.MapSection_buttonTooltip);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.horizontalAlignment = 0x1000000;
        mapPickSuggestion.setLayoutData((Object)gd);
        mapPickSuggestion.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MMap mmap = (MMap)MapSection.this.getElement();
                MapCredentials mapCredentials = GMapUtils.getMapCredentials((JasperReportsConfiguration)mmap.getJasperConfiguration());
                GMapCenterDialog d = new GMapCenterDialog(UIUtils.getShell(), mapCredentials){

                    protected void configureShell(Shell newShell) {
                        super.configureShell(newShell);
                        UIUtils.resizeAndCenterShell((Shell)newShell, (int)800, (int)600);
                    }
                };
                BasicMapInfoData mapInfo = mmap.getBasicMapInformation();
                if (mapInfo.getLatitude() != null && mapInfo.getLongitude() != null) {
                    d.setMapCenter(new LatLng(mapInfo.getLatitude(), mapInfo.getLongitude(), true));
                }
                if (mapInfo.getAddress() != null) {
                    d.setAddress(mapInfo.getAddress());
                }
                if (mapInfo.getMapType() != null) {
                    d.setMapType(MapType.fromStringID((String)mapInfo.getMapType().getName()));
                }
                if (mapInfo.getZoom() != 0) {
                    d.setZoomLevel(mapInfo.getZoom());
                }
                if (d.open() == 0) {
                    LatLng center = d.getMapPanel().getMapCenter();
                    MapSection.this.changeProperty("latitudeExpression", new JRDesignExpression(center.getLat() + "f"));
                    MapSection.this.changeProperty("longitudeExpression", new JRDesignExpression(center.getLng() + "f"));
                    MapSection.this.changeProperty("zoomExpression", new JRDesignExpression(String.valueOf(d.getMapPanel().getZoomLevel())));
                    String adr = d.getMapPanel().getAddress();
                    if (Misc.isNullOrEmpty((String)adr)) {
                        MapSection.this.changeProperty("addressExpression", null);
                    } else {
                        MapSection.this.changeProperty("addressExpression", new JRDesignExpression("\"" + adr + "\""));
                    }
                    MapSection.this.changeProperty("mapType", d.getMapPanel().getMapType().ordinal());
                }
            }
        });
    }

    protected void initializeProvidedProperties() {
        super.initializeProvidedProperties();
        this.addProvidedProperties("evaluationTime", Messages.MMap_evaluation_time);
        this.addProvidedProperties("latitudeExpression", Messages.MMap_latitude);
        this.addProvidedProperties("longitudeExpression", Messages.MMap_longitude);
        this.addProvidedProperties("addressExpression", Messages.MMap_0);
        this.addProvidedProperties("zoomExpression", Messages.MMap_zoom);
        this.addProvidedProperties("languageExpression", Messages.MMap_languageExpressionTitle);
        this.addProvidedProperties("mapType", Messages.MMap_mapTypeTitle);
        this.addProvidedProperties("mapScale", Messages.MMap_mapScaleTitle);
        this.addProvidedProperties("imageType", Messages.MMap_imageTypeTitle);
        this.addProvidedProperties("onErrorType", Messages.MMap_OnErrorType);
        this.addProvidedProperties("resetMap", Messages.MMap_ResetMap);
        this.addProvidedProperties("legend", Messages.MMap_Legend);
    }
}

