/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.map.property.desc;

import com.jaspersoft.studio.components.Activator;
import com.jaspersoft.studio.components.map.messages.Messages;
import com.jaspersoft.studio.model.util.ItemPropertyUtil;
import com.jaspersoft.studio.properties.view.validation.ValidationError;
import com.jaspersoft.studio.property.itemproperty.desc.ADescriptor;
import com.jaspersoft.studio.widgets.framework.IPropertyEditor;
import com.jaspersoft.studio.widgets.framework.PropertyEditorAdapter;
import com.jaspersoft.studio.widgets.framework.ui.ColorPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.ComboItemPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.DoublePropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.FloatPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.IntegerPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.ItemPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.TextPropertyDescription;
import java.util.Collection;
import java.util.List;
import net.sf.jasperreports.components.items.Item;
import net.sf.jasperreports.components.items.ItemData;
import net.sf.jasperreports.components.items.ItemProperty;
import net.sf.jasperreports.components.items.StandardItem;
import net.sf.jasperreports.components.items.StandardItemProperty;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRExpression;
import org.eclipse.swt.graphics.Image;

public class PathDescriptor
extends ADescriptor {
    private IPropertyEditor standardItemEditor = new PropertyEditorAdapter(){

        public JRExpression getPropertyValueExpression(String propertyName) {
            for (ItemProperty prop : PathDescriptor.this.item.getProperties()) {
                if (!prop.getName().equals(propertyName)) continue;
                StandardItemProperty stdProp = (StandardItemProperty)prop;
                return stdProp.getValueExpression();
            }
            return null;
        }

        public String getPropertyValue(String propertyName) {
            for (ItemProperty prop : PathDescriptor.this.item.getProperties()) {
                if (!prop.getName().equals(propertyName)) continue;
                StandardItemProperty stdProp = (StandardItemProperty)prop;
                return stdProp.getValue();
            }
            return null;
        }

        public void createUpdateProperty(String propertyName, String value, JRExpression valueExpression) {
            boolean found = false;
            for (ItemProperty prop : PathDescriptor.this.item.getProperties()) {
                if (!prop.getName().equals(propertyName)) continue;
                StandardItemProperty stdProp = (StandardItemProperty)prop;
                stdProp.setValue(value);
                stdProp.setValueExpression(valueExpression);
                found = true;
                break;
            }
            if (!found) {
                ((StandardItem)PathDescriptor.this.item).addItemProperty((ItemProperty)new StandardItemProperty(propertyName, value, valueExpression));
            }
        }

        public void removeProperty(String propertyName) {
            for (ItemProperty prop : PathDescriptor.this.item.getProperties()) {
                if (!prop.getName().equals(propertyName)) continue;
                ((StandardItem)PathDescriptor.this.item).removeItemProperty(prop);
                break;
            }
        }
    };

    public String getDisplayName() {
        return Messages.PathDescriptor_0;
    }

    public void setupDefaultValue(Item selected, StandardItemProperty newitem) {
        ItemProperty ip;
        if (selected != null && newitem.getName().equals("name") && (ip = ItemPropertyUtil.getProperty((List)selected.getProperties(), (String)"name")) != null && !Misc.isNullOrEmpty((String)ip.getValue())) {
            newitem.setValue(ip.getValue());
        }
    }

    public Image getIcon(Object element) {
        if (element instanceof Item) {
            return Activator.getDefault().getImage("icons/path-icon-16.png");
        }
        return super.getIcon(element);
    }

    protected void initItemPropertyDescriptors() {
        this.itemProperties = new ItemPropertyDescription[]{new TextPropertyDescription("name", Messages.PathDescriptor_1, Messages.PathDescriptor_2, false, (Object)"DEFAULT_PATH_NAME"), new DoublePropertyDescription("latitude", Messages.MarkerPage_LatitudeColumn, "", false, Double.valueOf(37.7833), -85.0, 85.0), new DoublePropertyDescription("longitude", Messages.MarkerPage_LongitudeColumn, "", false, Double.valueOf(-122.4167), -180.0, 180.0), new TextPropertyDescription("address", Messages.PathDescriptor_3, Messages.PathDescriptor_4, false), new TextPropertyDescription("style", Messages.PathDescriptor_5, Messages.PathDescriptor_6, false), new ColorPropertyDescription("strokeColor", Messages.PathDescriptor_7, Messages.PathDescriptor_8, false), new FloatPropertyDescription("strokeOpacity", Messages.PathDescriptor_9, Messages.PathDescriptor_10, false, new Float(0.0f), new Float(1.0f)), new IntegerPropertyDescription("strokeWeight", Messages.PathDescriptor_11, Messages.PathDescriptor_12, false, new Integer(1), null), new ColorPropertyDescription("fillColor", Messages.PathDescriptor_13, Messages.PathDescriptor_14, false), new FloatPropertyDescription("fillOpacity", Messages.PathDescriptor_15, Messages.PathDescriptor_16, false, new Float(0.0f), new Float(1.0f)), new ComboItemPropertyDescription("isPolygon", Messages.PathDescriptor_17, Messages.PathDescriptor_18, false, (Object)Boolean.FALSE, new String[]{"", "true", "false"}), new ComboItemPropertyDescription("clickable", Messages.PathDescriptor_19, Messages.PathDescriptor_20, false, (Object)Boolean.TRUE, new String[]{"", "true", "false"}), new ComboItemPropertyDescription("editable", Messages.PathDescriptor_21, Messages.PathDescriptor_22, false, (Object)Boolean.FALSE, new String[]{"", "true", "true"}), new ComboItemPropertyDescription("draggable", Messages.PathDescriptor_23, Messages.PathDescriptor_24, false, (Object)Boolean.FALSE, new String[]{"", "true", "false"}), new ComboItemPropertyDescription("geodesic", Messages.PathDescriptor_25, Messages.PathDescriptor_26, false, (Object)Boolean.FALSE, new String[]{"", "true", "false"}), new ComboItemPropertyDescription("visible", Messages.PathDescriptor_27, Messages.PathDescriptor_28, false, (Object)Boolean.FALSE, new String[]{"", "true", "false"}), new IntegerPropertyDescription("zIndex", Messages.PathDescriptor_29, Messages.PathDescriptor_30, false, new Integer(0), null)};
    }

    public void validateItem(ItemProperty itemProperty) throws ValidationError {
        super.validateItem(itemProperty);
        if (itemProperty == null) {
            for (ItemData id : this.itemDatas) {
                if (id.getItems() == null) continue;
                for (Item it : id.getItems()) {
                    if (Misc.isNullOrEmpty((Collection)it.getProperties())) {
                        throw new ValidationError("You must have Address or Latitude/Longitude");
                    }
                    boolean address = false;
                    boolean lon = false;
                    boolean lat = false;
                    if (ItemPropertyUtil.hasValue((List)it.getProperties(), (String)"latitude")) {
                        lat = true;
                    }
                    if (ItemPropertyUtil.hasValue((List)it.getProperties(), (String)"longitude")) {
                        lon = true;
                    }
                    if (ItemPropertyUtil.hasValue((List)it.getProperties(), (String)"address") || address || lon && lat) continue;
                    throw new ValidationError("You must have Address or Latitude/Longitude");
                }
            }
        }
    }

    public IPropertyEditor getPropertyEditor() {
        return this.standardItemEditor;
    }
}

