/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.table;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.components.table.ColumnCell;
import com.jaspersoft.studio.components.table.Guide;
import com.jaspersoft.studio.components.table.TableMatrix;
import com.jaspersoft.studio.components.table.model.MTable;
import com.jaspersoft.studio.components.table.model.column.MColumn;
import com.jaspersoft.studio.components.table.util.TableColumnSize;
import com.jaspersoft.studio.editor.layout.ILayout;
import com.jaspersoft.studio.editor.layout.LayoutCommand;
import com.jaspersoft.studio.editor.layout.LayoutManager;
import com.jaspersoft.studio.editor.layout.VerticalRowLayout;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.utils.ModelUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.Cell;
import net.sf.jasperreports.components.table.Column;
import net.sf.jasperreports.components.table.ColumnGroup;
import net.sf.jasperreports.components.table.ColumnVisitor;
import net.sf.jasperreports.components.table.DesignCell;
import net.sf.jasperreports.components.table.GroupCell;
import net.sf.jasperreports.components.table.StandardBaseColumn;
import net.sf.jasperreports.components.table.StandardColumn;
import net.sf.jasperreports.components.table.StandardColumnGroup;
import net.sf.jasperreports.components.table.StandardTable;
import net.sf.jasperreports.components.table.TableComponent;
import net.sf.jasperreports.components.table.util.TableUtil;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.eclipse.util.Pair;
import net.sf.jasperreports.engine.JRBoxContainer;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.design.JRDesignComponentElement;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;

public class TableManager {
    private StandardTable table;
    private TableUtil tableUtil;
    private TableMatrix mh = new TableMatrix();
    private JasperDesign jDesign;
    private Dimension size;
    protected ColumnCellSelector cellSelector = new ColumnCellSelector();

    public TableMatrix getMatrixHelper() {
        return this.mh;
    }

    public Rectangle getYhcolumn(int type, String grName, BaseColumn bc) {
        return this.mh.getYHColumn(bc, type, Misc.nvl((String)grName));
    }

    public TableManager(JRDesignComponentElement tbl, JasperDesign jasperDesign) {
        this((StandardTable)tbl.getComponent(), jasperDesign);
    }

    public TableManager(StandardTable table, JasperDesign jDesign) {
        this.table = table;
        this.jDesign = jDesign;
        this.tableUtil = new TableUtil((TableComponent)table, (JRReport)jDesign);
        this.initMaps();
        this.tableUtil.init((TableComponent)table);
        this.setSize();
    }

    public void initMaps() {
        this.mh = new TableMatrix();
        this.mh.fillMatrix(this.table, this.tableUtil);
    }

    public synchronized void refresh() {
        this.tableUtil.refresh();
        this.setSize();
    }

    public Dimension getSize() {
        return this.size;
    }

    public void setSize() {
        int xmin = 0;
        int xmax = 0;
        int ymin = 0;
        int ymax = 0;
        for (java.awt.Rectangle r : this.tableUtil.getCellBounds().values()) {
            if (xmin > r.x) {
                xmin = r.x;
            }
            if (xmax < r.x + r.width) {
                xmax = r.x + r.width;
            }
            if (ymin > r.y) {
                ymin = r.y;
            }
            if (ymax >= r.y + r.height) continue;
            ymax = r.y + r.height;
        }
        this.size = new Dimension(xmax - xmin, ymax - ymin);
    }

    public Cell getCell(Point location) {
        Map cellBounds = this.tableUtil.getCellBounds();
        for (Cell cell : cellBounds.keySet()) {
            Rectangle r = TableManager.getAWT2SWTRectangle((java.awt.Rectangle)cellBounds.get(cell));
            if (r.x > location.x || r.x + r.width < location.x || r.y > location.y || r.y + r.height < location.y) continue;
            return cell;
        }
        return null;
    }

    public Rectangle getCellBounds(Cell cell) {
        return TableManager.getAWT2SWTRectangle((java.awt.Rectangle)this.tableUtil.getCellBounds().get(cell));
    }

    public static Rectangle getAWT2SWTRectangle(java.awt.Rectangle rect) {
        if (rect != null) {
            return new Rectangle(rect.x, rect.y, rect.width, rect.height);
        }
        return null;
    }

    public static List<BaseColumn> getAllColumns(MTable mTable) {
        JRDesignComponentElement tbl = (JRDesignComponentElement)mTable.getValue();
        if (tbl.getComponent() instanceof StandardTable) {
            StandardTable table = (StandardTable)tbl.getComponent();
            return TableUtil.getAllColumns((List)table.getColumns());
        }
        return new ArrayList<BaseColumn>(0);
    }

    public static List<Cell> getAllCells(List<BaseColumn> columns) {
        ArrayList<Cell> result = new ArrayList<Cell>();
        for (BaseColumn column : columns) {
            StandardColumn standardCol;
            if (column.getTableFooter() != null) {
                result.add(column.getTableFooter());
            }
            if (column.getTableHeader() != null) {
                result.add(column.getTableHeader());
            }
            if (column.getColumnFooter() != null) {
                result.add(column.getColumnFooter());
            }
            if (column.getColumnHeader() != null) {
                result.add(column.getColumnHeader());
            }
            for (GroupCell groupHeader : column.getGroupHeaders()) {
                if (groupHeader.getCell() == null) continue;
                result.add(groupHeader.getCell());
            }
            for (GroupCell groupFooter : column.getGroupFooters()) {
                if (groupFooter.getCell() == null) continue;
                result.add(groupFooter.getCell());
            }
            if (column instanceof StandardColumnGroup) {
                StandardColumnGroup groupColumn = (StandardColumnGroup)column;
                result.addAll(TableManager.getAllCells(groupColumn.getColumns()));
                continue;
            }
            if (!(column instanceof StandardColumn) || (standardCol = (StandardColumn)column).getDetailCell() == null) continue;
            result.add(standardCol.getDetailCell());
        }
        return result;
    }

    public Rectangle getBounds(StandardBaseColumn col, int type, String grName) {
        Rectangle p = this.mh.getYHColumn((BaseColumn)col, type, grName);
        if (p == null) {
            p = new Rectangle(0, 100, col.getWidth().intValue(), 0);
        }
        return p;
    }

    public Rectangle getBounds(int width, Cell cell, StandardBaseColumn col) {
        Rectangle b = TableManager.getAWT2SWTRectangle((java.awt.Rectangle)this.tableUtil.getCellBounds().get(cell));
        if (b != null) {
            return b;
        }
        int w = col != null ? col.getWidth() : 0;
        int h = cell != null ? cell.getHeight() : 0;
        return new Rectangle(0, 0, w, h);
    }

    protected void setWidth(StandardBaseColumn cell, int width) {
        if (width >= 0) {
            int delta = width - cell.getWidth();
            if (cell instanceof StandardBaseColumn) {
                this.setGroupHeaderWidth(this.table.getColumns(), cell, delta);
            }
            if (cell instanceof StandardColumnGroup) {
                this.setColumnGroupWidth((StandardColumnGroup)cell, delta);
            }
            cell.setWidth(Integer.valueOf(width));
        }
    }

    protected void setProportionalWidth(StandardBaseColumn column, int width, HashSet<BaseColumn> fixedColumns) {
        if (width >= 0) {
            int delta = width - column.getWidth();
            if (column instanceof StandardBaseColumn) {
                this.setGroupHeaderWidth(this.table.getColumns(), column, delta);
            }
            if (column instanceof StandardColumnGroup) {
                this.setProportionalColumnGroupWidth((StandardColumnGroup)column, width, fixedColumns);
            }
            column.setWidth(Integer.valueOf(width));
        }
    }

    private int[] getColumnsProportionalWidth(List<BaseColumn> columns, int newWidth, HashSet<BaseColumn> fixedColumns) {
        int[] proportionalWidths = new int[columns.size()];
        int index = 0;
        int currentColumnsWidth = 0;
        for (BaseColumn col : columns) {
            currentColumnsWidth += col.getWidth().intValue();
        }
        HashSet<BaseColumn> acceptableFixedColumns = new HashSet<BaseColumn>();
        int currentFixedWidth = 0;
        for (BaseColumn col : columns) {
            if (!fixedColumns.contains(col)) continue;
            if (currentFixedWidth + col.getWidth() > newWidth) break;
            currentFixedWidth += col.getWidth().intValue();
            acceptableFixedColumns.add(col);
        }
        boolean allExcluded = true;
        for (BaseColumn col : columns) {
            if (acceptableFixedColumns.contains(col)) continue;
            allExcluded = false;
            break;
        }
        if (allExcluded) {
            acceptableFixedColumns.remove(columns.get(columns.size() - 1));
        }
        int columnsTotalWidth = 0;
        int dinamycWidth = newWidth - currentFixedWidth;
        for (BaseColumn col : columns) {
            if (acceptableFixedColumns.contains(col)) {
                proportionalWidths[index] = col.getWidth();
                columnsTotalWidth += col.getWidth().intValue();
            } else {
                int proportionalWidth;
                float proportionalFactor = (float)col.getWidth().intValue() / (float)currentColumnsWidth;
                proportionalWidths[index] = proportionalWidth = (int)(proportionalFactor * (float)dinamycWidth);
                columnsTotalWidth += proportionalWidth;
            }
            ++index;
        }
        int remains = newWidth - columnsTotalWidth;
        index = 0;
        while (remains > 0 && proportionalWidths.length > 0) {
            BaseColumn currentColumn = columns.get(index);
            if (!acceptableFixedColumns.contains(currentColumn)) {
                int n = index;
                proportionalWidths[n] = proportionalWidths[n] + 1;
                --remains;
            }
            if (++index != proportionalWidths.length) continue;
            index = 0;
        }
        return proportionalWidths;
    }

    public boolean fillSpace(int newWidth, boolean isProportional, HashSet<BaseColumn> fixedColumns) {
        return this.fillSpace(newWidth, isProportional, fixedColumns, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fillSpace(int newWidth, boolean isProportional, HashSet<BaseColumn> fixedColumns, boolean force) {
        StandardTable standardTable = this.table;
        synchronized (standardTable) {
            block14: {
                int currentColumnsWidth = 0;
                if (!force) {
                    for (BaseColumn col : this.table.getColumns()) {
                        currentColumnsWidth += col.getWidth().intValue();
                    }
                }
                if (currentColumnsWidth != newWidth || force) break block14;
                return false;
            }
            if (isProportional) {
                int[] proportionalWidths = this.getColumnsProportionalWidth(this.table.getColumns(), newWidth, fixedColumns);
                int index = 0;
                VerticalRowLayout defaultLayout = new VerticalRowLayout();
                for (BaseColumn col : this.table.getColumns()) {
                    if (col.getWidth() != proportionalWidths[index]) {
                        this.setProportionalWidth((StandardBaseColumn)col, proportionalWidths[index], fixedColumns);
                        for (Map.Entry<Cell, Integer> cell : this.getColumnCell(col).entrySet()) {
                            ILayout layout = LayoutManager.getLayout((JRPropertiesHolder[])new JRPropertiesHolder[]{(JRPropertiesHolder)cell.getKey()}, null, null, (ILayout)defaultLayout);
                            Dimension baseSize = new Dimension(cell.getValue().intValue(), ((DesignCell)cell.getKey()).getHeight().intValue());
                            Dimension paddedSize = LayoutManager.getPaddedSize((JRBoxContainer)((JRBoxContainer)cell.getKey()), (Dimension)baseSize);
                            layout.layout(this.jDesign, (JRElementGroup)cell.getKey(), cell.getKey().getElements(), paddedSize);
                        }
                    }
                    ++index;
                }
            } else {
                int columnsSize = newWidth / this.table.getColumns().size();
                int extraSpace = newWidth % this.table.getColumns().size();
                VerticalRowLayout defaultLayout = new VerticalRowLayout();
                for (BaseColumn col : this.table.getColumns()) {
                    int newColumnWidth;
                    int additionalSpace = 0;
                    if (extraSpace > 0) {
                        additionalSpace = 1;
                        --extraSpace;
                    }
                    if ((newColumnWidth = col.getWidth() + additionalSpace + columnsSize) == col.getWidth()) continue;
                    this.setWidth((StandardBaseColumn)col, newColumnWidth);
                    for (Map.Entry<Cell, Integer> cell : this.getColumnCell(col).entrySet()) {
                        ILayout layout = LayoutManager.getLayout((JRPropertiesHolder[])new JRPropertiesHolder[]{(JRPropertiesHolder)cell.getKey()}, null, null, (ILayout)defaultLayout);
                        layout.layout(this.jDesign, (JRElementGroup)cell.getKey(), cell.getKey().getElements(), new Dimension(cell.getValue().intValue(), ((DesignCell)cell.getKey()).getHeight().intValue()));
                    }
                }
            }
        }
        return true;
    }

    private HashMap<Cell, Integer> getColumnCell(BaseColumn cell) {
        StandardBaseColumn col;
        HashMap<Cell, Integer> result = new HashMap<Cell, Integer>();
        if (cell instanceof StandardBaseColumn) {
            col = (StandardBaseColumn)cell;
            if (col.getColumnHeader() != null) {
                result.put(col.getColumnHeader(), col.getWidth());
            }
            if (col.getTableHeader() != null) {
                result.put(col.getTableHeader(), col.getWidth());
            }
            if (col.getTableFooter() != null) {
                result.put(col.getTableFooter(), col.getWidth());
            }
            if (col.getColumnFooter() != null) {
                result.put(cell.getColumnFooter(), col.getWidth());
            }
        }
        if (cell instanceof StandardColumn) {
            col = (StandardColumn)cell;
            if (col.getDetailCell() != null) {
                result.put(col.getDetailCell(), col.getWidth());
            }
        } else if (cell instanceof StandardColumnGroup) {
            StandardColumnGroup group = (StandardColumnGroup)cell;
            List columns = group.getColumns();
            for (BaseColumn groupCol : columns) {
                result.putAll(this.getColumnCell(groupCol));
            }
        }
        return result;
    }

    public JSSCompoundCommand getLayoutCommand() {
        VerticalRowLayout defaultLayout = new VerticalRowLayout();
        JSSCompoundCommand layoutCommands = new JSSCompoundCommand(null);
        for (BaseColumn col : this.table.getColumns()) {
            for (Map.Entry<Cell, Integer> cell : this.getColumnCell(col).entrySet()) {
                ILayout layout = LayoutManager.getLayout((JRPropertiesHolder[])new JRPropertiesHolder[]{(JRPropertiesHolder)cell.getKey()}, null, null, (ILayout)defaultLayout);
                Dimension size = new Dimension(cell.getValue().intValue(), ((DesignCell)cell.getKey()).getHeight().intValue());
                size = LayoutManager.getPaddedSize((JRBoxContainer)((JRBoxContainer)cell.getKey()), (Dimension)size);
                LayoutCommand layoutCommand = new LayoutCommand(this.jDesign, (JRElementGroup)cell.getKey(), layout, size);
                layoutCommands.add((Command)layoutCommand);
            }
        }
        return layoutCommands;
    }

    private boolean setColumnGroupWidth(StandardColumnGroup cell, int delta) {
        List columns = cell.getColumns();
        ListIterator it = columns.listIterator(columns.size());
        while (it.hasPrevious()) {
            StandardBaseColumn bc = (StandardBaseColumn)it.previous();
            boolean c = false;
            if (delta < 0 && Math.abs(delta) > bc.getWidth()) {
                delta += bc.getWidth().intValue();
                bc.setWidth(Integer.valueOf(0));
                c = true;
            } else {
                bc.setWidth(Integer.valueOf(bc.getWidth() + delta));
            }
            if (bc instanceof StandardColumnGroup) {
                this.setColumnGroupWidth((StandardColumnGroup)bc, delta);
            }
            if (c) continue;
            return true;
        }
        return false;
    }

    private void setProportionalColumnGroupWidth(StandardColumnGroup columnGroup, int width, HashSet<BaseColumn> fixedColumns) {
        List columns = columnGroup.getColumns();
        int[] proportionalNewWidth = this.getColumnsProportionalWidth(columns, width, fixedColumns);
        int index = 0;
        for (BaseColumn col : columns) {
            StandardBaseColumn bc = (StandardBaseColumn)col;
            bc.setWidth(Integer.valueOf(proportionalNewWidth[index]));
            if (bc instanceof StandardColumnGroup) {
                this.setProportionalColumnGroupWidth((StandardColumnGroup)bc, proportionalNewWidth[index], fixedColumns);
            }
            ++index;
        }
    }

    private boolean setGroupHeaderWidth(List<BaseColumn> col, StandardBaseColumn cell, int delta) {
        for (BaseColumn bc : col) {
            StandardColumnGroup scg;
            boolean b;
            if (bc instanceof StandardColumnGroup && (b = this.setGroupHeaderWidth((scg = (StandardColumnGroup)bc).getColumns(), cell, delta))) {
                scg.setWidth(Integer.valueOf(scg.getWidth() + delta));
                return true;
            }
            if (cell != bc) continue;
            return true;
        }
        return false;
    }

    public void setHeight(DesignCell cell, int height, BaseColumn col, int type, String grName) {
        if (height >= 0) {
            int delta = 0;
            delta = cell == null ? height - this.getYhcolumn((int)type, (String)grName, (BaseColumn)col).height : height - cell.getHeight();
            if (delta != 0) {
                this.setRowHeight(this.table.getColumns(), delta, type, grName, col);
            }
        }
    }

    private int setRowHeight(List<BaseColumn> columns, int delta, int type, String grName, BaseColumn col) {
        int dif = 0;
        for (BaseColumn bc : columns) {
            if (bc instanceof StandardColumn) {
                dif = TableColumnSize.setCellHeightDelta(bc, type, grName, delta);
                continue;
            }
            if (!(bc instanceof StandardColumnGroup)) continue;
            if (col == bc) {
                TableColumnSize.setCellHeightDelta(bc, type, grName, delta);
                continue;
            }
            dif = this.setRowHeight(((StandardColumnGroup)bc).getColumns(), delta, type, grName, col);
            if (delta >= 0 || dif == 0) continue;
            dif = TableColumnSize.setCellHeightDelta(bc, type, grName, dif);
        }
        return dif;
    }

    public void setRowsHeight(List<Integer> d) {
        int i = 0;
        List groupsList = TableUtil.getGroupList((TableComponent)this.table, (JRReport)this.jDesign);
        this.setRowHeight(this.table.getColumns(), 0, "", d.get(i++));
        this.setRowHeight(this.table.getColumns(), 2, "", d.get(i++));
        this.setRowHeight(this.table.getColumns(), 4, "", d.get(i++));
        this.setRowHeight(this.table.getColumns(), 3, "", d.get(i++));
        this.setRowHeight(this.table.getColumns(), 1, "", d.get(i++));
        if (groupsList != null) {
            for (JRDesignGroup jrGroup : groupsList) {
                this.setRowHeight(this.table.getColumns(), 5, jrGroup.getName(), d.get(i++));
                this.setRowHeight(this.table.getColumns(), 6, jrGroup.getName(), d.get(i++));
            }
        }
    }

    public void setRowHeight(List<BaseColumn> cols, int type, String grName, int h) {
        for (BaseColumn bc : cols) {
            ColumnCell cc = this.mh.getColumnCell(new ColumnCell(type, grName, bc));
            Guide g = this.mh.getRowGuide(cc);
            List<ColumnCell> cells = TableManager.isBottomOfTable(type) ? g.getPrev() : g.getNext();
            Iterator<ColumnCell> iterator = cells.iterator();
            if (!iterator.hasNext()) continue;
            ColumnCell c = iterator.next();
            this.setRowHeight(cols, h, type, grName, c.column);
            return;
        }
    }

    public void setColumnHeight(BaseColumn bc, List<Integer> deltas) {
        int i = 0;
        this.setCellHeight(bc, 0, "", deltas.get(i++));
        this.setCellHeight(bc, 2, "", deltas.get(i++));
        this.setCellHeight(bc, 4, "", deltas.get(i++));
        this.setCellHeight(bc, 3, "", deltas.get(i++));
        this.setCellHeight(bc, 1, "", deltas.get(i++));
        List groupsList = TableUtil.getGroupList((TableComponent)this.table, (JRReport)this.jDesign);
        if (groupsList != null) {
            for (JRDesignGroup jrGroup : groupsList) {
                this.setCellHeight(bc, 5, jrGroup.getName(), deltas.get(i++));
                this.setCellHeight(bc, 6, jrGroup.getName(), deltas.get(i++));
            }
        }
    }

    public void setCellHeight(BaseColumn bc, int type, String grName, int delta) {
        DesignCell c = (DesignCell)TableUtil.getCell((BaseColumn)bc, (int)type, (String)grName);
        if (c != null) {
            c.setHeight(Integer.valueOf(c.getHeight() + delta));
        }
    }

    public static StandardTable getTable(ANode destNode) {
        JRDesignComponentElement tbl;
        if (destNode instanceof MTable) {
            return ((MTable)((Object)destNode)).getStandardTable();
        }
        if (destNode instanceof MColumn) {
            destNode = ((MColumn)((Object)destNode)).getMTable();
        }
        if (destNode.getValue() instanceof JRDesignComponentElement && (tbl = (JRDesignComponentElement)destNode.getValue()).getComponent() instanceof StandardTable) {
            return (StandardTable)tbl.getComponent();
        }
        return null;
    }

    public static MTable getTableNode(ANode currentNode) {
        if (currentNode == null) {
            return null;
        }
        if (currentNode instanceof MTable) {
            return (MTable)currentNode;
        }
        return TableManager.getTableNode(currentNode.getParent());
    }

    public Dimension getCellPackSize(ColumnCell cc) {
        Dimension result = new Dimension(0, 0);
        if ((cc = this.mh.getColumnCell(cc)) != null) {
            Guide g = cc.getEast();
            int w = -g.getY();
            for (ColumnCell c : g.getPrev()) {
                List cells;
                Cell cell = TableUtil.getCell((BaseColumn)c.column, (int)c.type, (String)c.grName);
                if (cell == null || (cells = cell.getChildren()).isEmpty()) continue;
                int width = ModelUtils.getContainerSize((List)cells, (Dimension)new Dimension((int)0, (int)0)).width;
                w = Math.max(w, width - c.column.getWidth());
            }
            g = cc.getSouth();
            int h = -g.getY();
            for (ColumnCell c : g.getPrev()) {
                List cells;
                Cell cell = TableUtil.getCell((BaseColumn)c.column, (int)c.type, (String)c.grName);
                if (cell == null || (cells = cell.getChildren()).isEmpty()) continue;
                int height = ModelUtils.getContainerSize((List)cells, (Dimension)new Dimension((int)0, (int)0)).height;
                h = Math.max(h, height - cell.getHeight());
            }
            Rectangle b = cc.getBounds();
            result.setWidth(b.width + w);
            result.setHeight(b.height + h);
        }
        return result;
    }

    public void update() {
        this.initMaps();
        this.refresh();
    }

    public int getRowHeight(MColumn col) {
        return 100;
    }

    public int getRowHeight(ColumnCell ccel) {
        return this.mh.getRowHeight(this.mh.getColumnCell(ccel));
    }

    public static boolean isBottomOfTable(int type) {
        return type == 3 || type == 1 || type == 6;
    }

    public HashMap<Cell, Integer> getTableHeaderSpans() {
        return this.verifyColumnHeights(this.table.getColumns(), ColumnCellSelector.TYPE.TABLE_HEADER);
    }

    public HashMap<Cell, Integer> getTableFooterSpans() {
        return this.verifyColumnHeights(this.table.getColumns(), ColumnCellSelector.TYPE.TABLE_FOOTER);
    }

    public HashMap<Cell, Integer> getColumnFooterSpans() {
        return this.verifyColumnHeights(this.table.getColumns(), ColumnCellSelector.TYPE.COLUMN_FOOTER);
    }

    public HashMap<Cell, Integer> getColumnHeaderSpans() {
        return this.verifyColumnHeights(this.table.getColumns(), ColumnCellSelector.TYPE.COLUMN_HEADER);
    }

    public HashMap<Cell, Integer> getGroupHeaderSpans(String groupName) {
        return this.verifyColumnHeights(this.table.getColumns(), ColumnCellSelector.TYPE.GROUP_HEADER, groupName);
    }

    public HashMap<Cell, Integer> getGroupFooterSpans(String groupName) {
        return this.verifyColumnHeights(this.table.getColumns(), ColumnCellSelector.TYPE.GROUP_FOOTER, groupName);
    }

    public HashMap<Cell, Integer> getTableSpans() {
        JRGroup[] groups;
        JRDesignDataset tableDataset;
        HashMap<Cell, Integer> result = new HashMap<Cell, Integer>();
        result.putAll(this.getTableHeaderSpans());
        result.putAll(this.getTableFooterSpans());
        result.putAll(this.getColumnHeaderSpans());
        result.putAll(this.getColumnFooterSpans());
        JRDatasetRun datasetRun = this.table.getDatasetRun();
        if (datasetRun != null && (tableDataset = (JRDesignDataset)this.jDesign.getDatasetMap().get(datasetRun.getDatasetName())) != null && (groups = tableDataset.getGroups()) != null) {
            int i = 0;
            while (i < groups.length) {
                String groupName = groups[i].getName();
                result.putAll(this.getGroupHeaderSpans(groupName));
                result.putAll(this.getGroupFooterSpans(groupName));
                ++i;
            }
        }
        return result;
    }

    public void updateTableSpans() {
        HashMap<Cell, Integer> spans = this.getTableSpans();
        if (spans != null) {
            for (Map.Entry<Cell, Integer> value : spans.entrySet()) {
                if (value.getKey().getRowSpan() == value.getValue()) continue;
                ((DesignCell)value.getKey()).setRowSpan(value.getValue());
            }
        }
    }

    protected HashMap<Cell, Integer> verifyColumnHeights(List<BaseColumn> columns, ColumnCellSelector.TYPE type) {
        return this.verifyColumnHeights(columns, type, null);
    }

    protected HashMap<Cell, Integer> verifyColumnHeights(List<BaseColumn> columns, final ColumnCellSelector.TYPE type, final String groupName) {
        final ArrayList tableCellRows = new ArrayList();
        HashMap<Cell, Integer> result = new HashMap<Cell, Integer>();
        ColumnVisitor<Void> cellCollector = new ColumnVisitor<Void>(){
            int rowIdx = 0;

            protected List<Pair<Cell, Boolean>> getRow() {
                int currentRowCount = tableCellRows.size();
                if (this.rowIdx >= currentRowCount) {
                    int i = currentRowCount;
                    while (i <= this.rowIdx) {
                        tableCellRows.add(new ArrayList());
                        ++i;
                    }
                }
                return (List)tableCellRows.get(this.rowIdx);
            }

            public Void visitColumn(Column column) {
                Cell cell = TableManager.this.cellSelector.getCell(column, type, groupName);
                if (cell != null) {
                    this.getRow().add((Pair<Cell, Boolean>)new Pair((Object)cell, (Object)false));
                }
                return null;
            }

            public Void visitColumnGroup(ColumnGroup columnGroup) {
                Cell cell = TableManager.this.cellSelector.getCell(columnGroup, type, groupName);
                if (cell != null) {
                    this.getRow().add((Pair<Cell, Boolean>)new Pair((Object)cell, (Object)true));
                    ++this.rowIdx;
                    for (BaseColumn subcolumn : columnGroup.getColumns()) {
                        subcolumn.visitColumn((ColumnVisitor)this);
                    }
                    --this.rowIdx;
                } else {
                    for (BaseColumn subcolumn : columnGroup.getColumns()) {
                        subcolumn.visitColumn((ColumnVisitor)this);
                    }
                }
                return null;
            }
        };
        try {
            for (BaseColumn column : columns) {
                column.visitColumn((ColumnVisitor)cellCollector);
            }
            int rowIdx = 0;
            while (rowIdx < tableCellRows.size()) {
                List rowCells = (List)tableCellRows.get(rowIdx);
                for (Pair rowCell : rowCells) {
                    int span = (Boolean)rowCell.getValue() != false ? 1 : Math.max(0, tableCellRows.size() - rowIdx);
                    result.put((Cell)rowCell.getKey(), span);
                }
                ++rowIdx;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JaspersoftStudioPlugin.getInstance().logError("Error while computing table spans", (Throwable)ex);
            result.clear();
        }
        return result;
    }

    public static StandardColumnGroup getParent(StandardTable table, BaseColumn child) {
        for (BaseColumn tableChild : table.getColumns()) {
            if (tableChild != child) continue;
            return null;
        }
        for (BaseColumn tableChild : table.getColumns()) {
            StandardColumnGroup searchInGroup;
            if (!(tableChild instanceof StandardColumnGroup) || (searchInGroup = TableManager.getParent(child, (StandardColumnGroup)tableChild)) == null) continue;
            return searchInGroup;
        }
        return null;
    }

    private static StandardColumnGroup getParent(BaseColumn child, StandardColumnGroup currentGroup) {
        for (BaseColumn groupChild : currentGroup.getColumns()) {
            if (groupChild != child) continue;
            return currentGroup;
        }
        for (BaseColumn groupChild : currentGroup.getColumns()) {
            StandardColumnGroup searchInGroup;
            if (!(groupChild instanceof StandardColumnGroup) || (searchInGroup = TableManager.getParent(child, (StandardColumnGroup)groupChild)) == null) continue;
            return searchInGroup;
        }
        return null;
    }

    public static class ColumnCellSelector {
        public Cell getCell(Column column, TYPE type, String groupName) {
            return this.getCell((BaseColumn)column, type, groupName);
        }

        public Cell getCell(ColumnGroup group, TYPE type, String groupName) {
            return this.getCell((BaseColumn)group, type, groupName);
        }

        protected Cell getCell(BaseColumn column, TYPE type, String groupName) {
            if (type == TYPE.TABLE_HEADER) {
                return column.getTableHeader();
            }
            if (type == TYPE.TABLE_FOOTER) {
                return column.getTableFooter();
            }
            if (type == TYPE.COLUMN_FOOTER) {
                return column.getColumnFooter();
            }
            if (type == TYPE.COLUMN_HEADER) {
                return column.getColumnHeader();
            }
            if (type == TYPE.GROUP_FOOTER) {
                return column.getGroupFooter(groupName);
            }
            if (type == TYPE.GROUP_HEADER) {
                return column.getGroupHeader(groupName);
            }
            return null;
        }

        public static enum TYPE {
            TABLE_HEADER,
            TABLE_FOOTER,
            COLUMN_HEADER,
            COLUMN_FOOTER,
            GROUP_HEADER,
            GROUP_FOOTER;

        }
    }
}

