/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.table.action;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.components.Activator;
import com.jaspersoft.studio.components.table.messages.Messages;
import com.jaspersoft.studio.components.table.model.MTable;
import com.jaspersoft.studio.components.table.model.dialog.ApplyTableStyleAction;
import com.jaspersoft.studio.components.table.model.dialog.TableStyle;
import com.jaspersoft.studio.components.table.model.table.command.UpdateStyleCommand;
import com.jaspersoft.studio.components.table.model.table.command.wizard.TableStyleWizard;
import com.jaspersoft.studio.editor.action.ACachedSelectionAction;
import com.jaspersoft.studio.model.ANode;
import java.util.List;
import net.sf.jasperreports.components.table.StandardTable;
import net.sf.jasperreports.eclipse.ui.util.ExtendedMessageDialog;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;

public class EditTableStyleAction
extends ACachedSelectionAction {
    public static final String ID = "com.jaspersoft.studio.components.table.action.EditStyle";

    public EditTableStyleAction(IWorkbenchPart part) {
        super(part);
        this.setText(Messages.EditStyleAction_actionName);
        this.setId(ID);
        this.setImageDescriptor(Activator.getDefault().getImageDescriptor("icons/table-style-16.png"));
    }

    protected boolean calculateEnabled() {
        List tables = this.editor.getSelectionCache().getSelectionModelForType(MTable.class);
        return tables.size() == 1;
    }

    public void run() {
        TableStyleWizard wizard = new TableStyleWizard();
        WizardDialog dialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard){

            protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
                Button button = super.createButton(parent, id, label, defaultButton);
                if (id == 16) {
                    button.setText(Messages.EditStyleAction_okButton);
                }
                return button;
            }
        };
        if (dialog.open() == 0) {
            List tables = this.editor.getSelectionCache().getSelectionModelForType(MTable.class);
            MTable tableModel = (MTable)((Object)tables.get(0));
            if (this.hasStyles(tableModel)) {
                int response = this.getResponse();
                if (response == 0 || response == 1) {
                    TableStyle selectedStyle = wizard.getTableStyle();
                    this.execute(this.changeStyleCommand(tableModel, selectedStyle, response == 0));
                }
            } else {
                TableStyle selectedStyle = wizard.getTableStyle();
                this.execute(this.changeStyleCommand(tableModel, selectedStyle, false));
            }
        }
    }

    protected int getResponse() {
        IPreferenceStore store = JaspersoftStudioPlugin.getInstance().getPreferenceStore();
        String styleBehavior = store.getString("tableCrosstabChangeStyle");
        if (styleBehavior.equals("updateStyles")) {
            return 0;
        }
        if (styleBehavior.equals("createStyles")) {
            return 1;
        }
        Shell shell = UIUtils.getShell();
        ExtendedMessageDialog question = new ExtendedMessageDialog(shell, Messages.EditStyleAction_dialogTitle, null, Messages.EditStyleAction_dialogText, 3, new String[]{Messages.EditStyleAction_dialogUpdateButton, Messages.EditStyleAction_dialogNewButton, Messages.EditStyleAction_dialogCancelButton}, 0, Messages.EditTableStyleAction_rememberDecision);
        int response = question.open();
        if (question.getCheckboxResult()) {
            if (response == 0) {
                store.setValue("tableCrosstabChangeStyle", "updateStyles");
            } else if (response == 1) {
                store.setValue("tableCrosstabChangeStyle", "createStyles");
            }
        }
        return response;
    }

    private boolean hasStyles(MTable tableModel) {
        StandardTable table = tableModel.getStandardTable();
        JRPropertiesMap tableMap = tableModel.getValue().getPropertiesMap();
        JasperDesign jd = tableModel.getJasperDesign();
        JRDesignStyle[] currentStyles = ApplyTableStyleAction.getStylesFromTable(table, tableMap, jd);
        int i = 0;
        while (i < currentStyles.length) {
            if (currentStyles[i] != null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected Command changeStyleCommand(MTable table, TableStyle newStyle, boolean updateOldStyles) {
        JSSCompoundCommand command = new JSSCompoundCommand((ANode)table);
        command.setDebugLabel(this.getText());
        UpdateStyleCommand updateCommand = new UpdateStyleCommand(table, newStyle, updateOldStyles);
        command.add((Command)updateCommand);
        return command;
    }
}

