/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.table.model.cell.command;

import com.jaspersoft.studio.components.table.model.column.MCell;
import com.jaspersoft.studio.editor.layout.ILayout;
import com.jaspersoft.studio.editor.layout.LayoutCommand;
import com.jaspersoft.studio.editor.layout.LayoutManager;
import com.jaspersoft.studio.editor.layout.VerticalRowLayout;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.utils.SelectionHelper;
import java.util.List;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.Cell;
import net.sf.jasperreports.components.table.ColumnGroup;
import net.sf.jasperreports.components.table.DesignCell;
import net.sf.jasperreports.components.table.GroupCell;
import net.sf.jasperreports.components.table.StandardBaseColumn;
import net.sf.jasperreports.components.table.StandardTable;
import net.sf.jasperreports.engine.JRBoxContainer;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;

public class CreateElementCommand
extends Command {
    protected MGraphicElement srcNode;
    protected JRDesignElement jrElement;
    private StandardBaseColumn jrColumn;
    private StandardTable sTable;
    private JasperDesign jDesign;
    private DesignCell jrCell;
    private Rectangle location;
    protected int index = -1;
    private JRPropertiesHolder[] pholder;
    private LayoutCommand lCmd;
    private boolean firstTime = true;

    public CreateElementCommand(MCell destNode, MGraphicElement srcNode, Rectangle position, int index) {
        if (srcNode != null) {
            this.jrElement = srcNode.getValue();
        }
        this.jrCell = destNode.getCell();
        this.index = index;
        this.location = position;
        this.srcNode = srcNode;
        this.sTable = destNode.getTable().getStandardTable();
        this.jrColumn = destNode.getValue();
        this.jDesign = destNode.getJasperDesign();
        this.pholder = destNode.getPropertyHolder();
    }

    protected void createObject() {
        if (this.jrElement == null) {
            this.jrElement = this.srcNode.createJRElement(this.srcNode.getJasperDesign());
        }
        if (this.jrElement != null) {
            if (this.location == null) {
                this.location = new Rectangle(0, 0, Math.min(this.srcNode.getDefaultWidth(), this.jrColumn.getWidth()), Math.min(this.srcNode.getDefaultHeight(), this.jrCell.getHeight()));
            }
            if (this.location.width < 0) {
                this.location.width = this.srcNode.getDefaultWidth();
            }
            if (this.location.height < 0) {
                this.location.height = this.srcNode.getDefaultHeight();
            }
        }
        this.jrElement.setX(this.location.x);
        this.jrElement.setY(this.location.y);
        this.jrElement.setWidth(this.location.width);
        this.jrElement.setHeight(this.location.height);
    }

    public void execute() {
        this.createObject();
        if (this.jrElement != null) {
            this.removeElements(this.jrElement);
            if (this.index >= 0 && this.index <= this.jrCell.getChildren().size()) {
                this.jrCell.addElement(this.index, this.jrElement);
            } else {
                this.jrCell.addElement(this.jrElement);
            }
        }
        if (this.firstTime) {
            SelectionHelper.setSelection((JRChild)this.jrElement, (boolean)false);
            this.firstTime = false;
        }
        Dimension d = new Dimension(this.jrColumn.getWidth().intValue(), this.jrCell.getHeight().intValue());
        d = LayoutManager.getPaddedSize((JRBoxContainer)this.jrCell, (Dimension)d);
        if (this.lCmd == null) {
            ILayout layout = LayoutManager.getLayout((JRPropertiesHolder[])this.pholder, (JasperDesign)this.jDesign, null, (ILayout)new VerticalRowLayout());
            this.lCmd = new LayoutCommand(this.jDesign, (JRElementGroup)this.jrCell, layout, d);
        }
        this.lCmd.execute();
    }

    public boolean canUndo() {
        return this.jrCell != null && this.jrElement != null;
    }

    public void undo() {
        this.lCmd.undo();
        this.jrCell.removeElement(this.jrElement);
    }

    private void removeElements(JRDesignElement element) {
        com.jaspersoft.studio.model.command.CreateElementCommand.removeElement((JasperDesign)this.jDesign, (JRDesignElement)this.jrElement);
        this.removeElementFromColumn(this.sTable.getColumns());
    }

    public void removeElementFromColumn(List<BaseColumn> cols) {
        for (BaseColumn bc : cols) {
            Cell cell = bc.getTableHeader();
            if (cell != null) {
                com.jaspersoft.studio.model.command.CreateElementCommand.removeElement((JRDesignElement)this.jrElement, (JRElement[])cell.getElements());
            }
            if ((cell = bc.getTableFooter()) != null) {
                com.jaspersoft.studio.model.command.CreateElementCommand.removeElement((JRDesignElement)this.jrElement, (JRElement[])cell.getElements());
            }
            if ((cell = bc.getColumnHeader()) != null) {
                com.jaspersoft.studio.model.command.CreateElementCommand.removeElement((JRDesignElement)this.jrElement, (JRElement[])cell.getElements());
            }
            if ((cell = bc.getColumnFooter()) != null) {
                com.jaspersoft.studio.model.command.CreateElementCommand.removeElement((JRDesignElement)this.jrElement, (JRElement[])cell.getElements());
            }
            for (GroupCell gc : bc.getGroupHeaders()) {
                cell = gc.getCell();
                if (cell == null) continue;
                com.jaspersoft.studio.model.command.CreateElementCommand.removeElement((JRDesignElement)this.jrElement, (JRElement[])cell.getElements());
            }
            for (GroupCell gc : bc.getGroupFooters()) {
                cell = gc.getCell();
                if (cell == null) continue;
                com.jaspersoft.studio.model.command.CreateElementCommand.removeElement((JRDesignElement)this.jrElement, (JRElement[])cell.getElements());
            }
            if (!(bc instanceof ColumnGroup)) continue;
            this.removeElementFromColumn(((ColumnGroup)bc).getColumns());
        }
    }
}

