/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.table.model.cell.command;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.components.table.ColumnCell;
import com.jaspersoft.studio.components.table.Guide;
import com.jaspersoft.studio.components.table.TableManager;
import com.jaspersoft.studio.components.table.model.MTable;
import com.jaspersoft.studio.components.table.model.column.MColumn;
import com.jaspersoft.studio.editor.layout.ILayout;
import com.jaspersoft.studio.editor.layout.LayoutCommand;
import com.jaspersoft.studio.editor.layout.LayoutManager;
import com.jaspersoft.studio.editor.layout.VerticalRowLayout;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.property.IPostSetValue;
import java.util.List;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;
import org.eclipse.ui.views.properties.IPropertySource;

public class PostSetSizeCell
implements IPostSetValue {
    public Command postSetValue(IPropertySource target, Object prop, Object newValue, Object oldValue) {
        if (target instanceof MColumn && (prop.equals("width") || prop.equals("height"))) {
            MColumn mband = (MColumn)target;
            JasperDesign jDesign = mband.getJasperDesign();
            return this.getLayoutCommands(mband, jDesign, prop);
        }
        return null;
    }

    protected Command getLayoutCommands(MColumn mcell, JasperDesign jDesign, Object prop) {
        MTable mTable = mcell.getMTable();
        JSSCompoundCommand c = new JSSCompoundCommand("Layout Table Cells", (ANode)mTable);
        if (prop.equals("width")) {
            JSSCompoundCommand layoutCommands = mTable.getTableManager().getLayoutCommand();
            layoutCommands.setReferenceNodeIfNull((ANode)mTable);
            c.add((Command)layoutCommands);
        } else if (prop.equals("height")) {
            JRPropertiesHolder[] pholder = new JRPropertiesHolder[3];
            pholder[2] = mTable.getValue();
            TableManager tb = mTable.getTableManager();
            ColumnCell cc = tb.getMatrixHelper().getColumnCell(new ColumnCell(mcell.getType(), mcell.getGrName(), (BaseColumn)mcell.getValue()));
            if (TableManager.isBottomOfTable(cc.type)) {
                Guide guide = cc.getNorth();
                this.createLayoutCellsCommands(jDesign, pholder, c, guide.getNext());
            } else {
                Guide guide = cc.getSouth();
                this.createLayoutCellsCommands(jDesign, pholder, c, guide.getPrev());
            }
        }
        return c;
    }

    protected void createLayoutCellsCommands(JasperDesign jDesign, JRPropertiesHolder[] pholder, JSSCompoundCommand c, List<ColumnCell> cells) {
        for (ColumnCell ccell : cells) {
            if (ccell.cell == null) continue;
            pholder[0] = ccell.cell;
            pholder[1] = ccell.column;
            ILayout layout = LayoutManager.getLayout((JRPropertiesHolder[])pholder, (JasperDesign)jDesign, null, (ILayout)new VerticalRowLayout());
            Rectangle r = ccell.getBounds();
            Dimension d = new Dimension(r.width, r.height);
            d = LayoutManager.getPaddedSize((JRLineBox)ccell.cell.getLineBox(), (Dimension)d);
            c.add((Command)new LayoutCommand(jDesign, (JRElementGroup)ccell.cell, layout, d));
        }
    }
}

