/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.table.model.column;

import com.jaspersoft.studio.components.table.TableManager;
import com.jaspersoft.studio.components.table.TableNodeIconDescriptor;
import com.jaspersoft.studio.components.table.TableSetValueCommandProvider;
import com.jaspersoft.studio.components.table.messages.Messages;
import com.jaspersoft.studio.components.table.model.AMCollection;
import com.jaspersoft.studio.components.table.model.MTable;
import com.jaspersoft.studio.components.table.model.MTableGroupFooter;
import com.jaspersoft.studio.components.table.model.MTableGroupHeader;
import com.jaspersoft.studio.components.table.model.columngroup.MColumnGroup;
import com.jaspersoft.studio.components.table.model.columngroup.MColumnGroupCell;
import com.jaspersoft.studio.components.table.util.TableColumnNumerator;
import com.jaspersoft.studio.components.table.util.TableColumnSize;
import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.editor.layout.ILayout;
import com.jaspersoft.studio.editor.layout.LayoutManager;
import com.jaspersoft.studio.editor.layout.VerticalRowLayout;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.IContainer;
import com.jaspersoft.studio.model.IContainerEditPart;
import com.jaspersoft.studio.model.IContainerLayout;
import com.jaspersoft.studio.model.IGraphicElement;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.IPastable;
import com.jaspersoft.studio.model.MRoot;
import com.jaspersoft.studio.model.util.IIconDescriptor;
import com.jaspersoft.studio.property.ISetValueCommandProvider;
import com.jaspersoft.studio.property.descriptor.expression.ExprUtil;
import com.jaspersoft.studio.property.descriptor.expression.JRPrintWhenExpressionPropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.propexpr.JPropertyExpressionsDescriptor;
import com.jaspersoft.studio.property.descriptor.propexpr.PropertyExpressionDTO;
import com.jaspersoft.studio.property.descriptor.propexpr.PropertyExpressionsDTO;
import com.jaspersoft.studio.property.descriptors.PixelPropertyDescriptor;
import com.jaspersoft.studio.utils.ModelUtils;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.StandardBaseColumn;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRPropertyExpression;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JRDesignPropertyExpression;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;
import org.eclipse.babel.editor.util.UIUtils;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class MColumn
extends APropertyNode
implements IPastable,
IContainer,
IContainerLayout,
IGraphicElement,
IContainerEditPart {
    public static final long serialVersionUID = 10200L;
    private static IIconDescriptor iconDescriptor;
    public static String PROPERTY_NAME;
    public static String COLUMN_NAME;
    private static IPropertyDescriptor[] descriptors;
    private JRDesignGroup jrGroup;
    private MTable containerTable;
    protected AMCollection containerSection;
    private List<ANode> list;
    private String name;
    private String grName;
    private int type = 0;

    static {
        PROPERTY_NAME = "NAME";
        COLUMN_NAME = "com.jaspersoft.studio.components.table.model.column.name";
    }

    public MColumn() {
    }

    public MColumn(ANode parent, StandardBaseColumn column, String name, int index) {
        super(parent, index);
        this.setValue(column);
        this.name = name;
        List<ANode> n = this.getAMCollection();
        if (n != null && !n.isEmpty()) {
            ANode aNode = n.get(n.size() - 1);
            this.type = TableColumnSize.getType(aNode.getClass());
            if (aNode instanceof MTableGroupHeader) {
                this.jrGroup = ((MTableGroupHeader)aNode).getJrDesignGroup();
                this.grName = this.jrGroup.getName();
            }
            if (aNode instanceof MTableGroupFooter) {
                this.jrGroup = ((MTableGroupFooter)aNode).getJrDesignGroup();
                this.grName = this.jrGroup.getName();
            }
        }
    }

    public void setParent(ANode newparent, int newIndex) {
        super.setParent(newparent, newIndex);
        ANode node = this.getParent();
        while (node != null) {
            if (node instanceof MTable) {
                this.containerTable = (MTable)node;
                break;
            }
            if (node instanceof AMCollection) {
                this.containerSection = (AMCollection)node;
            }
            node = node.getParent();
        }
        if (newparent == null && this.getValue() != null) {
            this.getValue().getEventSupport().removePropertyChangeListener((PropertyChangeListener)((Object)this));
        }
    }

    public JRDesignGroup getJrGroup() {
        return this.jrGroup;
    }

    public MColumn getNorth() {
        ANode mparent = this.getParent();
        if (TableManager.isBottomOfTable(this.type)) {
            if (this instanceof MColumnGroup || this instanceof MColumnGroupCell) {
                return (MColumn)((Object)this.getChildren().get(0));
            }
            MTable mtable = this.getMTable();
            List<ANode> amCollection = this.getAMCollection();
            int index = mtable.getChildren().indexOf(amCollection.get(amCollection.size() - 1));
            AMCollection newmc = (AMCollection)((Object)mtable.getChildren().get(index - 1));
            return (MColumn)((Object)newmc.getChildren().get(0));
        }
        if (mparent instanceof MColumnGroup || mparent instanceof MColumnGroupCell) {
            return (MColumn)mparent;
        }
        MTable mtable = this.getMTable();
        int index = mtable.getChildren().indexOf(mparent);
        if (index > 0) {
            AMCollection newmc = (AMCollection)((Object)mtable.getChildren().get(index - 1));
            return this.getBottomColumn(newmc.getChildren());
        }
        return null;
    }

    private MColumn getBottomColumn(List<INode> newmc) {
        for (Object col : newmc) {
            if (col instanceof MColumnGroup || col instanceof MColumnGroupCell) {
                col = this.getBottomColumn(col.getChildren());
            }
            if (!(col instanceof MColumn)) continue;
            return (MColumn)((Object)col);
        }
        return null;
    }

    public int getType() {
        return this.type;
    }

    public String getGrName() {
        return Misc.nvl((String)this.grName);
    }

    public StandardBaseColumn getValue() {
        return (StandardBaseColumn)super.getValue();
    }

    public Color getForeground() {
        return UIUtils.getSystemColor((int)39);
    }

    public String getDisplayText() {
        return this.getName();
    }

    public String getName() {
        if (this.name == null) {
            return this.getValue().getPropertiesMap().getProperty(COLUMN_NAME);
        }
        return this.name;
    }

    public void setName(String name) {
        String oldValue = this.name;
        this.name = name;
        this.getValue().getPropertiesMap().setProperty(COLUMN_NAME, name);
        this.getPropertyChangeSupport().firePropertyChange(PROPERTY_NAME, oldValue, name);
    }

    public ImageDescriptor getImagePath() {
        return MColumn.getIconDescriptor().getIcon16();
    }

    public String getToolTip() {
        String tt = "";
        List<ANode> nodes = this.getAMCollection();
        int i = nodes.size() - 1;
        while (i >= 0) {
            tt = String.valueOf(tt) + nodes.get(i).getDisplayText() + "\n";
            --i;
        }
        tt = String.valueOf(tt) + "\t" + MColumn.getIconDescriptor().getToolTip() + ": " + this.getDisplayText();
        return tt;
    }

    public IPropertyDescriptor[] getDescriptors() {
        return descriptors;
    }

    public void setDescriptors(IPropertyDescriptor[] descriptors1) {
        descriptors = descriptors1;
    }

    public void createPropertyDescriptors(List<IPropertyDescriptor> desc) {
        JRPrintWhenExpressionPropertyDescriptor printWhenExprD = new JRPrintWhenExpressionPropertyDescriptor((Object)"printWhenExpression", Messages.MColumn_print_when_expression);
        printWhenExprD.setDescription(Messages.MColumn_print_when_expression_description);
        desc.add((IPropertyDescriptor)printWhenExprD);
        PixelPropertyDescriptor wD = new PixelPropertyDescriptor((Object)"width", Messages.MColumn_column_width);
        desc.add((IPropertyDescriptor)wD);
        JPropertyExpressionsDescriptor propertiesD = new JPropertyExpressionsDescriptor((Object)"propertyExpressions", com.jaspersoft.studio.messages.Messages.MGraphicElement_property_expressions);
        propertiesD.setDescription(com.jaspersoft.studio.messages.Messages.MGraphicElement_property_expressions_description);
        desc.add((IPropertyDescriptor)propertiesD);
        printWhenExprD.setCategory(Messages.MColumn_column_properties_category);
        wD.setCategory(Messages.MColumn_column_properties_category);
    }

    public Object getPropertyValue(Object id) {
        StandardBaseColumn jrElement = this.getValue();
        if (id.equals("width")) {
            return jrElement.getWidth();
        }
        if (id.equals("printWhenExpression")) {
            return ExprUtil.getExpression((JRExpression)jrElement.getPrintWhenExpression());
        }
        if (id.equals("height")) {
            return this.getMTable().getTableManager().getYhcolumn((int)this.type, (String)this.grName, (BaseColumn)jrElement).height;
        }
        if (id.equals("propertyExpressions")) {
            JRPropertiesMap propertiesMap;
            JRPropertyExpression[] propertyExpressions = jrElement.getPropertyExpressions();
            if (propertyExpressions != null) {
                propertyExpressions = (JRPropertyExpression[])propertyExpressions.clone();
            }
            if ((propertiesMap = jrElement.getPropertiesMap()) != null) {
                propertiesMap = propertiesMap.cloneProperties();
            }
            return new PropertyExpressionsDTO(propertyExpressions, propertiesMap, (Object)this.getValue(), ModelUtils.getExpressionContext((ANode)this));
        }
        if (id.equals("PROPERTY_MAP")) {
            JRPropertiesMap propertiesMap = jrElement.getPropertiesMap();
            if (propertiesMap != null) {
                propertiesMap = propertiesMap.cloneProperties();
            }
            return propertiesMap;
        }
        return null;
    }

    public void setPropertyValue(Object id, Object value) {
        StandardBaseColumn jrElement = this.getValue();
        if (id.equals("width")) {
            throw new UnsupportedOperationException("Column Width shouldn't be set directly, use the appropriate command SetColumnWidthCommand");
        }
        if (id.equals("height")) {
            Integer height = (Integer)value;
            if (this.containerSection != null && height >= 0) {
                Class<?> classType = ((Object)((Object)this.containerSection)).getClass();
                String grName = null;
                if (this.containerSection instanceof MTableGroupHeader) {
                    grName = ((MTableGroupHeader)this.containerSection).getJrDesignGroup().getName();
                } else if (this.containerSection instanceof MTableGroupFooter) {
                    grName = ((MTableGroupFooter)this.containerSection).getJrDesignGroup().getName();
                }
                this.containerTable.getTableManager().setHeight(null, height, (BaseColumn)jrElement, TableColumnSize.getType(classType), grName);
                this.containerTable.getTableManager().update();
                this.getPropertyChangeSupport().firePropertyChange(new PropertyChangeEvent((Object)this, "height", null, value));
            }
        } else if (id.equals("printWhenExpression")) {
            jrElement.setPrintWhenExpression(ExprUtil.setValues((JRExpression)jrElement.getPrintWhenExpression(), (Object)value, null));
        } else if (id.equals("PROPERTY_MAP")) {
            JRPropertiesMap v = (JRPropertiesMap)value;
            String[] names = jrElement.getPropertiesMap().getPropertyNames();
            int i = 0;
            while (i < names.length) {
                jrElement.getPropertiesMap().removeProperty(names[i]);
                ++i;
            }
            names = v.getPropertyNames();
            i = 0;
            while (i < names.length) {
                jrElement.getPropertiesMap().setProperty(names[i], v.getProperty(names[i]));
                ++i;
            }
            this.getPropertyChangeSupport().firePropertyChange("PROPERTY_MAP", false, true);
        } else if (id.equals("propertyExpressions") && value instanceof PropertyExpressionsDTO) {
            PropertyExpressionsDTO dto = (PropertyExpressionsDTO)value;
            JRPropertyExpression[] expr = jrElement.getPropertyExpressions();
            if (expr != null) {
                JRPropertyExpression[] jRPropertyExpressionArray = expr;
                int n = expr.length;
                int n2 = 0;
                while (n2 < n) {
                    JRPropertyExpression ex = jRPropertyExpressionArray[n2];
                    jrElement.removePropertyExpression(ex);
                    ++n2;
                }
            }
            for (PropertyExpressionDTO p : dto.getProperties()) {
                if (!p.isExpression()) continue;
                JRDesignPropertyExpression newExp = new JRDesignPropertyExpression();
                newExp.setName(p.getName());
                newExp.setValueExpression(p.getValueAsExpression());
                jrElement.addPropertyExpression((JRPropertyExpression)newExp);
            }
            String[] names = jrElement.getPropertiesMap().getPropertyNames();
            int i = 0;
            while (i < names.length) {
                jrElement.getPropertiesMap().removeProperty(names[i]);
                ++i;
            }
            for (PropertyExpressionDTO p : dto.getProperties()) {
                if (p.isExpression()) continue;
                jrElement.getPropertiesMap().setProperty(p.getName(), p.getValue());
            }
            this.getPropertyChangeSupport().firePropertyChange("PROPERTY_MAP", false, true);
        }
    }

    public JRDesignElement createJRElement(JasperDesign jasperDesign) {
        return null;
    }

    public List<ANode> getAMCollection() {
        if (this.list == null) {
            this.list = new ArrayList<ANode>();
            ANode node = this.getParent();
            while (node != null) {
                this.list.add(node);
                if (node instanceof AMCollection) {
                    return this.list;
                }
                node = node.getParent();
            }
        }
        return this.list;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        AMCollection section = this.getSection();
        if (section != null && evt.getPropertyName().equals(section.getCellEvent()) && evt.getSource() == this.getValue()) {
            StandardBaseColumn bc = (StandardBaseColumn)evt.getSource();
            ANode parent = this.getParent();
            MColumn child = this;
            int newIndex = parent.getChildren().indexOf((Object)this);
            parent.removeChild((ANode)child);
            section.createColumn(parent, (BaseColumn)bc, 122, newIndex);
            MTable mtable = (MTable)section.getParent();
            if (mtable == null) {
                if (evt.getSource() instanceof JRPropertyChangeSupport) {
                    ((JRPropertyChangeSupport)evt.getSource()).removePropertyChangeListener((PropertyChangeListener)((Object)child));
                } else if (evt.getSource() instanceof JRChangeEventsSupport) {
                    ((JRChangeEventsSupport)evt.getSource()).getEventSupport().removePropertyChangeListener((PropertyChangeListener)((Object)child));
                }
            } else {
                mtable.getTableManager().refresh();
                TableColumnNumerator.renumerateColumnNames(mtable);
                parent.propertyChange(evt);
            }
        }
        super.propertyChange(evt);
    }

    public AMCollection getSection() {
        return this.containerSection;
    }

    public MTable getMTable() {
        return this.containerTable;
    }

    public Rectangle getBounds() {
        StandardBaseColumn c = this.getValue();
        MTable mc = this.getMTable();
        if (mc != null && c != null) {
            return mc.getTableManager().getBounds(c, this.type, this.grName);
        }
        return null;
    }

    public int getDefaultWidth() {
        return 0;
    }

    public int getDefaultHeight() {
        return 0;
    }

    public JRPropertiesHolder[] getPropertyHolder() {
        return new JRPropertiesHolder[]{this.getValue(), this.getMTable().getValue()};
    }

    public MColumn getNextColumn() {
        ANode parent = this.getParent();
        MColumn child = this;
        while (parent instanceof MColumnGroupCell) {
            child = parent;
            parent = parent.getParent();
        }
        int index = parent.getChildren().indexOf((Object)child);
        if (index < parent.getChildren().size() - 1) {
            return (MColumn)((Object)parent.getChildren().get(index + 1));
        }
        if (parent instanceof MColumnGroup) {
            return ((MColumnGroup)parent).getNextColumn();
        }
        return null;
    }

    public ILayout getDefaultLayout() {
        return LayoutManager.getLayout((String)VerticalRowLayout.class.getName());
    }

    public static IIconDescriptor getIconDescriptor() {
        if (iconDescriptor == null) {
            iconDescriptor = new TableNodeIconDescriptor("tablecell");
        }
        return iconDescriptor;
    }

    public MTable getTable() {
        MColumn node = this;
        while (node != null && node.getParent() != null && !(node instanceof MTable) && !(node instanceof MRoot)) {
            node = node.getParent();
        }
        if (node instanceof MTable) {
            return (MTable)((Object)node);
        }
        return null;
    }

    public Object getAdapter(Class adapter) {
        if (ISetValueCommandProvider.class.equals((Object)adapter)) {
            return TableSetValueCommandProvider.INSTANCE;
        }
        if (ExpressionContext.class.equals((Object)adapter)) {
            return this.getExpressionContext();
        }
        return super.getAdapter(adapter);
    }

    public ExpressionContext getExpressionContext() {
        if (this.containerTable != null) {
            return this.containerTable.getExpressionContext();
        }
        return null;
    }
}

