/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.table.model.column.action;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.components.table.model.AMCollection;
import com.jaspersoft.studio.components.table.model.MTable;
import com.jaspersoft.studio.components.table.model.column.MColumn;
import com.jaspersoft.studio.components.table.model.column.command.RefreshColumnNamesCommand;
import com.jaspersoft.studio.editor.outline.actions.ACreateAction;
import com.jaspersoft.studio.editor.palette.JDPaletteCreationFactory;
import com.jaspersoft.studio.model.ANode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;

public abstract class CreateColumnAction
extends ACreateAction {
    public CreateColumnAction(IWorkbenchPart part) {
        super(part);
        this.setCreationFactory((CreationFactory)new JDPaletteCreationFactory(MColumn.class));
    }

    protected HashMap<ANode, EditPart> getTableNodes(List<?> objects) {
        HashMap<ANode, EditPart> result = new HashMap<ANode, EditPart>();
        int i = 0;
        while (i < objects.size()) {
            Object obj = objects.get(i);
            if (obj instanceof EditPart) {
                EditPart object = (EditPart)obj;
                if (object.getModel() instanceof MColumn) {
                    result.put((ANode)((MColumn)((Object)object.getModel())).getTable(), object);
                } else if (object.getModel() instanceof AMCollection) {
                    result.put((ANode)((AMCollection)((Object)object.getModel())).getMTable(), object);
                } else if (object.getModel() instanceof MTable) {
                    result.put((ANode)object.getModel(), object);
                }
            }
            ++i;
        }
        return result;
    }

    public void execute(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.execute(((IStructuredSelection)selection).toList());
        }
    }

    public void execute(List<?> editparts) {
        JSSCompoundCommand executedCommand = (JSSCompoundCommand)this.createCommand(editparts);
        this.execute((Command)executedCommand);
    }

    public boolean canExecute(List<?> editparts) {
        Command cmd = this.createCommand(editparts);
        return cmd != null && cmd.canExecute();
    }

    public boolean canExecute(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            return this.canExecute(((IStructuredSelection)selection).toList());
        }
        return false;
    }

    public Command createCommand() {
        return this.createCommand(this.getSelectedObjects());
    }

    public Command createCommand(List<?> objects) {
        if (objects.isEmpty()) {
            return null;
        }
        if (!(objects.get(0) instanceof EditPart)) {
            return null;
        }
        CreateRequest createReq = new CreateRequest((Object)"create child");
        createReq.setLocation(this.location);
        createReq.setFactory(this.creationFactory);
        HashMap map = new HashMap();
        if (!this.setExtendedData(map, objects)) {
            return null;
        }
        createReq.setExtendedData(map);
        HashMap<ANode, EditPart> tables = this.getTableNodes(objects);
        JSSCompoundCommand jssCcmd = new JSSCompoundCommand(null);
        for (Map.Entry<ANode, EditPart> entry : tables.entrySet()) {
            jssCcmd.setReferenceNodeIfNull(entry.getKey());
            Command cmd = entry.getValue().getCommand((Request)createReq);
            if (cmd == null) continue;
            jssCcmd.add(cmd);
        }
        if (!jssCcmd.isEmpty()) {
            for (ANode tableNode : tables.keySet()) {
                jssCcmd.addFirst((Command)new RefreshColumnNamesCommand(tableNode, false, true));
                jssCcmd.add((Command)new RefreshColumnNamesCommand(tableNode, true, false));
            }
            return jssCcmd;
        }
        return null;
    }

    public void run() {
        this.execute(this.getSelectedObjects());
    }
}

