/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.table.model.column.command;

import com.jaspersoft.studio.components.table.TableManager;
import com.jaspersoft.studio.components.table.model.AMCollection;
import com.jaspersoft.studio.components.table.model.MTable;
import com.jaspersoft.studio.components.table.model.MTableColumnFooter;
import com.jaspersoft.studio.components.table.model.MTableColumnHeader;
import com.jaspersoft.studio.components.table.model.MTableDetail;
import com.jaspersoft.studio.components.table.model.MTableFooter;
import com.jaspersoft.studio.components.table.model.MTableGroupFooter;
import com.jaspersoft.studio.components.table.model.MTableGroupHeader;
import com.jaspersoft.studio.components.table.model.MTableHeader;
import com.jaspersoft.studio.components.table.model.column.MColumn;
import com.jaspersoft.studio.components.table.model.columngroup.MColumnGroup;
import com.jaspersoft.studio.components.table.model.columngroup.MColumnGroupCell;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.INode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.components.table.Cell;
import net.sf.jasperreports.components.table.DesignCell;
import net.sf.jasperreports.components.table.StandardBaseColumn;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.gef.commands.Command;

public class CreateColumnCellCommand
extends Command {
    private StandardBaseColumn jrColumn;
    private Class<AMCollection> type;
    private String groupName;
    private Cell jrCell;
    private int height = 0;
    private ANode column;
    private HashMap<Cell, Integer> oldSpans = new HashMap();

    public CreateColumnCellCommand(AMCollection parent, MColumn srcNode) {
        this.type = ((Object)((Object)parent)).getClass();
        if (parent instanceof MTableGroupHeader) {
            this.groupName = ((MTableGroupHeader)parent).getJrDesignGroup().getName();
        }
        if (parent instanceof MTableGroupFooter) {
            this.groupName = ((MTableGroupFooter)parent).getJrDesignGroup().getName();
        }
        this.jrColumn = srcNode.getValue();
        this.column = srcNode;
        this.height = srcNode.getBounds().height;
        if (this.height == 0) {
            this.height = 30;
        }
    }

    protected String getSiblingStyle(ANode parent, ANode column) {
        String style;
        int index = parent.getChildren().indexOf(column);
        int leftIndex = index - 1;
        int rightIndex = index + 1;
        int size = parent.getChildren().size();
        while (leftIndex >= 0 || rightIndex < size) {
            String style2;
            if (leftIndex >= 0) {
                INode leftNode = (INode)parent.getChildren().get(leftIndex);
                style2 = null;
                if (leftNode instanceof MColumnGroup || leftNode instanceof MColumnGroupCell) {
                    style2 = this.getStyleFromColumnGroup((MColumn)leftNode, true);
                } else if (leftNode instanceof MColumn) {
                    style2 = (String)((APropertyNode)leftNode).getPropertyValue((Object)"style");
                }
                if (style2 != null) {
                    return style2;
                }
                --leftIndex;
            }
            if (rightIndex >= size) continue;
            INode rightNode = (INode)parent.getChildren().get(rightIndex);
            style2 = null;
            if (rightNode instanceof MColumnGroup || rightNode instanceof MColumnGroupCell) {
                style2 = this.getStyleFromColumnGroup((MColumnGroup)rightNode, false);
            } else if (rightNode instanceof MColumn) {
                style2 = (String)((APropertyNode)rightNode).getPropertyValue((Object)"style");
            }
            if (style2 != null && !style2.isEmpty()) {
                return style2;
            }
            ++rightIndex;
        }
        if ((parent instanceof MColumnGroup || parent instanceof MColumnGroupCell) && (style = this.getSiblingStyle(parent.getParent(), parent)) != null) {
            return style;
        }
        return null;
    }

    protected String getStyleFromColumnGroup(MColumn group, boolean startFromRight) {
        ArrayList children = new ArrayList(group.getChildren());
        if (startFromRight) {
            Collections.reverse(children);
        }
        for (INode node : group.getChildren()) {
            String style;
            if (!(node instanceof MColumnGroup || node instanceof MColumnGroupCell ? (style = this.getStyleFromColumnGroup((MColumn)node, startFromRight)) != null : node instanceof MColumn && (style = (String)((APropertyNode)node).getPropertyValue((Object)"style")) != null && !style.isEmpty())) continue;
            return style;
        }
        return null;
    }

    protected boolean hasStyleProperties(JRPropertiesMap tableMap) {
        return tableMap.containsProperty("com.jaspersoft.studio.table.style.column_header") || tableMap.containsProperty("com.jaspersoft.studio.table.style.table_header") || tableMap.containsProperty("com.jaspersoft.studio.table.style.detail");
    }

    protected String getStyleName(JRPropertiesMap tableMap) {
        if (this.hasStyleProperties(tableMap)) {
            if (this.type.isAssignableFrom(MTableHeader.class) || this.type.isAssignableFrom(MTableFooter.class)) {
                return tableMap.getProperty("com.jaspersoft.studio.table.style.table_header");
            }
            if (this.type.isAssignableFrom(MTableColumnHeader.class) || this.type.isAssignableFrom(MTableColumnFooter.class) || this.type.isAssignableFrom(MTableGroupHeader.class) || this.type.isAssignableFrom(MTableGroupFooter.class)) {
                return tableMap.getProperty("com.jaspersoft.studio.table.style.column_header");
            }
            if (this.type.isAssignableFrom(MTableDetail.class)) {
                return tableMap.getProperty("com.jaspersoft.studio.table.style.detail");
            }
            return null;
        }
        return this.getSiblingStyle(this.column.getParent(), this.column);
    }

    public void execute() {
        MTable table = ((MColumn)this.column).getMTable();
        TableManager manager = table.getTableManager();
        if (this.jrCell == null) {
            String styleName = this.getStyleName(table.getPropertiesMap());
            this.jrCell = this.createCell(styleName);
        }
        HashMap<Cell, Integer> spans = null;
        if (this.type.isAssignableFrom(MTableHeader.class)) {
            this.jrColumn.setTableHeader(this.jrCell);
            spans = manager.getTableHeaderSpans();
        } else if (this.type.isAssignableFrom(MTableFooter.class)) {
            this.jrColumn.setTableFooter(this.jrCell);
            spans = manager.getTableFooterSpans();
        } else if (this.type.isAssignableFrom(MTableColumnHeader.class)) {
            this.jrColumn.setColumnHeader(this.jrCell);
            spans = manager.getColumnHeaderSpans();
        } else if (this.type.isAssignableFrom(MTableColumnFooter.class)) {
            this.jrColumn.setColumnFooter(this.jrCell);
            spans = manager.getColumnFooterSpans();
        } else if (this.type.isAssignableFrom(MTableGroupHeader.class)) {
            this.jrColumn.setGroupHeader(this.groupName, this.jrCell);
            spans = manager.getGroupHeaderSpans(this.groupName);
        } else if (this.type.isAssignableFrom(MTableGroupFooter.class)) {
            this.jrColumn.setGroupFooter(this.groupName, this.jrCell);
            spans = manager.getGroupFooterSpans(this.groupName);
        }
        if (spans != null) {
            for (Map.Entry<Cell, Integer> value : spans.entrySet()) {
                if (value.getKey().getRowSpan() == value.getValue()) continue;
                this.oldSpans.put(value.getKey(), value.getKey().getRowSpan());
                ((DesignCell)value.getKey()).setRowSpan(value.getValue());
            }
        }
    }

    protected Cell createCell(String styleName) {
        DesignCell cell = new DesignCell();
        cell.setHeight(Integer.valueOf(this.height));
        if (styleName != null) {
            JasperDesign jd = this.column.getJasperDesign();
            JRStyle internalStyle = (JRStyle)jd.getStylesMap().get(styleName);
            if (internalStyle != null) {
                cell.setStyle(internalStyle);
            } else {
                cell.setStyleNameReference(styleName);
            }
        }
        return cell;
    }

    public boolean canUndo() {
        return true;
    }

    public void undo() {
        for (Map.Entry<Cell, Integer> value : this.oldSpans.entrySet()) {
            ((DesignCell)value.getKey()).setRowSpan(value.getValue());
        }
        this.oldSpans.clear();
        if (this.type.isAssignableFrom(MTableHeader.class)) {
            this.jrColumn.setTableHeader(null);
        } else if (this.type.isAssignableFrom(MTableFooter.class)) {
            this.jrColumn.setTableFooter(null);
        } else if (this.type.isAssignableFrom(MTableColumnHeader.class)) {
            this.jrColumn.setColumnHeader(null);
        } else if (this.type.isAssignableFrom(MTableColumnFooter.class)) {
            this.jrColumn.setColumnFooter(null);
        } else if (this.type.isAssignableFrom(MTableGroupHeader.class)) {
            this.jrColumn.setGroupHeader(this.groupName, null);
        } else if (this.type.isAssignableFrom(MTableGroupFooter.class)) {
            this.jrColumn.setGroupFooter(this.groupName, null);
        }
    }
}

