/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.table.model.column.command;

import com.jaspersoft.studio.components.table.TableManager;
import com.jaspersoft.studio.components.table.model.AMCollection;
import com.jaspersoft.studio.components.table.model.MTable;
import com.jaspersoft.studio.components.table.model.MTableGroupFooter;
import com.jaspersoft.studio.components.table.model.MTableGroupHeader;
import com.jaspersoft.studio.components.table.model.column.MColumn;
import com.jaspersoft.studio.components.table.model.columngroup.MColumnGroup;
import com.jaspersoft.studio.components.table.model.columngroup.MColumnGroupCell;
import com.jaspersoft.studio.components.table.util.TableColumnSize;
import com.jaspersoft.studio.model.ANode;
import java.util.List;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.Cell;
import net.sf.jasperreports.components.table.Column;
import net.sf.jasperreports.components.table.DesignCell;
import net.sf.jasperreports.components.table.StandardBaseColumn;
import net.sf.jasperreports.components.table.StandardColumn;
import net.sf.jasperreports.components.table.StandardColumnGroup;
import net.sf.jasperreports.components.table.StandardTable;
import net.sf.jasperreports.components.table.TableComponent;
import net.sf.jasperreports.components.table.util.TableUtil;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.gef.commands.Command;

public class CreateColumnCommand
extends Command {
    private StandardBaseColumn jrColumn;
    protected StandardColumnGroup pColGroup;
    protected StandardTable jrTable;
    protected JasperDesign jrDesign;
    protected JRPropertiesMap tableMap;
    private int index;
    protected MTable tableNode;

    public CreateColumnCommand(AMCollection destNode, MColumn srcNode, int index) {
        this((ANode)destNode, srcNode, index);
    }

    public CreateColumnCommand(MTableGroupHeader destNode, MColumn srcNode, int index) {
        this(destNode.getParent(), srcNode, index);
    }

    public CreateColumnCommand(MTableGroupFooter destNode, MColumn srcNode, int index) {
        this(destNode.getParent(), srcNode, index);
    }

    public CreateColumnCommand(MTable destNode, MColumn srcNode, int index) {
        this((ANode)destNode, srcNode, index);
    }

    public CreateColumnCommand(MColumn destNode, MColumn srcNode, int index) {
        this((ANode)destNode, srcNode, index);
        this.index = index;
    }

    protected CreateColumnCommand(ANode destNode, MColumn srcNode, int index) {
        this.tableNode = TableManager.getTableNode(destNode);
        this.jrTable = this.tableNode != null ? this.tableNode.getStandardTable() : null;
        this.index = index;
        this.jrColumn = srcNode.getValue();
        this.jrDesign = destNode.getJasperDesign();
        JRPropertiesMap jRPropertiesMap = this.tableMap = this.tableNode != null ? this.tableNode.getPropertiesMap() : null;
        if (destNode instanceof MColumnGroup || destNode instanceof MColumnGroupCell) {
            this.pColGroup = (StandardColumnGroup)destNode.getValue();
        }
    }

    public void execute() {
        this.createAndAddColumn();
    }

    public boolean canExecute() {
        return this.tableNode != null && this.jrTable != null;
    }

    private void createAndAddColumn() {
        if (this.jrColumn == null) {
            this.jrColumn = this.createColumn(this.jrDesign, this.jrTable, this.tableMap);
        }
        if (this.pColGroup != null) {
            if (this.index >= 0 && this.index < this.pColGroup.getColumns().size()) {
                this.pColGroup.addColumn(this.index, (BaseColumn)this.jrColumn);
            } else {
                this.pColGroup.addColumn((BaseColumn)this.jrColumn);
            }
        } else if (this.index >= 0 && this.index < this.jrTable.getColumns().size()) {
            this.jrTable.addColumn(this.index, (BaseColumn)this.jrColumn);
        } else {
            this.jrTable.addColumn((BaseColumn)this.jrColumn);
        }
        this.tableNode.getTableManager().updateTableSpans();
    }

    public StandardBaseColumn createColumn(JasperDesign jrDesign, StandardTable jrTable, JRPropertiesMap tableMap) {
        boolean createTHeader = true;
        boolean createTFooter = true;
        boolean createCHeader = true;
        boolean createCFooter = true;
        boolean createGHeader = false;
        boolean createGFooter = false;
        List columns = TableUtil.getAllColumns((TableComponent)jrTable);
        BaseColumn sibling = null;
        if (columns.size() > 0) {
            sibling = this.index >= columns.size() ? (BaseColumn)columns.get(columns.size() - 1) : (this.index <= 0 ? (BaseColumn)columns.get(columns.size() - 1) : (BaseColumn)columns.get(this.index));
        }
        if (sibling != null) {
            createTHeader = sibling.getTableHeader() != null;
            createTFooter = sibling.getTableFooter() != null;
            createCHeader = sibling.getColumnHeader() != null;
            boolean bl = createCFooter = sibling.getColumnFooter() != null;
            if (sibling.getGroupHeaders().size() > 0) {
                boolean bl2 = createGHeader = sibling.getGroupHeaders().get(0) != null;
            }
            if (sibling.getGroupFooters().size() > 0) {
                createGFooter = sibling.getGroupFooters().get(0) != null;
            }
        }
        StandardColumn result = null;
        result = CreateColumnCommand.hasStyleProperties(tableMap) ? CreateColumnCommand.addColumnWithStyle(jrDesign, jrTable, tableMap, createTHeader, createTFooter, createCHeader, createCFooter, createGHeader, createGFooter) : CreateColumnCommand.addColWithSibling(jrDesign, jrTable, createTHeader, createTFooter, createCHeader, createCFooter, createGHeader, createGFooter, sibling);
        return result;
    }

    public static StandardColumn addColumn(JasperDesign jrDesign, StandardTable jrTable, JRPropertiesMap tableMap, boolean createTHeader, boolean createTFooter, boolean createCHeader, boolean createCFooter, boolean createGHeader, boolean createGFooter, int index) {
        StandardColumn result = null;
        if (CreateColumnCommand.hasStyleProperties(tableMap)) {
            result = CreateColumnCommand.addColumnWithStyle(jrDesign, jrTable, tableMap, createTHeader, createTFooter, createCHeader, createCFooter, createGHeader, createGFooter);
        } else {
            List columns = TableUtil.getAllColumns((TableComponent)jrTable);
            BaseColumn sibling = null;
            if (columns.size() > 0) {
                sibling = index >= columns.size() ? (BaseColumn)columns.get(columns.size() - 1) : (index <= 0 ? (BaseColumn)columns.get(columns.size() - 1) : (BaseColumn)columns.get(index));
            }
            result = CreateColumnCommand.addColWithSibling(jrDesign, jrTable, createTHeader, createTFooter, createCHeader, createCFooter, createGHeader, createGFooter, sibling);
        }
        return result;
    }

    public static StandardColumn addColumnWithStyle(JasperDesign jrDesign, StandardTable jrTable, JRPropertiesMap tableMap, boolean isTHead, boolean isTFoot, boolean isCHead, boolean isCFoot, boolean isGHead, boolean isGFoot) {
        DesignCell cell;
        JRStyle tableHeaderStyle = null;
        JRStyle columnHeaderStyle = null;
        JRStyle detailStyle = null;
        if (tableMap != null) {
            String tableHeaderName = tableMap.getProperty("com.jaspersoft.studio.table.style.table_header");
            tableHeaderStyle = tableHeaderName != null ? (JRStyle)jrDesign.getStylesMap().get(tableHeaderName) : null;
            String columnHeaderName = tableMap.getProperty("com.jaspersoft.studio.table.style.column_header");
            columnHeaderStyle = columnHeaderName != null ? (JRStyle)jrDesign.getStylesMap().get(columnHeaderName) : null;
            String detailName = tableMap.getProperty("com.jaspersoft.studio.table.style.detail");
            detailStyle = detailName != null ? (JRStyle)jrDesign.getStylesMap().get(detailName) : null;
        }
        StandardColumn col = new StandardColumn();
        col.setWidth(Integer.valueOf(40));
        if (isTHead) {
            cell = new DesignCell();
            cell.setHeight(Integer.valueOf(TableColumnSize.getInitTableHeight(jrTable, 0, null)));
            cell.setStyle(tableHeaderStyle);
            col.setTableHeader((Cell)cell);
        }
        if (isTFoot) {
            cell = new DesignCell();
            cell.setHeight(Integer.valueOf(TableColumnSize.getInitTableHeight(jrTable, 1, null)));
            cell.setStyle(tableHeaderStyle);
            col.setTableFooter((Cell)cell);
        }
        if (isCHead) {
            cell = new DesignCell();
            cell.setHeight(Integer.valueOf(TableColumnSize.getInitTableHeight(jrTable, 2, null)));
            cell.setStyle(columnHeaderStyle);
            col.setColumnHeader((Cell)cell);
        }
        if (isCFoot) {
            cell = new DesignCell();
            cell.setHeight(Integer.valueOf(TableColumnSize.getInitTableHeight(jrTable, 3, null)));
            cell.setStyle(columnHeaderStyle);
            col.setColumnFooter((Cell)cell);
        }
        cell = new DesignCell();
        cell.setHeight(Integer.valueOf(TableColumnSize.getInitTableHeight(jrTable, 4, null)));
        col.setDetailCell((Cell)cell);
        cell.setStyle(detailStyle);
        List groupsList = TableUtil.getGroupList((TableComponent)jrTable, (JRReport)jrDesign);
        if (groupsList != null) {
            for (JRDesignGroup jrGroup : groupsList) {
                if (isGHead) {
                    cell = new DesignCell();
                    cell.setHeight(Integer.valueOf(TableColumnSize.getInitTableHeight(jrTable, 5, jrGroup.getName())));
                    cell.setStyle(columnHeaderStyle);
                    col.setGroupHeader(jrGroup.getName(), (Cell)cell);
                }
                if (!isGFoot) continue;
                cell = new DesignCell();
                cell.setHeight(Integer.valueOf(TableColumnSize.getInitTableHeight(jrTable, 6, jrGroup.getName())));
                cell.setStyle(columnHeaderStyle);
                col.setGroupFooter(jrGroup.getName(), (Cell)cell);
            }
        }
        return col;
    }

    protected static StandardColumn addColWithSibling(JasperDesign jrDesign, StandardTable jrTable, boolean isTHead, boolean isTFoot, boolean isCHead, boolean isCFoot, boolean isGHead, boolean isGFoot, BaseColumn sibling) {
        List groupsList;
        Column detailCol;
        DesignCell cell;
        StandardColumn col = new StandardColumn();
        col.setWidth(Integer.valueOf(40));
        if (isTHead) {
            cell = new DesignCell();
            cell.setHeight(Integer.valueOf(TableColumnSize.getInitTableHeight(jrTable, 0, null)));
            if (sibling != null && sibling.getTableHeader() != null) {
                cell.setStyle(sibling.getTableHeader().getStyle());
            }
            col.setTableHeader((Cell)cell);
        }
        if (isTFoot) {
            cell = new DesignCell();
            cell.setHeight(Integer.valueOf(TableColumnSize.getInitTableHeight(jrTable, 1, null)));
            if (sibling != null && sibling.getTableFooter() != null) {
                cell.setStyle(sibling.getTableFooter().getStyle());
            }
            col.setTableFooter((Cell)cell);
        }
        if (isCHead) {
            cell = new DesignCell();
            cell.setHeight(Integer.valueOf(TableColumnSize.getInitTableHeight(jrTable, 2, null)));
            if (sibling != null && sibling.getColumnHeader() != null) {
                cell.setStyle(sibling.getColumnHeader().getStyle());
            }
            col.setColumnHeader((Cell)cell);
        }
        if (isCFoot) {
            cell = new DesignCell();
            cell.setHeight(Integer.valueOf(TableColumnSize.getInitTableHeight(jrTable, 3, null)));
            if (sibling != null && sibling.getColumnFooter() != null) {
                cell.setStyle(sibling.getColumnFooter().getStyle());
            }
            col.setColumnFooter((Cell)cell);
        }
        cell = new DesignCell();
        cell.setHeight(Integer.valueOf(TableColumnSize.getInitTableHeight(jrTable, 4, null)));
        col.setDetailCell((Cell)cell);
        if (sibling != null && sibling instanceof Column && (detailCol = (Column)sibling).getDetailCell() != null) {
            cell.setStyle(detailCol.getDetailCell().getStyle());
        }
        if ((groupsList = TableUtil.getGroupList((TableComponent)jrTable, (JRReport)jrDesign)) != null) {
            for (JRDesignGroup jrGroup : groupsList) {
                Cell groupFooter;
                if (isGHead) {
                    Cell groupHeader;
                    cell = new DesignCell();
                    cell.setHeight(Integer.valueOf(TableColumnSize.getInitTableHeight(jrTable, 5, jrGroup.getName())));
                    if (sibling != null && (groupHeader = sibling.getGroupHeader(jrGroup.getName())) != null) {
                        cell.setStyle(groupHeader.getStyle());
                    }
                    col.setGroupHeader(jrGroup.getName(), (Cell)cell);
                }
                if (!isGFoot) continue;
                cell = new DesignCell();
                cell.setHeight(Integer.valueOf(TableColumnSize.getInitTableHeight(jrTable, 6, jrGroup.getName())));
                if (sibling != null && (groupFooter = sibling.getGroupFooter(jrGroup.getName())) != null) {
                    cell.setStyle(groupFooter.getStyle());
                }
                col.setGroupFooter(jrGroup.getName(), (Cell)cell);
            }
        }
        return col;
    }

    protected static boolean hasStyleProperties(JRPropertiesMap tableMap) {
        return tableMap.containsProperty("com.jaspersoft.studio.table.style.column_header") || tableMap.containsProperty("com.jaspersoft.studio.table.style.table_header") || tableMap.containsProperty("com.jaspersoft.studio.table.style.detail");
    }

    public boolean canUndo() {
        return true;
    }

    private void removeAddedColumn() {
        if (this.pColGroup != null) {
            this.index = this.pColGroup.getColumns().indexOf(this.jrColumn);
            this.pColGroup.removeColumn((BaseColumn)this.jrColumn);
        } else {
            this.index = this.jrTable.getColumns().indexOf(this.jrColumn);
            this.jrTable.removeColumn((BaseColumn)this.jrColumn);
        }
    }

    public void undo() {
        this.removeAddedColumn();
    }
}

