/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.table.model.column.command;

import com.jaspersoft.studio.components.table.TableManager;
import com.jaspersoft.studio.components.table.model.AMCollection;
import com.jaspersoft.studio.components.table.model.MTable;
import com.jaspersoft.studio.components.table.model.MTableColumnFooter;
import com.jaspersoft.studio.components.table.model.MTableColumnHeader;
import com.jaspersoft.studio.components.table.model.MTableDetail;
import com.jaspersoft.studio.components.table.model.MTableFooter;
import com.jaspersoft.studio.components.table.model.MTableGroupFooter;
import com.jaspersoft.studio.components.table.model.MTableGroupHeader;
import com.jaspersoft.studio.components.table.model.MTableHeader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.Cell;
import net.sf.jasperreports.components.table.ColumnGroup;
import net.sf.jasperreports.components.table.DesignCell;
import net.sf.jasperreports.components.table.StandardBaseColumn;
import net.sf.jasperreports.components.table.StandardColumnGroup;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.gef.commands.Command;

public class CreateSectionCellsCommand
extends Command {
    private Class<AMCollection> type;
    private String groupName = null;
    private AMCollection section;
    private HashMap<Cell, Integer> oldSpans = new HashMap();
    private HashMap<Cell, BaseColumn> createdCells = new HashMap();

    public CreateSectionCellsCommand(AMCollection parent) {
        this.type = ((Object)((Object)parent)).getClass();
        this.section = parent;
        if (parent instanceof MTableGroupHeader) {
            this.groupName = ((MTableGroupHeader)parent).getJrDesignGroup().getName();
        } else if (parent instanceof MTableGroupFooter) {
            this.groupName = ((MTableGroupFooter)parent).getJrDesignGroup().getName();
        }
    }

    protected boolean hasStyleProperties(JRPropertiesMap tableMap) {
        return tableMap.containsProperty("com.jaspersoft.studio.table.style.column_header") || tableMap.containsProperty("com.jaspersoft.studio.table.style.table_header") || tableMap.containsProperty("com.jaspersoft.studio.table.style.detail");
    }

    protected String getStyleName(JRPropertiesMap tableMap) {
        if (this.hasStyleProperties(tableMap)) {
            if (this.type.isAssignableFrom(MTableHeader.class) || this.type.isAssignableFrom(MTableFooter.class)) {
                return tableMap.getProperty("com.jaspersoft.studio.table.style.table_header");
            }
            if (this.type.isAssignableFrom(MTableColumnHeader.class) || this.type.isAssignableFrom(MTableColumnFooter.class) || this.type.isAssignableFrom(MTableGroupHeader.class) || this.type.isAssignableFrom(MTableGroupFooter.class)) {
                return tableMap.getProperty("com.jaspersoft.studio.table.style.column_header");
            }
            if (this.type.isAssignableFrom(MTableDetail.class)) {
                return tableMap.getProperty("com.jaspersoft.studio.table.style.detail");
            }
        }
        return null;
    }

    protected List<BaseColumn> getAllColumns(List<BaseColumn> cols) {
        ArrayList<BaseColumn> lst = new ArrayList<BaseColumn>();
        for (BaseColumn bc : cols) {
            if (bc instanceof ColumnGroup) {
                lst.addAll(this.getAllColumns(((ColumnGroup)bc).getColumns()));
            }
            lst.add(bc);
        }
        return lst;
    }

    private boolean hasCell(BaseColumn jrColumn) {
        if (this.type.isAssignableFrom(MTableHeader.class)) {
            return jrColumn.getTableHeader() != null;
        }
        if (this.type.isAssignableFrom(MTableFooter.class)) {
            return jrColumn.getTableFooter() != null;
        }
        if (this.type.isAssignableFrom(MTableColumnHeader.class)) {
            return jrColumn.getColumnHeader() != null;
        }
        if (this.type.isAssignableFrom(MTableColumnFooter.class)) {
            return jrColumn.getColumnFooter() != null;
        }
        if (this.type.isAssignableFrom(MTableGroupHeader.class) && this.groupName != null) {
            return jrColumn.getGroupHeader(this.groupName) != null;
        }
        if (this.type.isAssignableFrom(MTableGroupFooter.class) && this.groupName != null) {
            return jrColumn.getGroupFooter(this.groupName) != null;
        }
        return false;
    }

    private void setCell(BaseColumn jrColumn, Cell cell) {
        if (jrColumn instanceof StandardBaseColumn) {
            StandardBaseColumn jrBaseColumn = (StandardBaseColumn)jrColumn;
            if (this.type.isAssignableFrom(MTableHeader.class)) {
                jrBaseColumn.setTableHeader(cell);
            } else if (this.type.isAssignableFrom(MTableFooter.class)) {
                jrBaseColumn.setTableFooter(cell);
            } else if (this.type.isAssignableFrom(MTableColumnHeader.class)) {
                jrBaseColumn.setColumnHeader(cell);
            } else if (this.type.isAssignableFrom(MTableColumnFooter.class)) {
                jrBaseColumn.setColumnFooter(cell);
            } else if (this.type.isAssignableFrom(MTableGroupHeader.class) && this.groupName != null) {
                jrBaseColumn.setGroupHeader(this.groupName, cell);
            } else if (this.type.isAssignableFrom(MTableGroupFooter.class) && this.groupName != null) {
                jrBaseColumn.setGroupFooter(this.groupName, cell);
            }
        }
    }

    private Cell getCell(BaseColumn jrBaseColumn) {
        if (this.type.isAssignableFrom(MTableHeader.class)) {
            return jrBaseColumn.getTableHeader();
        }
        if (this.type.isAssignableFrom(MTableFooter.class)) {
            return jrBaseColumn.getTableFooter();
        }
        if (this.type.isAssignableFrom(MTableColumnHeader.class)) {
            return jrBaseColumn.getColumnHeader();
        }
        if (this.type.isAssignableFrom(MTableColumnFooter.class)) {
            return jrBaseColumn.getColumnFooter();
        }
        if (this.type.isAssignableFrom(MTableGroupHeader.class) && this.groupName != null) {
            return jrBaseColumn.getGroupHeader(this.groupName);
        }
        if (this.type.isAssignableFrom(MTableGroupFooter.class) && this.groupName != null) {
            return jrBaseColumn.getGroupFooter(this.groupName);
        }
        return null;
    }

    public void execute() {
        MTable table = this.section.getMTable();
        TableManager manager = table.getTableManager();
        List<BaseColumn> columns = this.getAllColumns(table.getStandardTable().getColumns());
        String styleName = this.getStyleName(table.getPropertiesMap());
        this.createdCells.clear();
        for (BaseColumn col : columns) {
            if (this.hasCell(col)) continue;
            Cell jrCell = this.createCell(styleName);
            this.setCell(col, jrCell);
            this.createdCells.put(jrCell, col);
        }
        this.setHeight(table.getStandardTable().getColumns(), this.getMaxHeight(table.getStandardTable().getColumns()));
        HashMap<Cell, Integer> spans = null;
        if (this.type.isAssignableFrom(MTableHeader.class)) {
            spans = manager.getTableHeaderSpans();
        } else if (this.type.isAssignableFrom(MTableFooter.class)) {
            spans = manager.getTableFooterSpans();
        } else if (this.type.isAssignableFrom(MTableColumnHeader.class)) {
            spans = manager.getColumnHeaderSpans();
        } else if (this.type.isAssignableFrom(MTableColumnFooter.class)) {
            spans = manager.getColumnFooterSpans();
        } else if (this.type.isAssignableFrom(MTableGroupHeader.class)) {
            spans = manager.getGroupHeaderSpans(this.groupName);
        } else if (this.type.isAssignableFrom(MTableGroupFooter.class)) {
            spans = manager.getGroupFooterSpans(this.groupName);
        }
        if (spans != null) {
            for (Map.Entry<Cell, Integer> value : spans.entrySet()) {
                if (value.getKey().getRowSpan() == value.getValue()) continue;
                this.oldSpans.put(value.getKey(), value.getKey().getRowSpan());
                ((DesignCell)value.getKey()).setRowSpan(value.getValue());
            }
        }
        manager.update();
    }

    private int getMaxHeight(List<BaseColumn> columns) {
        int maxHeight = 30;
        for (BaseColumn column : columns) {
            if (!(column instanceof StandardColumnGroup)) continue;
            int groupHeight = 30 + this.getMaxHeight(((StandardColumnGroup)column).getColumns());
            maxHeight = Math.max(groupHeight, groupHeight);
        }
        return maxHeight;
    }

    private void setHeight(List<BaseColumn> columns, int maxHeight) {
        for (BaseColumn column : columns) {
            Cell cell;
            if (column instanceof StandardColumnGroup) {
                cell = this.getCell(column);
                if (cell != null) {
                    ((DesignCell)cell).setHeight(Integer.valueOf(30));
                }
                this.setHeight(((StandardColumnGroup)column).getColumns(), maxHeight - 30);
                continue;
            }
            cell = this.getCell(column);
            if (cell == null) continue;
            ((DesignCell)cell).setHeight(Integer.valueOf(maxHeight));
        }
    }

    protected Cell createCell(String styleName) {
        DesignCell cell = new DesignCell();
        cell.setHeight(Integer.valueOf(0));
        if (styleName != null) {
            JasperDesign jd = this.section.getJasperDesign();
            JRStyle internalStyle = (JRStyle)jd.getStylesMap().get(styleName);
            if (internalStyle != null) {
                cell.setStyle(internalStyle);
            } else {
                cell.setStyleNameReference(styleName);
            }
        }
        return cell;
    }

    public boolean canUndo() {
        return true;
    }

    public boolean canExecute() {
        MTable table = this.section.getMTable();
        List<BaseColumn> columns = this.getAllColumns(table.getStandardTable().getColumns());
        for (BaseColumn col : columns) {
            if (!this.hasCell(col)) continue;
            return false;
        }
        return true;
    }

    public void undo() {
        for (BaseColumn baseColumn : this.createdCells.values()) {
            this.setCell(baseColumn, null);
        }
        this.createdCells.clear();
        for (Map.Entry entry : this.oldSpans.entrySet()) {
            ((DesignCell)entry.getKey()).setRowSpan((Integer)entry.getValue());
        }
        this.oldSpans.clear();
    }
}

