/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.table.model.column.command;

import com.jaspersoft.studio.components.table.TableComponentFactory;
import com.jaspersoft.studio.components.table.TableManager;
import com.jaspersoft.studio.components.table.model.column.MColumn;
import com.jaspersoft.studio.components.table.model.columngroup.MColumnGroup;
import com.jaspersoft.studio.components.table.model.columngroup.MColumnGroupCell;
import com.jaspersoft.studio.components.table.util.TableColumnSize;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import java.util.List;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.StandardBaseColumn;
import net.sf.jasperreports.components.table.StandardColumnGroup;
import net.sf.jasperreports.components.table.StandardTable;
import org.eclipse.gef.commands.Command;

public class DeleteColumnFromGroupCommand
extends Command {
    private StandardColumnGroup jrGroup;
    private StandardBaseColumn jrColumn;
    private StandardTable jrTable;
    private int elementPosition = 0;
    private Command deleteGroupCommand = null;
    private ANode groupNode;

    public DeleteColumnFromGroupCommand(StandardColumnGroup destNode, MColumn srcNode) {
        this.jrGroup = destNode;
        this.groupNode = this.getGroupNode(destNode, srcNode.getTable().getChildren());
        this.jrColumn = srcNode.getValue();
        this.jrTable = TableManager.getTable((ANode)srcNode.getMTable());
        this.elementPosition = this.jrGroup.getColumns().indexOf(this.jrColumn);
    }

    public DeleteColumnFromGroupCommand(MColumnGroup destNode, MColumn srcNode) {
        this.jrGroup = destNode.getValue();
        this.groupNode = destNode;
        this.jrColumn = srcNode.getValue();
        this.jrTable = TableManager.getTable((ANode)destNode.getMTable());
        this.elementPosition = this.jrGroup.getColumns().indexOf(this.jrColumn);
    }

    public DeleteColumnFromGroupCommand(MColumnGroupCell destNode, MColumn srcNode) {
        this.jrGroup = (StandardColumnGroup)destNode.getValue();
        this.groupNode = destNode;
        this.jrColumn = srcNode.getValue();
        this.jrTable = TableManager.getTable((ANode)destNode.getMTable());
        this.elementPosition = this.jrGroup.getColumns().indexOf(this.jrColumn);
    }

    public void execute() {
        this.jrGroup.removeColumn((BaseColumn)this.jrColumn);
        if (this.jrGroup.getColumns().isEmpty()) {
            this.deleteGroupCommand = TableComponentFactory.getDeleteColumnCommand(this.groupNode.getParent(), this.groupNode);
            if (this.deleteGroupCommand != null && this.deleteGroupCommand.canExecute()) {
                this.jrGroup.setWidth(Integer.valueOf(0));
                this.deleteGroupCommand.execute();
            }
        } else {
            TableColumnSize.setGroupWidth2Top(this.jrTable.getColumns(), this.jrGroup, -this.jrColumn.getWidth().intValue());
        }
    }

    public boolean canUndo() {
        return this.jrGroup != null && this.jrColumn != null;
    }

    public void undo() {
        if (this.deleteGroupCommand != null && this.deleteGroupCommand.canUndo()) {
            this.deleteGroupCommand.undo();
        }
        if (this.elementPosition < 0 || this.elementPosition > this.jrGroup.getColumns().size()) {
            this.jrGroup.addColumn((BaseColumn)this.jrColumn);
        } else {
            this.jrGroup.addColumn(this.elementPosition, (BaseColumn)this.jrColumn);
        }
        TableColumnSize.setGroupWidth2Top(this.jrTable.getColumns(), this.jrGroup, this.jrColumn.getWidth());
    }

    private ANode getGroupNode(StandardColumnGroup searchedGroup, List<INode> children) {
        for (INode child : children) {
            if (child.getValue() == searchedGroup) {
                return (ANode)child;
            }
            ANode childrenResult = this.getGroupNode(searchedGroup, child.getChildren());
            if (childrenResult == null) continue;
            return childrenResult;
        }
        return null;
    }
}

