/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.table.model.column.command;

import com.jaspersoft.studio.components.table.ColumnCell;
import com.jaspersoft.studio.components.table.TableManager;
import com.jaspersoft.studio.components.table.messages.Messages;
import com.jaspersoft.studio.components.table.model.AMCollection;
import com.jaspersoft.studio.components.table.model.column.MColumn;
import com.jaspersoft.studio.components.table.model.columngroup.MColumnGroup;
import com.jaspersoft.studio.model.ANode;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.StandardBaseColumn;
import net.sf.jasperreports.components.table.StandardColumnGroup;
import net.sf.jasperreports.components.table.StandardTable;
import net.sf.jasperreports.components.table.TableComponent;
import net.sf.jasperreports.components.table.util.TableUtil;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.gef.commands.Command;

public class MoveColumnCommand
extends Command {
    private JasperDesign jDesign;
    protected int oldIndex;
    protected int newIndex = -1;
    protected StandardBaseColumn srcColumn;
    private StandardColumnGroup pdestColGroup;
    protected StandardColumnGroup psrcColGroup;
    private List<Integer> deltas;
    protected StandardTable jrTable;
    protected TableManager tbManager;
    private boolean resize = true;

    public MoveColumnCommand(MColumn src, MColumn dest, boolean resize) {
        this(src, (ANode)dest);
        this.resize = resize;
    }

    public MoveColumnCommand(MColumn src, ANode dest) {
        super(Messages.ReorderColumnCommand_reorder_columns);
        this.jDesign = src.getJasperDesign();
        this.tbManager = src.getMTable().getTableManager();
        this.jrTable = TableManager.getTable((ANode)src);
        this.srcColumn = src.getValue();
        ANode srcparent = src.getParent();
        if (srcparent instanceof AMCollection) {
            this.oldIndex = this.jrTable.getColumns().indexOf(this.srcColumn);
        } else if (srcparent.getValue() instanceof StandardColumnGroup) {
            this.psrcColGroup = (StandardColumnGroup)srcparent.getValue();
            this.oldIndex = this.psrcColGroup.getColumns().indexOf(this.srcColumn);
        }
        if (dest == null) {
            return;
        }
        ANode destparent = dest.getParent();
        if (dest instanceof MColumnGroup) {
            this.pdestColGroup = (StandardColumnGroup)dest.getValue();
        } else if (destparent != null) {
            if (destparent instanceof AMCollection) {
                this.newIndex = this.jrTable.getColumns().indexOf(dest.getValue());
            } else if (destparent.getValue() instanceof StandardColumnGroup) {
                this.pdestColGroup = (StandardColumnGroup)destparent.getValue();
                this.newIndex = this.pdestColGroup.getColumns().indexOf(dest.getValue());
            }
        }
    }

    public void setNewIndex(int index) {
        this.newIndex = index;
    }

    public void execute() {
        if (this.resize && this.pdestColGroup != null && this.deltas == null) {
            this.getDeltas(this.tbManager);
        }
        this.delColumn(this.psrcColGroup, this.srcColumn);
        this.addColumn(this.pdestColGroup, this.newIndex, this.srcColumn);
        if (this.resize) {
            this.tbManager.initMaps();
            if (this.pdestColGroup != null) {
                this.tbManager.setRowsHeight(this.deltas);
                this.setMinusDelta();
                this.tbManager.setColumnHeight((BaseColumn)this.srcColumn, this.deltas);
            }
        }
        this.tbManager.refresh();
    }

    public void undo() {
        if (this.resize) {
            this.tbManager.initMaps();
        }
        this.delColumn(this.pdestColGroup, this.srcColumn);
        this.addColumn(this.psrcColGroup, this.oldIndex, this.srcColumn);
        if (this.resize && this.pdestColGroup != null) {
            this.tbManager.setRowsHeight(this.deltas);
            this.setMinusDelta();
            this.tbManager.setColumnHeight((BaseColumn)this.srcColumn, this.deltas);
        }
        this.tbManager.refresh();
    }

    private void setMinusDelta() {
        int i = 0;
        while (i < this.deltas.size()) {
            this.deltas.set(i, -this.deltas.get(i).intValue());
            ++i;
        }
    }

    protected void delColumn(StandardColumnGroup colGroup, StandardBaseColumn col) {
        if (colGroup != null) {
            colGroup.removeColumn((BaseColumn)col);
            this.updateColumnWidth();
        } else {
            this.jrTable.removeColumn((BaseColumn)col);
        }
    }

    protected void addColumn(StandardColumnGroup colGroup, int index, StandardBaseColumn col) {
        if (colGroup != null) {
            if (index >= 0 && index < colGroup.getColumns().size()) {
                colGroup.addColumn(index, (BaseColumn)col);
            } else {
                colGroup.addColumn((BaseColumn)col);
            }
            this.updateColumnWidth();
        } else if (index >= 0 && index < this.jrTable.getColumns().size()) {
            this.jrTable.addColumn(index, (BaseColumn)col);
        } else {
            this.jrTable.addColumn((BaseColumn)col);
        }
    }

    private void updateColumnWidth() {
        for (BaseColumn bc : this.jrTable.getColumns()) {
            if (!(bc instanceof StandardColumnGroup)) continue;
            this.fixWidth((StandardColumnGroup)bc);
        }
    }

    private int fixWidth(StandardColumnGroup group) {
        int w = 0;
        for (BaseColumn bc : group.getColumns()) {
            int gw;
            if (bc instanceof StandardColumnGroup && (gw = this.fixWidth((StandardColumnGroup)bc)) != bc.getWidth()) {
                ((StandardColumnGroup)bc).setWidth(Integer.valueOf(gw));
            }
            w += bc.getWidth().intValue();
        }
        return w;
    }

    private void getDeltas(TableManager tb) {
        this.deltas = new ArrayList<Integer>();
        this.addDelta(tb, 0, "");
        this.addDelta(tb, 2, "");
        this.addDelta(tb, 4, "");
        this.addDelta(tb, 3, "");
        this.addDelta(tb, 1, "");
        List groupsList = TableUtil.getGroupList((TableComponent)this.jrTable, (JRReport)this.jDesign);
        if (groupsList != null) {
            for (JRDesignGroup jrGroup : groupsList) {
                this.addDelta(tb, 5, jrGroup.getName());
                this.addDelta(tb, 6, jrGroup.getName());
            }
        }
    }

    public void addDelta(TableManager tb, int type, String grName) {
        int srch = tb.getRowHeight(new ColumnCell(type, grName, (BaseColumn)this.srcColumn));
        int dsth = tb.getRowHeight(new ColumnCell(type, grName, (BaseColumn)this.pdestColGroup));
        dsth = type != 4 ? (dsth -= tb.getYhcolumn((int)type, (String)grName, (BaseColumn)this.pdestColGroup).height) : srch;
        this.deltas.add(srch - dsth);
    }
}

