/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.table.model.column.command;

import com.jaspersoft.studio.components.table.TableComponentFactory;
import com.jaspersoft.studio.components.table.TableManager;
import com.jaspersoft.studio.components.table.messages.Messages;
import com.jaspersoft.studio.components.table.model.MTable;
import com.jaspersoft.studio.components.table.model.column.MColumn;
import com.jaspersoft.studio.components.table.model.column.command.RefreshColumnNamesCommand;
import com.jaspersoft.studio.components.table.model.columngroup.MColumnGroup;
import com.jaspersoft.studio.components.table.model.columngroup.MColumnGroupCell;
import com.jaspersoft.studio.components.table.util.TableColumnSize;
import com.jaspersoft.studio.model.ANode;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.StandardBaseColumn;
import net.sf.jasperreports.components.table.StandardColumnGroup;
import net.sf.jasperreports.components.table.StandardTable;
import org.eclipse.gef.commands.Command;

public class OrphanColumn4GroupCommand
extends Command {
    private int index;
    private StandardBaseColumn jrColumn;
    protected StandardTable jrTable;
    private StandardColumnGroup jrGroup;
    protected RefreshColumnNamesCommand refreshNameCommand;
    private Command deleteGroupCommand = null;
    private ANode groupNode;

    public OrphanColumn4GroupCommand(MColumnGroup parent, MColumn child) {
        super(Messages.common_orphan_element);
        MTable tableNode = parent.getMTable();
        this.jrGroup = parent.getValue();
        this.jrColumn = child.getValue();
        this.jrTable = TableManager.getTable((ANode)tableNode);
        this.groupNode = parent;
        this.refreshNameCommand = new RefreshColumnNamesCommand(tableNode, true, true);
    }

    public OrphanColumn4GroupCommand(MColumnGroupCell parent, MColumn child) {
        super(Messages.common_orphan_element);
        MTable tableNode = parent.getMTable();
        this.jrGroup = (StandardColumnGroup)parent.getValue();
        this.jrColumn = child.getValue();
        this.jrTable = TableManager.getTable((ANode)tableNode);
        this.groupNode = parent;
        this.refreshNameCommand = new RefreshColumnNamesCommand(tableNode, true, true);
    }

    public void execute() {
        this.index = this.jrGroup.getColumns().indexOf(this.jrColumn);
        this.jrGroup.removeColumn((BaseColumn)this.jrColumn);
        if (this.jrGroup.getColumns().isEmpty()) {
            this.deleteGroupCommand = TableComponentFactory.getDeleteColumnCommand(this.groupNode.getParent(), this.groupNode);
            if (this.deleteGroupCommand != null && this.deleteGroupCommand.canExecute()) {
                this.jrGroup.setWidth(Integer.valueOf(0));
                this.deleteGroupCommand.execute();
            }
        } else {
            TableColumnSize.setGroupWidth2Top(this.jrTable.getColumns(), this.jrGroup, -this.jrColumn.getWidth().intValue());
        }
        this.refreshNameCommand.execute();
    }

    public void undo() {
        if (this.deleteGroupCommand != null && this.deleteGroupCommand.canUndo()) {
            this.deleteGroupCommand.undo();
        }
        if (this.index >= 0 && this.index <= this.jrGroup.getColumns().size()) {
            this.jrGroup.addColumn(this.index, (BaseColumn)this.jrColumn);
        } else {
            this.jrGroup.addColumn((BaseColumn)this.jrColumn);
        }
        TableColumnSize.setGroupWidth2Top(this.jrTable.getColumns(), this.jrGroup, this.jrColumn.getWidth());
        this.refreshNameCommand.undo();
    }
}

