/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.table.model.columngroup;

import com.jaspersoft.studio.components.table.TableNodeIconDescriptor;
import com.jaspersoft.studio.components.table.model.AMCollection;
import com.jaspersoft.studio.components.table.model.MTable;
import com.jaspersoft.studio.components.table.model.column.MCell;
import com.jaspersoft.studio.components.table.util.TableColumnNumerator;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.util.IIconDescriptor;
import java.beans.PropertyChangeEvent;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.Cell;
import net.sf.jasperreports.components.table.DesignCell;
import net.sf.jasperreports.components.table.StandardBaseColumn;
import net.sf.jasperreports.components.table.StandardColumnGroup;
import net.sf.jasperreports.engine.design.events.CollectionElementAddedEvent;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class MColumnGroupCell
extends MCell {
    public static final long serialVersionUID = 10200L;
    private static IIconDescriptor iconDescriptor;
    protected static IPropertyDescriptor[] descriptors;

    public static IIconDescriptor getIconDescriptor() {
        if (iconDescriptor == null) {
            iconDescriptor = new TableNodeIconDescriptor("tablecolumngroup");
        }
        return iconDescriptor;
    }

    public MColumnGroupCell(ANode parent, StandardColumnGroup jrDataset, DesignCell cell, String name, int index) {
        super(parent, (StandardBaseColumn)jrDataset, (Cell)cell, name, index);
    }

    @Override
    public ImageDescriptor getImagePath() {
        return MColumnGroupCell.getIconDescriptor().getIcon16();
    }

    @Override
    public String getToolTip() {
        return String.valueOf(MColumnGroupCell.getIconDescriptor().getToolTip()) + ": " + this.getDisplayText();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        AMCollection section = this.getSection();
        if (section != null && evt.getPropertyName().equals("columns")) {
            if (evt.getSource() instanceof StandardColumnGroup && evt.getSource() == this.getValue()) {
                if (evt.getOldValue() == null && evt.getNewValue() != null) {
                    int newIndex = -1;
                    if (evt instanceof CollectionElementAddedEvent) {
                        newIndex = ((CollectionElementAddedEvent)evt).getAddedIndex();
                    }
                    StandardBaseColumn bc = (StandardBaseColumn)evt.getNewValue();
                    if (section != null) {
                        section.createColumn((ANode)this, (BaseColumn)bc, 122, newIndex);
                    }
                } else if (evt.getOldValue() != null && evt.getNewValue() == null) {
                    for (INode n : this.getChildren()) {
                        if (n.getValue() != evt.getOldValue()) continue;
                        this.removeChild((ANode)n);
                        break;
                    }
                } else {
                    for (INode n : this.getChildren()) {
                        if (n.getValue() != evt.getOldValue()) continue;
                        n.setValue(evt.getNewValue());
                    }
                }
            }
            MTable mTable = (MTable)section.getParent();
            mTable.getTableManager().refresh();
            TableColumnNumerator.renumerateColumnNames(mTable);
        }
        super.propertyChange(evt);
    }
}

