/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.table.model.columngroup.action;

import com.jaspersoft.studio.components.Activator;
import com.jaspersoft.studio.components.table.messages.Messages;
import com.jaspersoft.studio.components.table.model.AMCollection;
import com.jaspersoft.studio.components.table.model.column.MColumn;
import com.jaspersoft.studio.components.table.model.column.command.CheckColumnsOrder;
import com.jaspersoft.studio.components.table.model.column.command.DeleteColumnCommand;
import com.jaspersoft.studio.components.table.model.column.command.DeleteColumnFromGroupCommand;
import com.jaspersoft.studio.components.table.model.column.command.FixCellHeightsCommand;
import com.jaspersoft.studio.components.table.model.column.command.MoveColumnCommand;
import com.jaspersoft.studio.components.table.model.column.command.RefreshColumnNamesCommand;
import com.jaspersoft.studio.components.table.model.columngroup.MColumnGroup;
import com.jaspersoft.studio.components.table.model.columngroup.MColumnGroupCell;
import com.jaspersoft.studio.components.table.part.TableCellEditPart;
import com.jaspersoft.studio.components.table.part.editpolicy.JSSCompoundTableCommand;
import com.jaspersoft.studio.editor.outline.part.TreeEditPart;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractEditPart;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.ui.IWorkbenchPart;

public class UnGroupColumnsAction
extends SelectionAction {
    public static final String ID = "ungroup_table_columns";

    public UnGroupColumnsAction(IWorkbenchPart part) {
        super(part);
    }

    protected void init() {
        super.init();
        this.setText(Messages.UnGroupColumnsAction_title);
        this.setToolTipText(Messages.UnGroupColumnsAction_tooltip);
        this.setId(ID);
        this.setImageDescriptor(Activator.getDefault().getImageDescriptor("icons/table-split-row.png"));
        this.setDisabledImageDescriptor(Activator.getDefault().getImageDescriptor("icons/table-split-row.png"));
        this.setEnabled(false);
    }

    public Command createCommand(List<?> objects) {
        if (objects.isEmpty()) {
            return null;
        }
        if (objects.size() == 1) {
            Object sel = objects.get(0);
            if (sel instanceof TableCellEditPart || sel instanceof TreeEditPart) {
                sel = ((AbstractEditPart)sel).getModel();
            }
            if (sel instanceof MColumn) {
                JSSCompoundTableCommand c = new JSSCompoundTableCommand(Messages.UnGroupColumnsAction_title, ((MColumn)((Object)sel)).getMTable(), true);
                MColumn fmc = (MColumn)((Object)sel);
                ANode mparent = fmc.getParent();
                c.add(new RefreshColumnNamesCommand(mparent, false, true));
                ArrayList<CheckColumnsOrder> fixOrderCommandList = new ArrayList<CheckColumnsOrder>();
                for (INode src : fmc.getChildren()) {
                    if (!(src instanceof MColumn)) continue;
                    fixOrderCommandList.add(new CheckColumnsOrder((MColumn)src));
                }
                Collections.sort(fixOrderCommandList);
                Collections.reverse(fixOrderCommandList);
                c.addAll(fixOrderCommandList);
                int baseIndex = mparent.getChildren().indexOf((Object)fmc);
                for (INode src : fmc.getChildren()) {
                    MoveColumnCommand moveCommand;
                    if (!(src instanceof MColumn)) continue;
                    if (mparent instanceof MColumnGroup || mparent instanceof MColumnGroupCell) {
                        moveCommand = new MoveColumnCommand((MColumn)src, (MColumn)mparent, false);
                        moveCommand.setNewIndex(baseIndex);
                        ++baseIndex;
                        c.add(moveCommand);
                        continue;
                    }
                    moveCommand = new MoveColumnCommand((MColumn)src, null, false);
                    moveCommand.setNewIndex(baseIndex);
                    ++baseIndex;
                    c.add(moveCommand);
                }
                if (mparent instanceof MColumnGroup) {
                    c.add(new DeleteColumnFromGroupCommand((MColumnGroup)mparent, fmc));
                } else if (mparent instanceof MColumnGroupCell) {
                    c.add(new DeleteColumnFromGroupCommand((MColumnGroupCell)mparent, fmc));
                } else if (mparent instanceof AMCollection) {
                    c.add(new DeleteColumnCommand((AMCollection)mparent, fmc));
                }
                c.add(new FixCellHeightsCommand(fmc));
                c.add(new RefreshColumnNamesCommand(mparent, true, false));
                return c;
            }
        }
        return null;
    }

    public void run() {
        this.execute(this.createCommand(this.getSelectedObjects()));
    }

    protected boolean calculateEnabled() {
        List objects = this.getSelectedObjects();
        if (objects != null && objects.size() == 1) {
            Object sel = objects.get(0);
            if (sel instanceof EditPart) {
                sel = ((EditPart)sel).getModel();
            }
            return sel instanceof MColumnGroup || sel instanceof MColumnGroupCell;
        }
        return false;
    }
}

