/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.table.model.nodata.action;

import com.jaspersoft.studio.components.table.model.MTable;
import com.jaspersoft.studio.components.table.model.nodata.MTableNoData;
import com.jaspersoft.studio.components.table.model.nodata.cmd.CreateNoDataCommand;
import com.jaspersoft.studio.components.table.part.editpolicy.JSSCompoundTableCommand;
import com.jaspersoft.studio.editor.action.ACachedSelectionAction;
import com.jaspersoft.studio.utils.SelectionHelper;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.components.table.DesignBaseCell;
import org.eclipse.gef.commands.Command;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class CreateNoDataAction
extends ACachedSelectionAction {
    public static final String ID = "create_table_nodata_cell";

    public CreateNoDataAction(IWorkbenchPart part) {
        super(part);
    }

    protected void init() {
        super.init();
        this.setText("Create No Data Cell");
        this.setToolTipText("Create No Data cell");
        this.setId(ID);
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_NEW_WIZARD"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_NEW_WIZARD_DISABLED"));
        this.setEnabled(false);
    }

    protected boolean calculateEnabled() {
        List cells = this.editor.getSelectionCache().getSelectionModelForType(MTableNoData.class);
        if (!cells.isEmpty()) {
            for (Object rawCell : cells) {
                MTableNoData col = (MTableNoData)((Object)rawCell);
                if (col.getValue() != null) continue;
                return true;
            }
        }
        return false;
    }

    public void run() {
        List cells = this.editor.getSelectionCache().getSelectionModelForType(MTableNoData.class);
        if (!cells.isEmpty()) {
            MTable table = ((MTableNoData)((Object)cells.get(0))).getMTable();
            JSSCompoundTableCommand compundTableCommand = new JSSCompoundTableCommand(table);
            for (Object rawCell : cells) {
                MTableNoData col = (MTableNoData)((Object)rawCell);
                if (col.getValue() != null) continue;
                compundTableCommand.add(new CreateNoDataCommand(col));
            }
            if (!compundTableCommand.isEmpty()) {
                this.execute((Command)compundTableCommand);
                ArrayList<DesignBaseCell> createdElements = new ArrayList<DesignBaseCell>();
                for (Command createCellCommand : compundTableCommand.getCommands()) {
                    createdElements.add(((CreateNoDataCommand)createCellCommand).getCell());
                }
                SelectionHelper.deselectAll();
                SelectionHelper.setSelection(createdElements, (boolean)false);
            }
        }
    }

    protected Command createCommand() {
        return null;
    }
}

