/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.table.model.table.command;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.components.table.messages.Messages;
import com.jaspersoft.studio.components.table.model.MTable;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.model.MPage;
import com.jaspersoft.studio.model.MReport;
import com.jaspersoft.studio.model.command.DeleteElementCommand;
import com.jaspersoft.studio.model.style.command.DeleteStyleCommand;
import com.jaspersoft.studio.utils.ModelUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.eclipse.ui.util.RunnableCancelQuestion;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Pair;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.preference.IPreferenceStore;

public class DeleteTableCommand
extends DeleteElementCommand {
    private List<Command> delteStylesCommand = new ArrayList<Command>();
    private MTable table;
    private boolean cancelled = false;

    public DeleteTableCommand(MTable srcNode) {
        super((MGraphicElement)srcNode);
        this.table = srcNode;
    }

    private boolean isUsedOnlyByTable(List<ANode> nodesUsingInsideTable, List<ANode> nodesUsingOutsideTable) {
        if (nodesUsingInsideTable == null || nodesUsingOutsideTable == null) {
            return false;
        }
        if (nodesUsingInsideTable.size() != nodesUsingOutsideTable.size()) {
            return false;
        }
        for (ANode nodeUsingInsideTable : nodesUsingInsideTable) {
            if (nodesUsingOutsideTable.contains(nodeUsingInsideTable)) continue;
            return false;
        }
        return true;
    }

    protected static boolean hasStyleProperties(JRPropertiesMap tableMap) {
        return tableMap.containsProperty("com.jaspersoft.studio.table.style.column_header") || tableMap.containsProperty("com.jaspersoft.studio.table.style.table_header") || tableMap.containsProperty("com.jaspersoft.studio.table.style.detail");
    }

    protected boolean isExistingInternalStyle(String styleName, JasperDesign jd) {
        if (styleName != null) {
            return jd.getStylesMap().containsKey(styleName);
        }
        return false;
    }

    public void execute() {
        this.delteStylesCommand.clear();
        MReport report = ModelUtils.getReport((ANode)this.table);
        Map reportStyles = report.getUsedStyles();
        Map<String, List<ANode>> tableStyles = this.table.getUsedStyles();
        HashSet<String> unusedStyles = new HashSet<String>();
        for (Map.Entry<String, List<ANode>> entry : tableStyles.entrySet()) {
            List nodesUsingOutsideTable = (List)reportStyles.get(entry.getKey());
            if (!this.jDesign.getStylesMap().containsKey(entry.getKey()) || !this.isUsedOnlyByTable(entry.getValue(), nodesUsingOutsideTable)) continue;
            unusedStyles.add(entry.getKey());
        }
        JRPropertiesMap tableMap = this.table.getPropertiesMap();
        if (DeleteTableCommand.hasStyleProperties(tableMap)) {
            String styleName = tableMap.getProperty("com.jaspersoft.studio.table.style.table_header");
            if (this.isExistingInternalStyle(styleName, this.jDesign)) {
                unusedStyles.add(styleName);
            }
            if (this.isExistingInternalStyle(styleName = tableMap.getProperty("com.jaspersoft.studio.table.style.column_header"), this.jDesign)) {
                unusedStyles.add(styleName);
            }
            if (this.isExistingInternalStyle(styleName = tableMap.getProperty("com.jaspersoft.studio.table.style.detail"), this.jDesign)) {
                unusedStyles.add(styleName);
            }
        }
        if (!unusedStyles.isEmpty()) {
            String unusedStylesName = "";
            int count = 0;
            for (String styleName : unusedStyles) {
                unusedStylesName = String.valueOf(unusedStylesName) + styleName;
                if (count != unusedStyles.size() - 1) {
                    unusedStylesName = String.valueOf(unusedStylesName) + ", ";
                }
                ++count;
            }
            RunnableCancelQuestion.RESPONSE_TYPE response = this.getResponse(unusedStylesName);
            if (response == RunnableCancelQuestion.RESPONSE_TYPE.YES) {
                for (String style : unusedStyles) {
                    JRStyle styleObject = (JRStyle)this.jDesign.getStylesMap().get(style);
                    DeleteStyleCommand command = new DeleteStyleCommand(report, (JRDesignStyle)styleObject);
                    this.delteStylesCommand.add((Command)command);
                }
            } else if (response == RunnableCancelQuestion.RESPONSE_TYPE.CANCEL) {
                this.cancelled = true;
            }
        }
        if (!this.cancelled) {
            for (Command cmd : this.delteStylesCommand) {
                cmd.execute();
            }
            super.execute();
        }
    }

    public void undo() {
        if (!this.cancelled) {
            for (Command cmd : this.delteStylesCommand) {
                cmd.undo();
            }
            super.undo();
        }
    }

    public boolean canExecute() {
        return super.canExecute() && !(this.table.getParent() instanceof MPage);
    }

    protected RunnableCancelQuestion.RESPONSE_TYPE getResponse(String unusedStylesName) {
        IPreferenceStore store = JaspersoftStudioPlugin.getInstance().getPreferenceStore();
        String styleBehavior = store.getString("tableCrosstabDelete");
        if (styleBehavior.equals("deleteStyles")) {
            return RunnableCancelQuestion.RESPONSE_TYPE.YES;
        }
        if (styleBehavior.equals("doNotDelete")) {
            return RunnableCancelQuestion.RESPONSE_TYPE.NO;
        }
        String questionText = MessageFormat.format(Messages.DeleteTableCommand_unusedMessage, unusedStylesName);
        Pair response = UIUtils.showCancellableConfirmation((String)Messages.DeleteTableCommand_unusedTitle, (String)questionText, (String)Messages.EditTableStyleAction_rememberDecision);
        if (((Boolean)response.getValue()).booleanValue()) {
            if (response.getKey() == RunnableCancelQuestion.RESPONSE_TYPE.YES) {
                store.setValue("tableCrosstabDelete", "deleteStyles");
            } else if (response.getKey() == RunnableCancelQuestion.RESPONSE_TYPE.NO) {
                store.setValue("tableCrosstabDelete", "doNotDelete");
            }
        }
        return (RunnableCancelQuestion.RESPONSE_TYPE)response.getKey();
    }
}

