/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.table.model.table.command.wizard;

import com.jaspersoft.studio.components.Activator;
import com.jaspersoft.studio.components.table.messages.Messages;
import com.jaspersoft.studio.components.table.model.dialog.TableStyle;
import com.jaspersoft.studio.components.table.model.dialog.TableStylePreview;
import com.jaspersoft.studio.components.table.model.table.command.wizard.TableSections;
import com.jaspersoft.studio.components.widgets.ColorSelectionWidget;
import com.jaspersoft.studio.editor.style.TemplateStyle;
import com.jaspersoft.studio.property.color.ColorSchemaGenerator;
import com.jaspersoft.studio.swt.widgets.ColorStyledText;
import com.jaspersoft.studio.utils.AlfaRGB;
import com.jaspersoft.studio.wizards.ContextHelpIDs;
import com.jaspersoft.studio.wizards.JSSHelpWizardPage;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class TableWizardLayoutPage
extends JSSHelpWizardPage {
    private boolean isTableHeader = true;
    private boolean isTableFooter = true;
    private boolean isColumnHeader = true;
    private boolean isColumnFooter = true;
    private boolean isGroupHeader = true;
    private boolean isGroupFooter = true;
    private Button alternateColor;
    private Text titleText = null;
    private ColorStyledText borderColor;
    private TableStyle.BorderStyleEnum borderStyle;
    private TableStylePreview preview;
    private TableStyle lastGeneratedStyle = null;
    private Composite bottomComposite;
    private boolean createTitle;
    private TemplateStyle templateToOpen;
    private List<ToolItem> borderStyleButtons = new ArrayList<ToolItem>();
    private static final String tableHeadrButton = "THEADER_BUTTON";
    private static final String columnHeadrButton = "CHEADER_BUTTON";
    private static final String detailButton = "DETAIL_BUTTON";
    private static final String altDetailButton = "ALT_DETAIL_BUTTON";
    private ColorSelectionWidget selectionWidget;
    private ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            TableWizardLayoutPage.this.notifyChange();
        }
    };
    private SelectionAdapter selectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            TableWizardLayoutPage.this.notifyChange();
        }
    };
    private SelectionAdapter colorSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            if (TableWizardLayoutPage.altDetailButton.equals(e.widget.getData("id"))) {
                AlfaRGB detail = TableWizardLayoutPage.this.selectionWidget.getButtonData(TableWizardLayoutPage.detailButton);
                AlfaRGB altDetail = TableWizardLayoutPage.this.selectionWidget.getButtonData(TableWizardLayoutPage.altDetailButton);
                if (!TableWizardLayoutPage.this.alternateColor.getSelection() && !altDetail.equals((Object)detail)) {
                    TableWizardLayoutPage.this.alternateColor.setSelection(true);
                }
                TableWizardLayoutPage.this.notifyChange();
            } else {
                TableWizardLayoutPage.this.notifyChange();
            }
        }
    };
    private boolean createBottom = true;

    protected TableWizardLayoutPage(boolean createTitle) {
        super("tablepage");
        this.setTitle(Messages.TableWizardLayoutPage_layout);
        this.setDescription(Messages.TableWizardLayoutPage_description);
        this.createTitle = createTitle;
    }

    protected TableWizardLayoutPage(boolean createTitle, boolean createBottom) {
        super("tablepage");
        this.setTitle(Messages.TableWizardLayoutPage_layout);
        this.setDescription(Messages.TableWizardLayoutPage_description);
        this.createTitle = createTitle;
        this.createBottom = createBottom;
    }

    protected TableWizardLayoutPage() {
        this(false);
    }

    protected String getContextName() {
        return ContextHelpIDs.WIZARD_LAYOUT_PAGE;
    }

    public void dispose() {
        super.dispose();
    }

    private void updateSelectedColor() {
        String colorName = this.selectionWidget.getSchemaSelected();
        Color color = ColorSchemaGenerator.getColor((String)colorName);
        ColorSchemaGenerator.SCHEMAS variantKey = this.selectionWidget.getVariantSelectedKey();
        AlfaRGB baseColor = new AlfaRGB(new RGB(color.getRed(), color.getGreen(), color.getBlue()), color.getAlpha());
        TableStyle tempStyle = new TableStyle(baseColor, variantKey, TableStyle.BorderStyleEnum.FULL, AlfaRGB.getFullyOpaque((RGB)ColorConstants.white.getRGB()), true);
        this.selectionWidget.setButtonData(tableHeadrButton, tempStyle.getColor("color_table_header"));
        this.selectionWidget.setButtonData(columnHeadrButton, tempStyle.getColor("color_column_header"));
        this.selectionWidget.setButtonData(altDetailButton, tempStyle.getColor("color_detail"));
        this.selectionWidget.setButtonData(detailButton, tempStyle.getColor("color_detail_standard"));
    }

    private void createCellColors(Composite parent) {
        SelectionAdapter schemaSelectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableWizardLayoutPage.this.updateSelectedColor();
                TableWizardLayoutPage.this.notifyChange();
            }
        };
        this.selectionWidget = new ColorSelectionWidget(parent, this.colorSelectionListener, schemaSelectionAdapter, ColorSelectionWidget.STYLE.BOTTOM);
        TableStyle temp = TableWizardLayoutPage.getDefaultStyle();
        this.selectionWidget.addButton(tableHeadrButton, Messages.TableWizardLayoutPage_tableHeaderLabel, temp.getColor("color_table_header"));
        this.selectionWidget.addButton(columnHeadrButton, Messages.TableWizardLayoutPage_columnHeaderLabel, temp.getColor("color_column_header"));
        this.selectionWidget.addButton(detailButton, Messages.TableWizardLayoutPage_detailLabel, temp.getColor("color_detail_standard"));
        this.selectionWidget.addButton(altDetailButton, Messages.TableWizardLayoutPage_altDetailLabel, temp.getColor("color_detail"));
        this.selectionWidget.createControl(Messages.TableWizardLayoutPage_schemaGroupLabel, Messages.TableWizardLayoutPage_manualColorLabel, 4);
        Composite checkContainer = new Composite(this.selectionWidget.getManualComposite(), 0);
        checkContainer.setLayout((Layout)new GridLayout(2, false));
        GridData checkBoxData = new GridData(768);
        checkBoxData.horizontalSpan = 4;
        checkContainer.setLayoutData((Object)checkBoxData);
        this.alternateColor = new Button(checkContainer, 32);
        this.alternateColor.addSelectionListener((SelectionListener)this.selectionListener);
        GridData labelData = new GridData(4, 128, true, false, 1, 1);
        Label buttonText = new Label(checkContainer, 64);
        buttonText.setLayoutData((Object)labelData);
        buttonText.setText(Messages.TableWizardLayoutPage_alternated_rows_label);
    }

    private void setBorderButtons(TableStyle.BorderStyleEnum loadedStyle) {
        this.borderStyle = loadedStyle;
        ToolItem buttonFull = this.borderStyleButtons.get(0);
        ToolItem buttonHorizontal1 = this.borderStyleButtons.get(1);
        ToolItem buttonHorizontal2 = this.borderStyleButtons.get(2);
        buttonFull.setSelection(false);
        buttonHorizontal1.setSelection(false);
        buttonHorizontal2.setSelection(false);
        if (this.borderStyle.equals((Object)TableStyle.BorderStyleEnum.FULL)) {
            buttonFull.setSelection(true);
        } else if (this.borderStyle.equals((Object)TableStyle.BorderStyleEnum.PARTIAL_VERTICAL)) {
            buttonHorizontal1.setSelection(true);
        } else {
            buttonHorizontal2.setSelection(true);
        }
    }

    private void setData() {
        if (this.templateToOpen instanceof TableStyle) {
            TableStyle cStyle = (TableStyle)this.templateToOpen;
            this.selectionWidget.setButtonData(tableHeadrButton, this.templateToOpen.getColor("color_table_header"));
            this.selectionWidget.setButtonData(columnHeadrButton, this.templateToOpen.getColor("color_column_header"));
            this.selectionWidget.setButtonData(altDetailButton, this.templateToOpen.getColor("color_detail"));
            this.selectionWidget.setButtonData(detailButton, this.templateToOpen.getColor("color_detail_standard"));
            this.selectionWidget.switchInputMethod(ColorSelectionWidget.ColorInput.MANUAL);
            this.alternateColor.setSelection(cStyle.hasAlternateColor().booleanValue());
            this.borderColor.setColor(cStyle.getRGBBorderColor());
            this.setBorderButtons(cStyle.getBorderStyle());
            if (this.titleText != null) {
                this.titleText.setText(cStyle.getDescription());
            }
        }
    }

    public TableSections getVisibileSections() {
        return new TableSections(this.isTableHeader, this.isTableFooter, this.isColumnHeader, this.isColumnFooter, this.isGroupHeader, this.isGroupFooter);
    }

    private void createCellBorders(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.TableWizardLayoutPage_cell_border_group);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(1808));
        Label firstLabel = new Label((Composite)group, 0);
        firstLabel.setText(Messages.TableWizardLayoutPage_borders_color_label);
        Label secondLabel = new Label((Composite)group, 0);
        secondLabel.setText(Messages.TableWizardLayoutPage_borders_style_label);
        this.borderColor = new ColorStyledText((Composite)group);
        this.borderColor.setColor(AlfaRGB.getFullyOpaque((RGB)ColorConstants.black.getRGB()));
        GridData borderColorData = new GridData();
        borderColorData.minimumWidth = 50;
        this.borderColor.setLayoutData((Object)borderColorData);
        this.borderColor.setBackground(ColorConstants.white);
        ToolBar toolBar = new ToolBar((Composite)group, 0x800000);
        ToolItem buttonFull = new ToolItem(toolBar, 16);
        buttonFull.setImage(Activator.getDefault().getImage("icons/full_borders.png"));
        this.borderStyleButtons.add(buttonFull);
        ToolItem buttonHorizontal1 = new ToolItem(toolBar, 16);
        buttonHorizontal1.setImage(Activator.getDefault().getImage("icons/horizontal_borders.png"));
        this.borderStyleButtons.add(buttonHorizontal1);
        ToolItem buttonHorizontal2 = new ToolItem(toolBar, 16);
        buttonHorizontal2.setImage(Activator.getDefault().getImage("icons/horizontal_borders2.png"));
        this.borderStyleButtons.add(buttonHorizontal2);
        toolBar.pack();
        buttonFull.setSelection(true);
        this.borderStyle = TableStyle.BorderStyleEnum.FULL;
        this.borderColor.addListener(this.modifyListener);
        buttonFull.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ToolItem buttonFull = TableWizardLayoutPage.this.borderStyleButtons.get(0);
                ToolItem buttonHorizontal1 = TableWizardLayoutPage.this.borderStyleButtons.get(1);
                ToolItem buttonHorizontal2 = TableWizardLayoutPage.this.borderStyleButtons.get(2);
                if (!buttonFull.getSelection()) {
                    TableWizardLayoutPage.this.borderStyle = TableStyle.BorderStyleEnum.FULL;
                    buttonFull.setSelection(true);
                    buttonHorizontal1.setSelection(false);
                    buttonHorizontal2.setSelection(false);
                    TableWizardLayoutPage.this.notifyChange();
                }
            }
        });
        buttonHorizontal1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ToolItem buttonFull = TableWizardLayoutPage.this.borderStyleButtons.get(0);
                ToolItem buttonHorizontal1 = TableWizardLayoutPage.this.borderStyleButtons.get(1);
                ToolItem buttonHorizontal2 = TableWizardLayoutPage.this.borderStyleButtons.get(2);
                if (!buttonHorizontal1.getSelection()) {
                    TableWizardLayoutPage.this.borderStyle = TableStyle.BorderStyleEnum.PARTIAL_VERTICAL;
                    buttonHorizontal1.setSelection(true);
                    buttonFull.setSelection(false);
                    buttonHorizontal2.setSelection(false);
                    TableWizardLayoutPage.this.notifyChange();
                }
            }
        });
        buttonHorizontal2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ToolItem buttonFull = TableWizardLayoutPage.this.borderStyleButtons.get(0);
                ToolItem buttonHorizontal1 = TableWizardLayoutPage.this.borderStyleButtons.get(1);
                ToolItem buttonHorizontal2 = TableWizardLayoutPage.this.borderStyleButtons.get(2);
                if (!buttonHorizontal2.getSelection()) {
                    TableWizardLayoutPage.this.borderStyle = TableStyle.BorderStyleEnum.ONLY_HORIZONTAL;
                    buttonHorizontal2.setSelection(true);
                    buttonFull.setSelection(false);
                    buttonHorizontal1.setSelection(false);
                    TableWizardLayoutPage.this.notifyChange();
                }
            }
        });
    }

    private void createLeftCol(Composite parent) {
        Composite leftCol = new Composite(parent, 0);
        leftCol.setLayout((Layout)new GridLayout(1, false));
        this.createCellColors(leftCol);
        this.createCellBorders(leftCol);
        GridData leftPanelData = new GridData(1040);
        leftPanelData.widthHint = 300;
        leftPanelData.minimumHeight = 200;
        leftCol.setLayoutData((Object)leftPanelData);
    }

    public void recursiveSetEnabled(Control ctrl, boolean enabled) {
        if (ctrl instanceof Composite) {
            Composite comp = (Composite)ctrl;
            Control[] controlArray = comp.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                this.recursiveSetEnabled(c, enabled);
                ++n2;
            }
        } else {
            ctrl.setEnabled(enabled);
        }
    }

    public void setEnabledBottomPanel(boolean enabled) {
        if (this.bottomComposite != null) {
            Control[] controlArray = this.bottomComposite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                this.recursiveSetEnabled(c, enabled);
                ++n2;
            }
        }
    }

    private void createBottom(Composite parent) {
        this.bottomComposite = new Composite(parent, 0);
        GridData bottomData = new GridData(768);
        bottomData.horizontalSpan = 2;
        this.bottomComposite.setLayoutData((Object)bottomData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        this.bottomComposite.setLayout((Layout)layout);
        final Button addTHeader = new Button(this.bottomComposite, 32);
        addTHeader.setText(Messages.TableWizardLayoutPage_add_table_header);
        addTHeader.setSelection(this.isTableHeader);
        addTHeader.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TableWizardLayoutPage.this.isTableHeader = addTHeader.getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        final Button addCHeader = new Button(this.bottomComposite, 32);
        addCHeader.setText(Messages.TableWizardLayoutPage_add_column_header);
        addCHeader.setSelection(this.isColumnHeader);
        addCHeader.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TableWizardLayoutPage.this.isColumnHeader = addCHeader.getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        final Button addGHeader = new Button(this.bottomComposite, 32);
        addGHeader.setText(Messages.TableWizardLayoutPage_add_group_header);
        addGHeader.setSelection(this.isGroupHeader);
        addGHeader.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TableWizardLayoutPage.this.isGroupHeader = addGHeader.getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        final Button addGFooter = new Button(this.bottomComposite, 32);
        addGFooter.setText(Messages.TableWizardLayoutPage_add_group_footer);
        addGFooter.setSelection(this.isGroupFooter);
        addGFooter.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TableWizardLayoutPage.this.isGroupFooter = addGFooter.getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        final Button addCFooter = new Button(this.bottomComposite, 32);
        addCFooter.setText(Messages.TableWizardLayoutPage_add_column_footer);
        addCFooter.setSelection(this.isColumnFooter);
        addCFooter.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TableWizardLayoutPage.this.isColumnFooter = addCFooter.getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        final Button addTFooter = new Button(this.bottomComposite, 32);
        addTFooter.setText(Messages.TableWizardLayoutPage_add_table_footer);
        addTFooter.setSelection(this.isTableFooter);
        addTFooter.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TableWizardLayoutPage.this.isTableFooter = addTFooter.getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public static TableStyle getDefaultStyle() {
        String firstColor = (String)ColorSchemaGenerator.getColors().get(0);
        Color color = ColorSchemaGenerator.getColor((String)firstColor);
        AlfaRGB rgbColor = AlfaRGB.getFullyOpaque((RGB)new RGB(color.getRed(), color.getGreen(), color.getBlue()));
        return new TableStyle(rgbColor, ColorSchemaGenerator.SCHEMAS.DEFAULT, TableStyle.BorderStyleEnum.FULL, AlfaRGB.getFullyOpaque((RGB)ColorConstants.black.getRGB()), false);
    }

    public static TableSections getDefaultSection() {
        return new TableSections(true, true, true, true, true, true);
    }

    public TableStyle getSelectedStyle() {
        if (this.lastGeneratedStyle == null) {
            this.lastGeneratedStyle = TableWizardLayoutPage.getDefaultStyle();
        }
        return this.lastGeneratedStyle;
    }

    private void notifyChange() {
        AlfaRGB tableHeader = this.selectionWidget.getButtonData(tableHeadrButton);
        AlfaRGB columnHeader = this.selectionWidget.getButtonData(columnHeadrButton);
        AlfaRGB detail = this.selectionWidget.getButtonData(detailButton);
        AlfaRGB altDetail = this.selectionWidget.getButtonData(altDetailButton);
        this.lastGeneratedStyle = new TableStyle(tableHeader, columnHeader, detail, altDetail, this.borderStyle, this.borderColor.getColor(), this.alternateColor.getSelection());
        if (this.titleText != null) {
            this.lastGeneratedStyle.setDescription(this.titleText.getText());
        }
        this.preview.setTableStyle(this.lastGeneratedStyle);
    }

    private void createPreview(Composite parent, Composite wizardMainTab) {
        Group group = new Group(parent, 0);
        group.setText(Messages.TableWizardLayoutPage_style_preview_group);
        group.setLayout((Layout)new GridLayout(1, false));
        group.setLayoutData((Object)new GridData(1808));
        this.preview = new TableStylePreview((Composite)group, 0);
        this.preview.setLayoutData(new GridData(1808));
    }

    private void createTitleLabel(Composite parent) {
        Composite titleComposite = new Composite(parent, 0);
        titleComposite.setLayout((Layout)new GridLayout(2, false));
        GridData titleCompositeData = new GridData();
        titleCompositeData.horizontalSpan = 2;
        titleCompositeData.grabExcessHorizontalSpace = true;
        titleCompositeData.horizontalAlignment = 4;
        titleComposite.setLayoutData((Object)titleCompositeData);
        Label descriptionLabel = new Label(titleComposite, 0);
        descriptionLabel.setText(Messages.TableWizardLayoutPage_nameLabel);
        this.titleText = new Text(titleComposite, 2048);
        this.titleText.addModifyListener(this.modifyListener);
        GridData textData = new GridData();
        textData.grabExcessHorizontalSpace = true;
        textData.horizontalAlignment = 4;
        this.titleText.setLayoutData((Object)textData);
    }

    public void createControl(Composite parent) {
        Composite dialog = new Composite(parent, 0);
        GridLayout generalLayout = new GridLayout(2, false);
        dialog.setLayout((Layout)generalLayout);
        this.setControl((Control)dialog);
        if (this.createTitle) {
            this.createTitleLabel(dialog);
        }
        this.createLeftCol(dialog);
        this.createPreview(dialog, parent);
        if (this.createBottom) {
            this.createBottom(dialog);
        }
        if (this.templateToOpen != null) {
            this.setData();
        }
        this.notifyChange();
    }

    public void setTemplateToOpen(TemplateStyle template) {
        this.templateToOpen = template;
    }

    public boolean isTableHeader() {
        return this.isTableHeader;
    }

    public boolean isTableFooter() {
        return this.isTableFooter;
    }

    public boolean isColumnHeader() {
        return this.isColumnHeader;
    }

    public boolean isColumnFooter() {
        return this.isColumnFooter;
    }

    public boolean isGroupHeader() {
        return this.isGroupHeader;
    }

    public boolean isGroupFooter() {
        return this.isGroupFooter;
    }
}

