/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.table.part;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.callout.CalloutEditPart;
import com.jaspersoft.studio.callout.command.CalloutSetConstraintCommand;
import com.jaspersoft.studio.callout.pin.PinEditPart;
import com.jaspersoft.studio.callout.pin.command.PinSetConstraintCommand;
import com.jaspersoft.studio.components.table.TableComponentFactory;
import com.jaspersoft.studio.components.table.figure.CellFigure;
import com.jaspersoft.studio.components.table.figure.EmptyCellFigure;
import com.jaspersoft.studio.components.table.model.MTable;
import com.jaspersoft.studio.components.table.model.cell.command.CreateElementCommand;
import com.jaspersoft.studio.components.table.model.cell.command.OrphanElementCommand;
import com.jaspersoft.studio.components.table.model.column.MCell;
import com.jaspersoft.studio.components.table.model.column.MColumn;
import com.jaspersoft.studio.components.table.part.editpolicy.TableCellMoveEditPolicy;
import com.jaspersoft.studio.components.table.part.editpolicy.TableCellResizableEditPolicy;
import com.jaspersoft.studio.editor.gef.commands.SetPageConstraintCommand;
import com.jaspersoft.studio.editor.gef.figures.ReportPageFigure;
import com.jaspersoft.studio.editor.gef.parts.APrefFigureEditPart;
import com.jaspersoft.studio.editor.gef.parts.FigureEditPart;
import com.jaspersoft.studio.editor.gef.parts.FrameFigureEditPart;
import com.jaspersoft.studio.editor.gef.parts.IContainerPart;
import com.jaspersoft.studio.editor.gef.parts.editPolicy.ColoredLayoutPositionRectangle;
import com.jaspersoft.studio.editor.gef.parts.editPolicy.PageLayoutEditPolicy;
import com.jaspersoft.studio.editor.outline.editpolicy.CloseSubeditorDeletePolicy;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.IContainer;
import com.jaspersoft.studio.model.IGraphicElement;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.model.MPage;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.components.table.DesignBaseCell;
import net.sf.jasperreports.components.table.StandardBaseColumn;
import net.sf.jasperreports.engine.design.JRDesignElement;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.handles.HandleBounds;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;

public class TableCellEditPart
extends APrefFigureEditPart
implements IContainerPart,
IContainer {
    private Dimension containerSize;
    private TableCellResizableEditPolicy cellSelectionPolicy = new TableCellResizableEditPolicy(){

        protected void showSelection() {
            super.showSelection();
            TableCellEditPart.this.updateRulers();
        }
    };
    public static final int X_OFFSET = 10;
    public static final int Y_OFFSET = 10;

    public Object getAdapter(Class key) {
        if (key == IPropertySourceProvider.class || key == IPropertySource.class) {
            return super.getAdapter(key);
        }
        return this.getParent().getAdapter(key);
    }

    public void performRequest(Request req) {
        Command c;
        if ("open".equals(req.getType()) && (c = TableComponentFactory.INST().getStretchToContent((ANode)this.getModel())) != null) {
            this.getViewer().getEditDomain().getCommandStack().execute(c);
        }
        super.performRequest(req);
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new CloseSubeditorDeletePolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new PageLayoutEditPolicy(){
            private ColoredLayoutPositionRectangle targetFeedback;

            protected void eraseLayoutTargetFeedback(Request request) {
                super.eraseLayoutTargetFeedback(request);
                if (this.targetFeedback != null) {
                    this.removeFeedback((IFigure)this.targetFeedback);
                    this.targetFeedback = null;
                }
            }

            protected IFigure getLayoutTargetFeedback(Request request) {
                ChangeBoundsRequest cbr;
                ArrayList<Object> nodes = new ArrayList<Object>();
                if (request instanceof ChangeBoundsRequest) {
                    cbr = (ChangeBoundsRequest)request;
                    List lst = cbr.getEditParts();
                    for (EditPart ep : lst) {
                        nodes.add(ep.getModel());
                        if (((ANode)ep.getModel()).getParent() == TableCellEditPart.this.getModel()) {
                            return null;
                        }
                        if (!(ep instanceof TableCellEditPart)) continue;
                        return null;
                    }
                } else if (request instanceof CreateRequest) {
                    if (!(TableCellEditPart.this.getModel() instanceof MCell)) {
                        return null;
                    }
                    cbr = (CreateRequest)request;
                    nodes.add(cbr.getNewObject());
                }
                if (this.targetFeedback == null) {
                    this.targetFeedback = new ColoredLayoutPositionRectangle((EditPart)TableCellEditPart.this, FrameFigureEditPart.addElementColor, 2.0f, (ANode)TableCellEditPart.this.getModel(), nodes);
                    this.targetFeedback.setFill(false);
                    IFigure hostFigure = this.getHostFigure();
                    Rectangle bounds = hostFigure.getBounds();
                    if (hostFigure instanceof HandleBounds) {
                        bounds = ((HandleBounds)hostFigure).getHandleBounds();
                    }
                    PrecisionRectangle rect = new PrecisionRectangle(bounds);
                    this.getHostFigure().translateToAbsolute((Translatable)rect);
                    this.getFeedbackLayer().translateToRelative((Translatable)rect);
                    this.targetFeedback.setBounds((Rectangle)rect);
                    this.addFeedback((IFigure)this.targetFeedback);
                }
                return this.targetFeedback;
            }

            protected void showLayoutTargetFeedback(Request request) {
                super.showLayoutTargetFeedback(request);
                this.getLayoutTargetFeedback(request);
            }

            protected Command getCreateCommand(ANode parent, Object obj, Rectangle constraint, int index, Request request) {
                if (parent instanceof MPage) {
                    parent = TableCellEditPart.this.getModel();
                }
                Rectangle b = TableCellEditPart.this.getModel().getBounds();
                int x = constraint.x - b.x - ReportPageFigure.PAGE_BORDER.left;
                int y = constraint.y - b.y - ReportPageFigure.PAGE_BORDER.top;
                constraint = new Rectangle(x, y, constraint.width, constraint.height);
                return super.getCreateCommand(parent, obj, constraint, index, request);
            }

            protected Command getAddCommand(Request generic) {
                ChangeBoundsRequest request = (ChangeBoundsRequest)generic;
                List editParts = request.getEditParts();
                MColumn mband = TableCellEditPart.this.getModel();
                JSSCompoundCommand command = new JSSCompoundCommand((ANode)mband);
                command.enableSelectionRestore(true);
                command.setDebugLabel("Add in Table Cell");
                ISelection currentSelection = null;
                int i = 0;
                while (i < editParts.size()) {
                    GraphicalEditPart child = (GraphicalEditPart)editParts.get(i);
                    if (currentSelection == null) {
                        currentSelection = child.getViewer().getSelection();
                    }
                    command.add(this.createAddCommand(request, (EditPart)child, this.translateToModelConstraint(this.getConstraintFor(request, child))));
                    ++i;
                }
                return command;
            }

            protected Command createAddCommand(EditPart child, Object constraint) {
                Rectangle rect = (Rectangle)constraint;
                if (child.getModel() instanceof MGraphicElement) {
                    MGraphicElement cmodel = (MGraphicElement)child.getModel();
                    if (cmodel.getParent() instanceof MCell) {
                        MCell cparent = (MCell)cmodel.getParent();
                        if (cparent == TableCellEditPart.this.getModel()) {
                            SetPageConstraintCommand cmd = new SetPageConstraintCommand();
                            MGraphicElement model = (MGraphicElement)child.getModel();
                            Rectangle r = model.getBounds();
                            JRDesignElement jde = model.getValue();
                            int x = r.x + rect.x - jde.getX();
                            int y = r.y + rect.y - jde.getY();
                            rect.setLocation(x, y);
                            cmd.setContext((ANode)TableCellEditPart.this.getModel(), (ANode)child.getModel(), rect);
                            return cmd;
                        }
                        CompoundCommand c = new CompoundCommand();
                        c.add((Command)new OrphanElementCommand(cparent, cmodel));
                        c.add((Command)new CreateElementCommand((MCell)TableCellEditPart.this.getModel(), cmodel, rect, -1));
                        return c;
                    }
                    return super.createChangeConstraintCommand(child, constraint);
                }
                if (child instanceof CalloutEditPart) {
                    return new CalloutSetConstraintCommand(((CalloutEditPart)child).getModel(), this.adaptConstraint(constraint));
                }
                if (child instanceof PinEditPart) {
                    return new PinSetConstraintCommand(((PinEditPart)child).getModel(), this.adaptConstraint(constraint));
                }
                return null;
            }
        });
        this.installEditPolicy("Selection Feedback", (EditPolicy)this.cellSelectionPolicy);
    }

    public EditPolicy getEditPolicy() {
        return new TableCellMoveEditPolicy();
    }

    public Command getCommand(Request request) {
        if (request.getType().equals("move") && ((ChangeBoundsRequest)request).getMoveDelta().x == 0) {
            return null;
        }
        return super.getCommand(request);
    }

    public boolean isSelectable() {
        return true;
    }

    public MColumn getModel() {
        return (MColumn)super.getModel();
    }

    protected void setupFigure(IFigure rect) {
        this.updateContainerSize();
        MColumn model = this.getModel();
        rect.setToolTip((IFigure)new Label(model.getToolTip()));
        if (model.getValue() != null) {
            StandardBaseColumn col = (StandardBaseColumn)model.getValue();
            Rectangle bounds = ((IGraphicElement)model).getBounds();
            if (bounds != null) {
                int x = bounds.x + ReportPageFigure.PAGE_BORDER.left;
                int y = bounds.y + ReportPageFigure.PAGE_BORDER.top;
                rect.setLocation(new Point(x, y));
                if (model instanceof MCell) {
                    CellFigure f = (CellFigure)rect;
                    f.setJRElement((DesignBaseCell)((MCell)model).getCell(), col, this.getDrawVisitor());
                } else {
                    rect.setSize(bounds.width, bounds.height);
                    ((EmptyCellFigure)rect).setJRElement(col, this.getDrawVisitor(), bounds.height);
                }
                this.updateRulers();
            }
        }
        if (this.getSelected() == 1) {
            this.updateRulers();
        } else {
            List selected = this.getViewer().getSelectedEditParts();
            if (selected.isEmpty()) {
                this.updateRulers();
            } else {
                for (Object obj : selected) {
                    FigureEditPart figEditPart;
                    if (!(obj instanceof FigureEditPart) || (figEditPart = (FigureEditPart)obj).getModel().getParent() != this.getModel()) continue;
                    figEditPart.updateRulers();
                }
            }
        }
    }

    public Object getConstraintFor(ChangeBoundsRequest request, GraphicalEditPart child) {
        return new Rectangle(0, 0, request.getSizeDelta().width, request.getSizeDelta().height);
    }

    public void updateRulers() {
        Dimension d = this.getContaierSize();
        EditPartViewer v = this.getViewer();
        if (d != null) {
            v.setProperty("HEND", (Object)d.width);
            v.setProperty("VEND", (Object)d.height);
        }
        v.setProperty("HOFFSET", (Object)10);
        v.setProperty("VOFFSET", (Object)10);
        v.setProperty("SnapToGrid.GridOrigin", (Object)new Point(10, 10));
    }

    public Dimension getContaierSize() {
        return this.containerSize;
    }

    private void updateContainerSize() {
        MTable table = this.getModel().getMTable();
        if (table != null) {
            Dimension d = table.getTableManager().getSize();
            d.height = Math.max(d.height, (Integer)table.getPropertyValue("height"));
            d.width = Math.max(d.width, (Integer)table.getPropertyValue("width"));
            this.containerSize = d;
        } else {
            this.containerSize = null;
        }
    }
}

