/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.table.part.editpolicy;

import com.jaspersoft.studio.components.table.model.MTable;
import com.jaspersoft.studio.components.table.model.column.MColumn;
import com.jaspersoft.studio.components.table.model.column.command.SetColumnWidthCommand;
import com.jaspersoft.studio.components.table.part.TableCellEditPart;
import com.jaspersoft.studio.components.table.part.editpolicy.JSSCompoundTableCommand;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.property.SetValueCommand;
import net.sf.jasperreports.components.table.StandardBaseColumn;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.ui.views.properties.IPropertySource;

public class CreateResize {
    public static Command createResizeCommand(ChangeBoundsRequest request, TableCellEditPart editPart) {
        MColumn model;
        MColumn oldmodel = model = editPart.getModel();
        Dimension sd = request.getSizeDelta();
        ANode mparent = model.getParent();
        if (request.getResizeDirection() == 8) {
            int index = mparent.getChildren().indexOf((Object)model);
            if (index > 0) {
                model = (MColumn)((Object)mparent.getChildren().get(index - 1));
            } else {
                return null;
            }
        }
        if (request.getResizeDirection() == 1 && (model = model.getNorth()) == null) {
            return null;
        }
        StandardBaseColumn jrColumn = model.getValue();
        PrecisionRectangle deltaRect = new PrecisionRectangle(new Rectangle(0, 0, sd.width, sd.height));
        editPart.getFigure().translateToRelative((Translatable)deltaRect);
        MTable table = CreateResize.getTableModel((ANode)model);
        JSSCompoundTableCommand c = new JSSCompoundTableCommand(table);
        c.setLayoutTableContent(true);
        if (request.getSizeDelta().width != 0) {
            int width;
            int w = deltaRect.width;
            if (request.getResizeDirection() == 8) {
                w = -w;
            }
            if ((width = jrColumn.getWidth() + w) < 0) {
                return null;
            }
            SetColumnWidthCommand setWidthCmd = new SetColumnWidthCommand(model, width);
            c.add(setWidthCmd);
            if (request.getResizeDirection() == 8) {
                jrColumn = oldmodel.getValue();
                w = deltaRect.width;
                width = jrColumn.getWidth() + w;
                if (width < 0) {
                    return null;
                }
                setWidthCmd = new SetColumnWidthCommand(oldmodel, width);
                c.add(setWidthCmd);
            } else if (request.getResizeDirection() == 16 && table != null) {
                MColumn next;
                if (table.hasColumnsAutoresizeProportional()) {
                    next = model.getNextColumn();
                    if (next != null) {
                        StandardBaseColumn nextCol = next.getValue();
                        int newWidth = nextCol.getWidth() - deltaRect.width;
                        if (newWidth < 0) {
                            newWidth = 0;
                        }
                        setWidthCmd = new SetColumnWidthCommand(next, newWidth);
                        c.add(setWidthCmd);
                    }
                } else if (table.hasColumnsAutoresizeNext() && (next = model.getNextColumn()) != null) {
                    StandardBaseColumn nextCol = next.getValue();
                    int newWidth = nextCol.getWidth() - deltaRect.width;
                    if (newWidth < 0) {
                        return null;
                    }
                    setWidthCmd = new SetColumnWidthCommand(next, newWidth);
                    c.add(setWidthCmd);
                }
            }
        }
        if (request.getSizeDelta().height != 0 && model instanceof MColumn) {
            int height;
            MColumn mc = model;
            int h = deltaRect.height;
            if (request.getResizeDirection() == 1) {
                h = -h;
            }
            if ((height = (Integer)mc.getPropertyValue("height") + h) < 0) {
                return null;
            }
            SetValueCommand setCommand = new SetValueCommand();
            setCommand.setTarget((IPropertySource)model);
            setCommand.setPropertyId((Object)"height");
            setCommand.setPropertyValue((Object)height);
            c.add((Command)setCommand);
            if (request.getResizeDirection() == 1 && oldmodel instanceof MColumn) {
                mc = oldmodel;
                h = deltaRect.height;
                height = (Integer)mc.getPropertyValue("height") + h;
                if (height < 0) {
                    height = 0;
                }
                setCommand = new SetValueCommand();
                setCommand.setTarget((IPropertySource)oldmodel);
                setCommand.setPropertyId((Object)"height");
                setCommand.setPropertyValue((Object)height);
                c.add((Command)setCommand);
            }
        }
        if (c.isEmpty()) {
            return null;
        }
        return c;
    }

    private static MTable getTableModel(ANode node) {
        if (node == null) {
            return null;
        }
        if (node instanceof MTable) {
            return (MTable)node;
        }
        return CreateResize.getTableModel(node.getParent());
    }
}

