/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.table.part.editpolicy;

import com.jaspersoft.studio.components.table.part.TableNoDataEditPart;
import com.jaspersoft.studio.components.table.part.editpolicy.CreateResizeNoData;
import com.jaspersoft.studio.editor.gef.figures.ComponentFigure;
import com.jaspersoft.studio.editor.gef.parts.handles.CellResizeHandle2;
import com.jaspersoft.studio.editor.gef.util.GEFUtil;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Handle;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.ResizableEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;

public class TableNoDataResizableEditPolicy
extends ResizableEditPolicy {
    public TableNoDataResizableEditPolicy() {
        this.setDragAllowed(true);
    }

    public TableNoDataEditPart getHost() {
        return (TableNoDataEditPart)super.getHost();
    }

    protected List<Handle> createSelectionHandles() {
        ArrayList<Handle> list = new ArrayList<Handle>();
        TableNoDataEditPart geditPart = this.getHost();
        list.add((Handle)new CellResizeHandle2((GraphicalEditPart)geditPart, 4));
        return list;
    }

    protected Command getMoveCommand(ChangeBoundsRequest request) {
        return null;
    }

    protected Command getResizeCommand(ChangeBoundsRequest request) {
        return CreateResizeNoData.createResizeCommand(request, this.getHost());
    }

    protected IFigure createDragSourceFeedbackFigure() {
        FeedbackFigure r = new FeedbackFigure();
        r.setOpaque(false);
        r.setAlpha(50);
        r.setBackgroundColor(ColorConstants.gray);
        r.setFill(false);
        r.setBorder((Border)new LineBorder(ColorConstants.gray, 1));
        this.addFeedback((IFigure)r);
        return r;
    }

    protected void showChangeBoundsFeedback(ChangeBoundsRequest request) {
        Point moveDelta = request.getMoveDelta().getCopy();
        Dimension sizeDelta = request.getSizeDelta().getCopy();
        moveDelta.y = 0;
        this.getFeedbackLayer().translateToParent((Translatable)moveDelta);
        int delta = moveDelta.x;
        if (request.getType().equals("move")) {
            request.setMoveDelta(new Point(delta, 0));
            if (delta == 0) {
                return;
            }
        }
        if (request.getType().equals("resize") && sizeDelta.width == 0 && sizeDelta.height == 0) {
            return;
        }
        PrecisionRectangle rdelta = new PrecisionRectangle(new Rectangle(moveDelta, sizeDelta));
        FeedbackFigure feedback = (FeedbackFigure)this.getDragSourceFeedbackFigure();
        IFigure hfig = this.getHostFigure();
        feedback.setRequest(request);
        request.getType().equals("move");
        PrecisionRectangle rect = new PrecisionRectangle(this.getInitialFeedbackBounds().getCopy());
        Dimension contaierSize = this.getHost().getContaierSize();
        if (request.getType().equals("resize") && request.getResizeDirection() == 4) {
            rect.x = 10;
            rect.width = contaierSize.width;
        } else if (request.getType().equals("resize") && request.getResizeDirection() == 1) {
            rect.x = 10;
            rdelta.y = -rdelta.height;
            rect.width = contaierSize.width;
        } else if (request.getType().equals("move")) {
            rect.y = 0;
            rect.height = contaierSize.height + 20;
        } else {
            rect.y = 10;
            rect.height = contaierSize.height + 1;
        }
        hfig.translateToAbsolute((Translatable)rect);
        rect.translate(rdelta.x, rdelta.y);
        rect.resize(rdelta.width, rdelta.height);
        feedback.translateToRelative((Translatable)rect);
        feedback.setBounds((Rectangle)rect);
        feedback.validate();
    }

    private final class FeedbackFigure
    extends RectangleFigure {
        private ChangeBoundsRequest request;
        private int x1;
        private int y1;
        private int y2;

        private FeedbackFigure() {
        }

        public void setRequest(ChangeBoundsRequest request) {
            this.request = request;
        }

        public void paintFigure(Graphics g) {
            PrecisionRectangle b = new PrecisionRectangle(this.getBounds().getCopy());
            if (this.request.getType().equals("resize")) {
                super.paintFigure(g);
                Graphics2D gr = ComponentFigure.getG2D((Graphics)g);
                if (gr != null) {
                    gr.fillRect(b.x, b.y, b.width, b.height);
                    AlphaComposite ac = AlphaComposite.getInstance(3, 1.0f);
                    gr.setComposite(ac);
                }
            } else if (this.request.getType().equals("move")) {
                double zoom = GEFUtil.getZoom((Rectangle)b, (IFigure)TableNoDataResizableEditPolicy.this.getHostFigure());
                Graphics2D gr = ComponentFigure.getG2D((Graphics)g);
                if (gr != null) {
                    gr.setColor(Color.gray);
                    AlphaComposite ac = AlphaComposite.getInstance(3, 0.1f);
                    gr.setComposite(ac);
                    int h = 10;
                    b.y = b.y + (int)Math.floor((double)h * zoom) - h - 3;
                    int height = b.height - (int)Math.floor((double)h * zoom);
                    gr.fillRect(b.x, b.y, b.width, height - b.y);
                    ac = AlphaComposite.getInstance(3, 0.8f);
                    gr.setComposite(ac);
                    gr.fillRect(b.x, b.y, b.width, h);
                    gr.fillRect(b.x, height + 3, b.width, h);
                    gr.setStroke(new BasicStroke(2.0f));
                    ac = AlphaComposite.getInstance(3, 1.0f);
                    gr.setComposite(ac);
                    gr.setColor(Color.red);
                    PrecisionRectangle r = new PrecisionRectangle(new Rectangle(this.x1, this.y1, this.x1, this.y2));
                    TableNoDataResizableEditPolicy.this.getHostFigure().translateToAbsolute((Translatable)r);
                    TableNoDataResizableEditPolicy.this.getFeedbackLayer().translateToRelative((Translatable)r);
                    gr.drawLine(r.x, r.y, r.x, r.height);
                }
            }
        }
    }
}

