/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.team.core.ProjectSetCapability;
import org.eclipse.team.core.ProjectSetSerializationContext;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.tigris.subversion.subclipse.core.ISVNRemoteFolder;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.Policy;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.SVNTeamProvider;
import org.tigris.subversion.subclipse.core.commands.CheckoutCommand;
import org.tigris.subversion.subclipse.core.repo.SVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.resources.RemoteFolder;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SVNProjectSetCapability
extends ProjectSetCapability {
    public String[] asReference(IProject[] projects, ProjectSetSerializationContext context, IProgressMonitor monitor) throws TeamException {
        String[] result = new String[projects.length];
        int i = 0;
        while (i < projects.length) {
            result[i] = this.asReference(projects[i]);
            ++i;
        }
        return result;
    }

    private String asReference(IProject project) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("0.9.3,");
        SVNTeamProvider provider = (SVNTeamProvider)RepositoryProvider.getProvider((IProject)project);
        SVNWorkspaceRoot root = provider.getSVNWorkspaceRoot();
        buffer.append(root.getLocalRoot().getUrl().toString());
        buffer.append(",");
        buffer.append(project.getName());
        return buffer.toString();
    }

    public IProject[] addToWorkspace(String[] referenceStrings, ProjectSetSerializationContext context, IProgressMonitor monitor) throws TeamException {
        monitor = Policy.monitorFor(monitor);
        Policy.checkCanceled(monitor);
        HashMap<IProject, LoadInfo> infoMap = new HashMap<IProject, LoadInfo>(referenceStrings.length);
        IProject[] projects = this.asProjects(context, referenceStrings, infoMap);
        projects = this.confirmOverwrite(context, projects);
        if (projects == null) {
            return new IProject[0];
        }
        try {
            return this.checkout(projects, infoMap, monitor);
        }
        catch (MalformedURLException e) {
            throw SVNException.wrapException(e);
        }
    }

    private IProject[] asProjects(ProjectSetSerializationContext context, String[] referenceStrings, Map<IProject, LoadInfo> infoMap) throws SVNException {
        ArrayList<IProject> result = new ArrayList<IProject>();
        String[] stringArray = referenceStrings;
        int n = referenceStrings.length;
        int n2 = 0;
        while (n2 < n) {
            String referenceString = stringArray[n2];
            StringTokenizer tokenizer = new StringTokenizer(referenceString, ",");
            try {
                String version = tokenizer.nextToken();
                if (version.equals("0.9.3")) {
                    LoadInfo info = new LoadInfo(context, tokenizer);
                    IProject proj = info.getProject();
                    result.add(proj);
                    infoMap.put(proj, info);
                }
            }
            catch (NoSuchElementException e) {
                throw new IllegalArgumentException("malformed project reference: " + referenceString, e);
            }
            ++n2;
        }
        return result.toArray(new IProject[result.size()]);
    }

    private IProject[] checkout(IProject[] projects, Map<IProject, LoadInfo> infoMap, IProgressMonitor monitor) throws TeamException, MalformedURLException {
        if (projects == null || projects.length == 0) {
            return new IProject[0];
        }
        ISchedulingRule[] ruleArray = new ISchedulingRule[projects.length];
        int i = 0;
        while (i < projects.length) {
            ruleArray[i] = projects[i].getWorkspace().getRuleFactory().modifyRule((IResource)projects[i]);
            ++i;
        }
        ISchedulingRule rule = MultiRule.combine((ISchedulingRule[])ruleArray);
        Job.getJobManager().beginRule(rule, monitor);
        monitor.beginTask("", 1000 * projects.length);
        ArrayList<IProject> result = new ArrayList<IProject>();
        try {
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                if (monitor.isCanceled()) {
                    break;
                }
                LoadInfo info = infoMap.get(project);
                if (info != null && info.checkout((IProgressMonitor)new SubProgressMonitor(monitor, 1000))) {
                    result.add(project);
                }
                ++n2;
            }
        }
        finally {
            Job.getJobManager().endRule(rule);
            monitor.done();
        }
        return result.toArray(new IProject[result.size()]);
    }

    protected static class LoadInfo {
        private final ISVNRepositoryLocation repositoryLocation;
        private final String repo;
        private final IProject project;
        private final boolean fromFileSystem;
        private final String directory;

        LoadInfo(ProjectSetSerializationContext context, StringTokenizer tokenizer) throws SVNException {
            this.repo = tokenizer.nextToken();
            String projectName = tokenizer.nextToken();
            this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            if (this.repo.indexOf("://") != -1) {
                this.repositoryLocation = SVNRepositoryLocation.fromString(this.repo, false, true);
                this.fromFileSystem = false;
                this.directory = null;
            } else {
                this.repositoryLocation = null;
                this.fromFileSystem = true;
                if (!new Path(this.repo).isAbsolute()) {
                    String baseDir = context.getFilename() != null ? new File(context.getFilename()).getParent() : this.project.getWorkspace().getRoot().getLocation().toOSString();
                    try {
                        this.directory = new File(String.valueOf(baseDir) + File.separatorChar + this.repo).getCanonicalPath();
                    }
                    catch (IOException ioe) {
                        throw new SVNException("Path expansion/canonicalization failed", ioe);
                    }
                } else {
                    this.directory = this.repo;
                }
            }
        }

        protected IProject getProject() {
            return this.project;
        }

        boolean checkout(IProgressMonitor monitor) throws TeamException, MalformedURLException {
            if (this.fromFileSystem) {
                return this.importExistingProject(monitor);
            }
            if (this.repositoryLocation == null) {
                return false;
            }
            RemoteFolder remoteFolder = new RemoteFolder(this.repositoryLocation, new SVNUrl(this.repo), this.repositoryLocation.getRootFolder().getRevision());
            CheckoutCommand command = new CheckoutCommand(new ISVNRemoteFolder[]{remoteFolder}, new IProject[]{this.project});
            command.run(monitor);
            return true;
        }

        boolean importExistingProject(IProgressMonitor monitor) throws TeamException {
            if (this.directory == null) {
                return false;
            }
            try {
                monitor.beginTask("Importing", 3000);
                this.createExistingProject((IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                monitor.subTask("Refreshing " + this.project.getName());
                RepositoryProvider.map((IProject)this.project, (String)SVNProviderPlugin.getTypeId());
                monitor.worked(1000);
                SVNWorkspaceRoot.setSharing(this.project, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                return true;
            }
            catch (CoreException ce) {
                throw new SVNException("Failed to import External SVN Project" + (Object)((Object)ce), ce);
            }
            finally {
                monitor.done();
            }
        }

        void createExistingProject(IProgressMonitor monitor) throws CoreException {
            String projectName = this.project.getName();
            try {
                monitor.beginTask("Creating " + projectName, 2000);
                IProjectDescription description = ResourcesPlugin.getWorkspace().loadProjectDescription((IPath)new Path(String.valueOf(this.directory) + File.separatorChar + ".project"));
                description.setName(projectName);
                this.project.create(description, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                this.project.open((IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            }
            finally {
                monitor.done();
            }
        }
    }
}

