/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.commands;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.client.OperationManager;
import org.tigris.subversion.subclipse.core.commands.ISVNCommand;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public class UpgradeResourcesCommand
implements ISVNCommand {
    private final SVNWorkspaceRoot root;
    private final IResource[] resources;

    public UpgradeResourcesCommand(SVNWorkspaceRoot root, IResource[] resources) {
        this.root = root;
        this.resources = resources;
    }

    @Override
    public void run(IProgressMonitor monitor) throws SVNException {
        ISVNClientAdapter svnClient = null;
        try {
            try {
                monitor.beginTask(null, 100 * this.resources.length);
                svnClient = this.root.getRepository().getSVNClient();
                OperationManager.getInstance().beginOperation(svnClient);
                int i = 0;
                while (i < this.resources.length) {
                    svnClient.upgrade(this.resources[i].getLocation().toFile());
                    monitor.worked(100);
                    ++i;
                }
            }
            catch (SVNClientException e) {
                throw SVNException.wrapException((Exception)((Object)e));
            }
        }
        catch (Throwable throwable) {
            this.root.getRepository().returnSVNClient(svnClient);
            OperationManager.getInstance().endOperation();
            monitor.done();
            throw throwable;
        }
        this.root.getRepository().returnSVNClient(svnClient);
        OperationManager.getInstance().endOperation();
        monitor.done();
    }
}

