/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.history;

import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IResource;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.history.Alias;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNProperty;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class AliasManager {
    private ArrayList<Alias> aliases = new ArrayList();

    public AliasManager(IResource resource) {
        Object[] aliasArray = this.getAliases(resource);
        Arrays.sort(aliasArray);
        Object[] objectArray = aliasArray;
        int n = aliasArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object alias = objectArray[n2];
            this.aliases.add((Alias)alias);
            ++n2;
        }
    }

    public AliasManager(IResource resource, boolean checkParents) {
        Object[] aliasArray = this.getAliases(resource, checkParents);
        Arrays.sort(aliasArray);
        Object[] objectArray = aliasArray;
        int n = aliasArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object alias = objectArray[n2];
            this.aliases.add((Alias)alias);
            ++n2;
        }
    }

    public AliasManager(SVNUrl url) {
        Object[] aliasArray = this.getAliases(url);
        Arrays.sort(aliasArray);
        Object[] objectArray = aliasArray;
        int n = aliasArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object alias = objectArray[n2];
            this.aliases.add((Alias)alias);
            ++n2;
        }
    }

    public Alias[] getTags(int revision) {
        ArrayList<Alias> revisionAliases = new ArrayList<Alias>();
        for (Alias alias : this.aliases) {
            if (alias.getRevision() < revision || alias.isBranch()) continue;
            revisionAliases.add(alias);
        }
        Alias[] aliasArray = new Alias[revisionAliases.size()];
        revisionAliases.toArray(aliasArray);
        Alias[] aliasArray2 = aliasArray;
        int n = aliasArray.length;
        int n2 = 0;
        while (n2 < n) {
            Alias alias = aliasArray2[n2];
            this.aliases.remove(alias);
            ++n2;
        }
        return aliasArray;
    }

    public Alias[] getTags() {
        ArrayList<Alias> tags = new ArrayList<Alias>();
        for (Alias tag : this.aliases) {
            if (tag.isBranch()) continue;
            tags.add(tag);
        }
        Alias[] tagArray = new Alias[tags.size()];
        tags.toArray(tagArray);
        return tagArray;
    }

    public Alias[] getBranches() {
        ArrayList<Alias> branches = new ArrayList<Alias>();
        for (Alias branch : this.aliases) {
            if (!branch.isBranch()) continue;
            branches.add(branch);
        }
        Alias[] branchArray = new Alias[branches.size()];
        branches.toArray(branchArray);
        return branchArray;
    }

    public Alias getAlias(String revisionNamePathBranch, String url) {
        String[] aliasParts;
        boolean branch = false;
        Alias alias = null;
        if (revisionNamePathBranch != null && revisionNamePathBranch.length() > 0 && (aliasParts = revisionNamePathBranch.split(",")).length > 1) {
            int revision;
            try {
                revision = Integer.parseInt(aliasParts[0]);
            }
            catch (Exception exception) {
                return null;
            }
            String name = aliasParts[1];
            String relativePath = null;
            if (aliasParts.length > 2) {
                relativePath = aliasParts[2];
            }
            if (aliasParts.length > 3) {
                branch = aliasParts[3].equalsIgnoreCase("branch");
            }
            alias = new Alias(revision, name, relativePath, url);
            alias.setBranch(branch);
        }
        return alias;
    }

    public static String getAliasesAsString(Alias[] aliases) {
        if (aliases == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int i = 0;
        while (i < aliases.length) {
            if (i != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(aliases[i].getName());
            ++i;
        }
        return stringBuffer.toString();
    }

    public static String transformUrl(IResource resource, Alias alias) {
        String aliasUrl = alias.getUrl();
        ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor(resource);
        ISVNRepositoryLocation repository = svnResource.getRepository();
        String a = svnResource.getUrl().toString().length() <= aliasUrl.length() ? "" : svnResource.getUrl().toString().substring(aliasUrl.length());
        String b = repository.getUrl().toString();
        String c = alias.getRelativePath() == null ? "" : alias.getRelativePath();
        return String.valueOf(b) + c + a;
    }

    public Alias[] getAliases(IResource resource) {
        Object[] aliases = this.getAliases(resource, true);
        Arrays.sort(aliases);
        return aliases;
    }

    private Alias[] getAliases(IResource resource, boolean checkParents) {
        ArrayList<Alias> aliases = new ArrayList<Alias>();
        if (resource != null) {
            ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor(resource);
            try {
                if (svnResource.isManaged()) {
                    ISVNProperty property = null;
                    property = svnResource.getSvnProperty("subclipse:tags");
                    if (property != null && property.getValue() != null) {
                        this.getAliases(aliases, property.getValue(), svnResource.getUrl().toString());
                    }
                    if (checkParents) {
                        IResource checkResource = resource;
                        while (checkResource.getParent() != null) {
                            Alias[] parentAliases;
                            checkResource = checkResource.getParent();
                            Alias[] aliasArray = parentAliases = this.getAliases(checkResource, false);
                            int n = parentAliases.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Alias parentAlias = aliasArray[n2];
                                if (aliases.contains(parentAlias)) {
                                    Alias checkAlias = aliases.get(aliases.indexOf(parentAlias));
                                    if (parentAlias.getRevision() < checkAlias.getRevision()) {
                                        aliases.remove(checkAlias);
                                        aliases.add(parentAlias);
                                    }
                                } else {
                                    aliases.add(parentAlias);
                                }
                                ++n2;
                            }
                        }
                    }
                }
            }
            catch (SVNException sVNException) {}
        }
        Alias[] aliasArray = new Alias[aliases.size()];
        aliases.toArray(aliasArray);
        return aliasArray;
    }

    public Alias[] getAliases(SVNUrl url) {
        Object[] aliases = this.getAliases(url, true);
        Arrays.sort(aliases);
        return aliases;
    }

    private Alias[] getAliases(SVNUrl url, boolean checkParents) {
        ArrayList<Alias> aliases = new ArrayList<Alias>();
        ISVNClientAdapter client = null;
        try {
            client = SVNProviderPlugin.getPlugin().getSVNClient();
            ISVNProperty property = null;
            SVNProviderPlugin.disableConsoleLogging();
            property = client.propertyGet(url, "subclipse:tags");
            SVNProviderPlugin.enableConsoleLogging();
            if (property != null && property.getValue() != null) {
                this.getAliases(aliases, property.getValue(), url.toString());
            } else if (url.getParent() != null && checkParents) {
                Alias[] aliasArray = this.getAliases(url.getParent(), checkParents);
                return aliasArray;
            }
        }
        catch (SVNClientException sVNClientException) {
        }
        catch (SVNException sVNException) {
        }
        finally {
            SVNProviderPlugin.enableConsoleLogging();
            SVNProviderPlugin.getPlugin().getSVNClientManager().returnSVNClient(client);
        }
        Alias[] aliasArray = new Alias[aliases.size()];
        aliases.toArray(aliasArray);
        return aliasArray;
    }

    private void getAliases(ArrayList<Alias> aliases, String propertyValue, String url) {
        StringReader reader = new StringReader(propertyValue);
        BufferedReader bReader = new BufferedReader(reader);
        try {
            String line = bReader.readLine();
            while (line != null) {
                Alias alias = this.getAlias(line, url);
                if (aliases.contains(alias)) {
                    Alias checkAlias = aliases.get(aliases.indexOf(alias));
                    if (alias.getRevision() < checkAlias.getRevision()) {
                        aliases.remove(checkAlias);
                        aliases.add(alias);
                    }
                } else if (alias != null) {
                    aliases.add(alias);
                }
                line = bReader.readLine();
            }
            bReader.close();
        }
        catch (Exception exception) {}
    }
}

