/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.status;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.QualifiedName;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.commands.GetInfoCommand;
import org.tigris.subversion.subclipse.core.resources.LocalResourceStatus;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.core.status.IStatusCache;
import org.tigris.subversion.subclipse.core.status.NonRecursiveStatusUpdateStrategy;
import org.tigris.subversion.subclipse.core.status.RecursiveStatusUpdateStrategy;
import org.tigris.subversion.subclipse.core.status.StatusUpdateStrategy;
import org.tigris.subversion.subclipse.core.status.SynchronizerSyncInfoCache;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;
import org.tigris.subversion.svnclientadapter.SVNStatusUnversioned;

public class StatusCacheManager
implements IResourceChangeListener,
Preferences.IPropertyChangeListener {
    public static final QualifiedName SVN_BC_SYNC_KEY = new QualifiedName("org.tigris.subversion.subclipse.core", "svn-bc-sync-key");
    private IStatusCache statusCache;
    private StatusUpdateStrategy statusUpdateStrategy;
    private boolean flushCache;
    private boolean checkForReadOnly = SVNProviderPlugin.getPlugin().getPluginPreferences().getBoolean("show_read_only");

    public StatusCacheManager() {
        this.chooseUpdateStrategy();
        ResourcesPlugin.getWorkspace().getSynchronizer().add(SVN_BC_SYNC_KEY);
        this.statusCache = new SynchronizerSyncInfoCache();
    }

    private void chooseUpdateStrategy() {
        boolean recursiveStatusUpdate = SVNProviderPlugin.getPlugin().getPluginPreferences().getBoolean("resursive_status_update");
        this.statusUpdateStrategy = recursiveStatusUpdate ? new RecursiveStatusUpdateStrategy(this.statusCache) : new NonRecursiveStatusUpdateStrategy(this.statusCache);
    }

    public boolean hasCachedStatus(IResource resource) {
        return this.statusCache.hasCachedStatus(resource);
    }

    protected List<IResource> updateCache(IResource parent, ISVNStatus[] statuses) throws CoreException {
        ArrayList<IResource> result = new ArrayList<IResource>();
        if (statuses != null) {
            ISVNStatus[] iSVNStatusArray = statuses;
            int n = statuses.length;
            int n2 = 0;
            while (n2 < n) {
                ISVNStatus status = iSVNStatusArray[n2];
                IResource resource = SVNWorkspaceRoot.getResourceFor(parent, status);
                result.add(this.updateCache(resource, status));
                ++n2;
            }
        }
        return result;
    }

    public IResource updateCache(IResource resource, ISVNStatus status) {
        if (resource != null && status != null && status.getTextStatus() != null && !resource.exists() && status.getTextStatus().equals((Object)SVNStatusKind.MISSING) && (status.getLastChangedRevision() == null || status.getLastChangedRevision().getNumber() == -1L)) {
            this.statusCache.removeStatus(resource);
            return resource;
        }
        return this.statusCache.addStatus(resource, new LocalResourceStatus(status, this.getURL(status), this.checkForReadOnly));
    }

    public void removeStatus(IResource resource) {
        this.statusCache.removeStatus(resource);
    }

    public LocalResourceStatus getStatus(IResource resource) throws SVNException {
        return this.getStatus(resource, this.statusUpdateStrategy, true);
    }

    public LocalResourceStatus getStatusFromCache(IResource resource) throws SVNException {
        return this.getStatus(resource, this.statusUpdateStrategy, false);
    }

    public LocalResourceStatus getStatus(IResource resource, boolean useRecursiveStartegy) throws SVNException {
        return this.getStatus(resource, useRecursiveStartegy ? new RecursiveStatusUpdateStrategy(this.statusCache) : new NonRecursiveStatusUpdateStrategy(this.statusCache), true);
    }

    public SVNRevision getResourceRevision(ISVNLocalResource resource) throws SVNException {
        if (resource == null) {
            return null;
        }
        GetInfoCommand command = new GetInfoCommand(resource);
        command.run(null);
        ISVNInfo info = command.getInfo();
        return info != null ? info.getRevision() : null;
    }

    private LocalResourceStatus getStatus(IResource resource, StatusUpdateStrategy strategy, boolean getStatusFromSvn) throws SVNException {
        if (!resource.exists() && !resource.isPhantom()) {
            return null;
        }
        LocalResourceStatus status = null;
        status = this.statusCache.getStatus(resource);
        if (status == null && getStatusFromSvn) {
            status = this.basicGetStatus(resource, strategy);
        }
        return status;
    }

    private LocalResourceStatus basicGetStatus(IResource resource, StatusUpdateStrategy strategy) throws SVNException {
        if (!resource.exists()) {
            return LocalResourceStatus.NONE;
        }
        LocalResourceStatus status = null;
        strategy.setStatusCache(this.statusCache);
        this.setStatuses(resource, strategy.statusesToUpdate(resource));
        status = this.statusCache.getStatus(resource);
        if (status == null && resource != null && resource.getLocation() != null) {
            status = new LocalResourceStatus((ISVNStatus)new SVNStatusUnversioned(resource.getLocation().toFile(), false), null, this.checkForReadOnly);
        }
        return status;
    }

    public void setStatuses(IResource parent, ISVNStatus[] statuses) throws SVNException {
        try {
            this.updateCache(parent, statuses);
        }
        catch (CoreException e) {
            throw SVNException.wrapException(e);
        }
    }

    public IResource[] refreshStatus(IResource resource, boolean recursive) throws SVNException {
        if (SVNWorkspaceRoot.isLinkedResource(resource)) {
            return new IResource[0];
        }
        int depth = recursive ? 2 : 1;
        StatusUpdateStrategy strategy = depth == 2 ? new RecursiveStatusUpdateStrategy(this.statusCache) : new NonRecursiveStatusUpdateStrategy(this.statusCache);
        try {
            List<IResource> refreshedResources = this.updateCache(resource, strategy.statusesToUpdate(resource));
            Set<IResource> resourcesToRefresh = this.resourcesToRefresh(resource, depth, 1, refreshedResources.size());
            Iterator<IResource> iter = refreshedResources.iterator();
            while (iter.hasNext()) {
                resourcesToRefresh.remove(iter.next());
            }
            for (IResource res : resourcesToRefresh) {
                if (res.getType() != 1 && res.isPhantom()) {
                    Set<IResource> children = this.resourcesToRefresh(res, 2, 3, 0);
                    for (IResource child : children) {
                        this.statusCache.removeStatus(child);
                        refreshedResources.add(child);
                    }
                }
                this.statusCache.removeStatus(res);
                refreshedResources.add(res);
            }
            return refreshedResources.toArray(new IResource[refreshedResources.size()]);
        }
        catch (CoreException e) {
            throw SVNException.wrapException(e);
        }
    }

    private Set<IResource> resourcesToRefresh(IResource resource, int depth, int flags, int expectedSize) throws CoreException {
        if (!resource.exists() && !resource.isPhantom()) {
            return new HashSet<IResource>(0);
        }
        final HashSet<IResource> resultSet = expectedSize != 0 ? new HashSet<IResource>(expectedSize) : new HashSet();
        resource.accept(new IResourceVisitor(){

            public boolean visit(IResource aResource) throws CoreException {
                resultSet.add(aResource);
                return true;
            }
        }, depth, flags);
        return resultSet;
    }

    public void purgeCache(IContainer root, boolean deep) throws SVNException {
        this.statusCache.purgeCache(root, deep);
    }

    public void propertyChange(Preferences.PropertyChangeEvent event) {
        if ("resursive_status_update".equals(event.getProperty())) {
            this.chooseUpdateStrategy();
        } else if ("show_read_only".equals(event.getProperty())) {
            this.checkForReadOnly = SVNProviderPlugin.getPlugin().getPluginPreferences().getBoolean("show_read_only");
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        this.flushCache = false;
        try {
            event.getDelta().accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) throws CoreException {
                    IResource resource = delta.getResource();
                    if (resource.getType() == 4) {
                        IProject project = (IProject)resource;
                        if (!project.isAccessible()) {
                            return false;
                        }
                        if (SVNWorkspaceRoot.isManagedBySubclipse(project)) {
                            StatusCacheManager.this.flushCache = true;
                        }
                        return false;
                    }
                    return true;
                }
            });
        }
        catch (CoreException e) {
            SVNProviderPlugin.log(e.getStatus());
        }
        if (this.flushCache) {
            this.statusCache.flushPendingStatuses();
        }
    }

    /*
     * Exception decompiling
     */
    private String getURL(ISVNStatus status) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IndexOutOfBoundsException: Index: 0, Size: 0
         *     at java.base/java.util.LinkedList.checkElementIndex(LinkedList.java:566)
         *     at java.base/java.util.LinkedList.get(LinkedList.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.combineInlineable(Block.java:226)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:560)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredCatch.transformStructuredChildren(StructuredCatch.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredTry.transformStructuredChildren(StructuredTry.java:129)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredTry.transformStructuredChildren(StructuredTry.java:127)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredIf.transformStructuredChildren(StructuredIf.java:96)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.inlinePossibles(Op04StructuredStatement.java:709)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:855)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

