/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.util;

import java.util.ArrayList;
import java.util.List;
import org.tigris.subversion.subclipse.core.util.Assert;
import org.tigris.subversion.subclipse.core.util.StringMatcher;

public class FileNameMatcher {
    private List<StringMatcher> matchers = new ArrayList<StringMatcher>();
    private List<String> results = new ArrayList<String>();
    private static final String TRUE = "true";

    public FileNameMatcher() {
    }

    public FileNameMatcher(String[] patterns) {
        this.register(patterns);
    }

    void register(String[] patterns) {
        String[] stringArray = patterns;
        int n = patterns.length;
        int n2 = 0;
        while (n2 < n) {
            String pattern = stringArray[n2];
            this.register(pattern, TRUE);
            ++n2;
        }
    }

    public void register(String pattern, String result) {
        Assert.isTrue(this.matchers.size() == this.results.size());
        pattern = pattern.trim();
        if (pattern.length() == 0) {
            return;
        }
        this.matchers.add(new StringMatcher(pattern, false, false));
        this.results.add(result);
    }

    public String getMatch(String name) {
        int i = 0;
        while (i < this.matchers.size()) {
            StringMatcher stringMatcher = this.matchers.get(i);
            if (stringMatcher.match(name)) {
                return this.results.get(i);
            }
            ++i;
        }
        return null;
    }

    public boolean match(String name) {
        return this.getMatch(name) != null;
    }
}

